/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.box;

import com.box.sdk.BoxUser;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.clouddrive.CloudDrive;
import org.exoplatform.clouddrive.CloudDriveConnector;
import org.exoplatform.clouddrive.CloudDriveException;
import org.exoplatform.clouddrive.CloudProvider;
import org.exoplatform.clouddrive.CloudUser;
import org.exoplatform.clouddrive.ConfigurationException;
import org.exoplatform.clouddrive.DriveRemovedException;
import org.exoplatform.clouddrive.box.BoxAPI;
import org.exoplatform.clouddrive.box.BoxException;
import org.exoplatform.clouddrive.box.BoxProvider;
import org.exoplatform.clouddrive.box.BoxUser;
import org.exoplatform.clouddrive.box.JCRLocalBoxDrive;
import org.exoplatform.clouddrive.jcr.JCRLocalCloudDrive;
import org.exoplatform.clouddrive.jcr.NodeFinder;
import org.exoplatform.clouddrive.utils.ExtendedMimeTypeResolver;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;

public class BoxConnector
extends CloudDriveConnector {
    public static final String CONFIG_LOGIN_SSO_PARTNERIDPID = "box-sso-partneridpid";
    public static final String CONFIG_LOGIN_SSO_URL = "box-sso-url";

    public BoxConnector(RepositoryService jcrService, SessionProviderService sessionProviders, NodeFinder finder, ExtendedMimeTypeResolver mimeTypes, InitParams params) throws ConfigurationException {
        super(jcrService, sessionProviders, finder, mimeTypes, params);
    }

    protected BoxProvider getProvider() {
        return (BoxProvider)super.getProvider();
    }

    protected String getConnectorHost() {
        if (this.getConnectorSchema().equalsIgnoreCase("https")) {
            return super.getConnectorHost();
        }
        String[] host = super.getConnectorHost().split(":");
        StringBuilder newHost = new StringBuilder();
        newHost.append("localhost");
        if (host.length > 1) {
            newHost.append(':');
            newHost.append(host[1]);
        }
        LOG.warn((Object)"Box connector supports only HTTPS for server redirect. Switched to localhost (Box's Development Mode).");
        return newHost.toString();
    }

    protected CloudProvider createProvider() {
        String redirectURL = this.redirectLink();
        StringBuilder oauthURL = new StringBuilder();
        oauthURL.append("https://");
        if (this.loginSSO) {
            oauthURL.append("app");
        } else {
            oauthURL.append("www");
        }
        oauthURL.append(".box.com/api/oauth2/authorize?");
        oauthURL.append("response_type=code&client_id=");
        String clientId = this.getClientId();
        try {
            oauthURL.append(URLEncoder.encode(clientId, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn((Object)("Cannot encode client id " + clientId + ":" + e));
            oauthURL.append(clientId);
        }
        oauthURL.append("&state=");
        try {
            oauthURL.append(URLEncoder.encode("__no_state_set__", "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn((Object)("Cannot encode state __no_state_set__:" + e));
            oauthURL.append("__no_state_set__");
        }
        oauthURL.append("&redirect_uri=");
        StringBuilder authURL = new StringBuilder();
        if (this.loginSSO) {
            String ssoURL = (String)this.config.get(CONFIG_LOGIN_SSO_URL);
            if (ssoURL != null && (ssoURL = ssoURL.trim()).length() > 0) {
                authURL.append(ssoURL);
            } else {
                String ssoPartnerIdpId = (String)this.config.get(CONFIG_LOGIN_SSO_PARTNERIDPID);
                if (ssoPartnerIdpId != null && (ssoPartnerIdpId = ssoPartnerIdpId.trim()).length() > 0) {
                    authURL.append("https://sso.services.box.net/sp/startSSO.ping?PartnerIdpId=");
                    authURL.append(ssoPartnerIdpId);
                    authURL.append("&TargetResource=");
                } else {
                    LOG.warn((Object)"SSO enabled but box-sso-partneridpid not configured. SSO will not be forced for Box connect.");
                }
            }
            oauthURL.append(redirectURL);
            try {
                authURL.append(URLEncoder.encode(oauthURL.toString(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                LOG.warn((Object)("Cannot encode auth URL " + oauthURL.toString() + ":" + e));
                authURL.append((CharSequence)oauthURL);
            }
        } else {
            try {
                oauthURL.append(URLEncoder.encode(redirectURL, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                LOG.warn((Object)("Cannot encode redirect URL " + redirectURL + ":" + e));
                oauthURL.append(redirectURL);
            }
            authURL.append((CharSequence)oauthURL);
        }
        return new BoxProvider(this.getProviderId(), this.getProviderName(), authURL.toString(), redirectURL, this.loginSSO, this.jcrService);
    }

    protected CloudUser authenticate(Map<String, String> params) throws CloudDriveException {
        String code = params.get("code");
        if (code != null && code.length() > 0) {
            BoxAPI driveAPI = new API().auth(code).build();
            BoxUser.Info buser = driveAPI.getCurrentUser();
            BoxUser user = new BoxUser(buser.getID(), buser.getName(), buser.getLogin(), this.provider, driveAPI);
            return user;
        }
        throw new CloudDriveException("Access code should not be null or empty");
    }

    protected CloudDrive createDrive(CloudUser user, Node driveNode) throws CloudDriveException, RepositoryException {
        if (user instanceof BoxUser) {
            BoxUser boxUser = (BoxUser)user;
            JCRLocalBoxDrive drive = new JCRLocalBoxDrive(boxUser, driveNode, this.sessionProviders, this.jcrFinder, this.mimeTypes);
            return drive;
        }
        throw new CloudDriveException("Not Box user: " + user);
    }

    protected CloudDrive loadDrive(Node driveNode) throws DriveRemovedException, CloudDriveException, RepositoryException {
        JCRLocalCloudDrive.checkNotTrashed((Node)driveNode);
        JCRLocalCloudDrive.migrateName((Node)driveNode);
        JCRLocalBoxDrive drive = new JCRLocalBoxDrive(new API(), this.getProvider(), driveNode, this.sessionProviders, this.jcrFinder, this.mimeTypes);
        return drive;
    }

    class API {
        String code;
        String refreshToken;
        String accessToken;
        long expirationTime;

        API() {
        }

        API auth(String code) {
            this.code = code;
            return this;
        }

        API load(String refreshToken, String accessToken, long expirationTime) {
            this.refreshToken = refreshToken;
            this.accessToken = accessToken;
            this.expirationTime = expirationTime;
            return this;
        }

        BoxAPI build() throws BoxException, CloudDriveException {
            if (this.code != null && this.code.length() > 0) {
                return new BoxAPI(BoxConnector.this.getClientId(), BoxConnector.this.getClientSecret(), this.code, BoxConnector.this.getProvider().getRedirectURL());
            }
            return new BoxAPI(BoxConnector.this.getClientId(), BoxConnector.this.getClientSecret(), this.accessToken, this.refreshToken, this.expirationTime);
        }
    }
}

