/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.shaded.google.api.client.googleapis.auth.oauth2;

import java.util.Collection;
import org.exoplatform.clouddrive.shaded.google.api.client.auth.oauth2.BrowserClientRequestUrl;
import org.exoplatform.clouddrive.shaded.google.api.client.googleapis.auth.oauth2.GoogleClientSecrets;
import org.exoplatform.clouddrive.shaded.google.api.client.util.Key;
import org.exoplatform.clouddrive.shaded.google.api.client.util.Preconditions;

public class GoogleBrowserClientRequestUrl
extends BrowserClientRequestUrl {
    @Key(value="approval_prompt")
    private String approvalPrompt;

    public GoogleBrowserClientRequestUrl(String clientId, String redirectUri, Collection<String> scopes) {
        super("https://accounts.google.com/o/oauth2/auth", clientId);
        this.setRedirectUri(redirectUri);
        this.setScopes((Collection)scopes);
    }

    public GoogleBrowserClientRequestUrl(GoogleClientSecrets clientSecrets, String redirectUri, Collection<String> scopes) {
        this(clientSecrets.getDetails().getClientId(), redirectUri, scopes);
    }

    public final String getApprovalPrompt() {
        return this.approvalPrompt;
    }

    public GoogleBrowserClientRequestUrl setApprovalPrompt(String approvalPrompt) {
        this.approvalPrompt = approvalPrompt;
        return this;
    }

    @Override
    public GoogleBrowserClientRequestUrl setResponseTypes(Collection<String> responseTypes) {
        return (GoogleBrowserClientRequestUrl)super.setResponseTypes((Collection)responseTypes);
    }

    @Override
    public GoogleBrowserClientRequestUrl setRedirectUri(String redirectUri) {
        return (GoogleBrowserClientRequestUrl)super.setRedirectUri(redirectUri);
    }

    @Override
    public GoogleBrowserClientRequestUrl setScopes(Collection<String> scopes) {
        Preconditions.checkArgument(scopes.iterator().hasNext());
        return (GoogleBrowserClientRequestUrl)super.setScopes((Collection)scopes);
    }

    @Override
    public GoogleBrowserClientRequestUrl setClientId(String clientId) {
        return (GoogleBrowserClientRequestUrl)super.setClientId(clientId);
    }

    @Override
    public GoogleBrowserClientRequestUrl setState(String state) {
        return (GoogleBrowserClientRequestUrl)super.setState(state);
    }

    @Override
    public GoogleBrowserClientRequestUrl set(String fieldName, Object value) {
        return (GoogleBrowserClientRequestUrl)super.set(fieldName, value);
    }

    @Override
    public GoogleBrowserClientRequestUrl clone() {
        return (GoogleBrowserClientRequestUrl)super.clone();
    }
}

