/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.shaded.google.api.client.auth.oauth2;

import java.io.IOException;
import org.exoplatform.shaded.google.api.client.auth.oauth2.Credential;
import org.exoplatform.shaded.google.api.client.auth.oauth2.CredentialRefreshListener;
import org.exoplatform.shaded.google.api.client.auth.oauth2.StoredCredential;
import org.exoplatform.shaded.google.api.client.auth.oauth2.TokenErrorResponse;
import org.exoplatform.shaded.google.api.client.auth.oauth2.TokenResponse;
import org.exoplatform.shaded.google.api.client.util.Beta;
import org.exoplatform.shaded.google.api.client.util.Preconditions;
import org.exoplatform.shaded.google.api.client.util.store.DataStore;
import org.exoplatform.shaded.google.api.client.util.store.DataStoreFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public final class DataStoreCredentialRefreshListener
implements CredentialRefreshListener {
    private final DataStore<StoredCredential> credentialDataStore;
    private final String userId;

    public DataStoreCredentialRefreshListener(String userId, DataStoreFactory dataStoreFactory) throws IOException {
        this(userId, StoredCredential.getDefaultDataStore(dataStoreFactory));
    }

    public DataStoreCredentialRefreshListener(String userId, DataStore<StoredCredential> credentialDataStore) {
        this.userId = Preconditions.checkNotNull(userId);
        this.credentialDataStore = Preconditions.checkNotNull(credentialDataStore);
    }

    @Override
    public void onTokenResponse(Credential credential, TokenResponse tokenResponse) throws IOException {
        this.makePersistent(credential);
    }

    @Override
    public void onTokenErrorResponse(Credential credential, TokenErrorResponse tokenErrorResponse) throws IOException {
        this.makePersistent(credential);
    }

    public DataStore<StoredCredential> getCredentialDataStore() {
        return this.credentialDataStore;
    }

    public void makePersistent(Credential credential) throws IOException {
        this.credentialDataStore.set(this.userId, new StoredCredential(credential));
    }
}

