/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.ecms.action;

import java.util.ArrayList;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Node;
import org.exoplatform.clouddrive.CloudDrive;
import org.exoplatform.clouddrive.CloudDriveException;
import org.exoplatform.clouddrive.CloudDriveService;
import org.exoplatform.clouddrive.ecms.action.CloudFileActionService;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.popup.info.UIPermissionInfo;
import org.exoplatform.ecm.webui.core.UIPermissionInfoBase;
import org.exoplatform.ecm.webui.core.UIPermissionInfoGrid;
import org.exoplatform.ecm.webui.core.UIPermissionManagerBase;
import org.exoplatform.ecm.webui.core.bean.PermissionBean;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIGrid;
import org.exoplatform.webui.core.lifecycle.UIContainerLifecycle;
import org.exoplatform.webui.event.Event;

@ComponentConfig(lifecycle=UIContainerLifecycle.class, events={@EventConfig(listeners={DeleteActionListener.class}, confirm="UIPermissionInfo.msg.confirm-delete-permission"), @EventConfig(listeners={UIPermissionInfoBase.EditActionListener.class})})
public class UIPermissionInfo
extends org.exoplatform.ecm.webui.component.explorer.popup.info.UIPermissionInfo {
    protected static String[] PERMISSION_BEAN_FIELD = new String[]{"usersOrGroups"};
    protected static String[] PERMISSION_ACTION = new String[]{"Delete"};
    protected static final Log LOG = ExoLogger.getLogger(UIPermissionInfo.class);

    public UIPermissionInfo() throws Exception {
        UIPermissionInfoGrid uiGrid = (UIPermissionInfoGrid)this.getChild(UIPermissionInfoGrid.class);
        uiGrid.configure("usersOrGroups", PERMISSION_BEAN_FIELD, PERMISSION_ACTION);
    }

    public void updateGrid(int currentPage) throws Exception {
        super.updateGrid(currentPage);
        UIGrid uiGrid = (UIGrid)this.findFirstComponentOfType(UIGrid.class);
        PageList dataPageList = uiGrid.getUIPageIterator().getPageList();
        ArrayList<PermissionBean> permBeans = new ArrayList<PermissionBean>();
        boolean filtered = false;
        block0: for (PermissionBean permBean : dataPageList.getAll()) {
            String permission = permBean.getUsersOrGroups();
            String[] ids = permission.split(":");
            if (ids.length == 2) {
                String membership = ids[0];
                String identity = ids[1];
                if (membership.equals("manager")) {
                    for (PermissionBean gpb : dataPageList.getAll()) {
                        String gpermission = gpb.getUsersOrGroups();
                        String[] gids = gpermission.split(":");
                        if (gids.length != 2) continue;
                        String gmembership = gids[0];
                        String gidentity = gids[1];
                        if (!identity.equals(gidentity) || membership.equals(gmembership)) continue;
                        filtered = true;
                        continue block0;
                    }
                }
            }
            permBeans.add(permBean);
        }
        if (filtered) {
            ListAccessImpl permList = new ListAccessImpl(PermissionBean.class, permBeans);
            dataPageList = new LazyPageList((ListAccess)permList, 10);
            uiGrid.getUIPageIterator().setPageList(dataPageList);
            if (currentPage > uiGrid.getUIPageIterator().getAvailablePage()) {
                uiGrid.getUIPageIterator().setCurrentPage(uiGrid.getUIPageIterator().getAvailablePage());
            } else {
                uiGrid.getUIPageIterator().setCurrentPage(currentPage);
            }
        }
    }

    public static class DeleteActionListener
    extends UIPermissionInfo.DeleteActionListener {
        public void execute(Event<org.exoplatform.ecm.webui.component.explorer.popup.info.UIPermissionInfo> event) throws Exception {
            UIPermissionInfo uiComp = (UIPermissionInfo)((Object)event.getSource());
            UIJCRExplorer uiJCRExplorer = (UIJCRExplorer)uiComp.getAncestorOfType(UIJCRExplorer.class);
            UIPermissionManagerBase uiParent = (UIPermissionManagerBase)uiComp.getParent();
            Node currentNode = uiComp.getCurrentNode();
            String userOrGroup = event.getRequestContext().getRequestParameter("objectId");
            String[] groupIdentity = userOrGroup.split(":");
            String identity = groupIdentity.length == 2 ? groupIdentity[1] : userOrGroup;
            CloudDriveService cloudDrives = (CloudDriveService)uiComp.getApplicationComponent(CloudDriveService.class);
            CloudDrive localDrive = cloudDrives.findDrive(currentNode);
            if (localDrive != null) {
                try {
                    CloudFileActionService actions = (CloudFileActionService)uiComp.getApplicationComponent(CloudFileActionService.class);
                    actions.removeLinks(currentNode, identity);
                    actions.unshareCloudFile(currentNode, localDrive, userOrGroup);
                }
                catch (Exception e) {
                    throw new CloudDriveException("Error invoking Delete action in Sharing info: " + e.getMessage(), (Throwable)e);
                }
            } else {
                LOG.warn((Object)("Cloud Drive cannot be found for " + currentNode.getPath()));
            }
            try {
                currentNode.getIndex();
                uiComp.updateGrid(((UIGrid)uiComp.getChild(UIGrid.class)).getUIPageIterator().getCurrentPage());
                uiJCRExplorer.setIsHidePopup(true);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiParent);
            }
            catch (InvalidItemStateException e) {
                uiJCRExplorer.setCurrentPath(uiJCRExplorer.getRootPath());
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiJCRExplorer);
            }
        }
    }
}

