/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.team.GroupSelector;
import com.dropbox.core.v2.team.IncludeMembersArg;
import com.dropbox.core.v2.team.UserSelectorArg;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

class GroupMembersRemoveArg
extends IncludeMembersArg {
    protected final GroupSelector group;
    protected final List<UserSelectorArg> users;

    public GroupMembersRemoveArg(GroupSelector group, List<UserSelectorArg> users, boolean returnMembers) {
        super(returnMembers);
        if (group == null) {
            throw new IllegalArgumentException("Required value for 'group' is null");
        }
        this.group = group;
        if (users == null) {
            throw new IllegalArgumentException("Required value for 'users' is null");
        }
        for (UserSelectorArg x : users) {
            if (x != null) continue;
            throw new IllegalArgumentException("An item in list 'users' is null");
        }
        this.users = users;
    }

    public GroupMembersRemoveArg(GroupSelector group, List<UserSelectorArg> users) {
        this(group, users, true);
    }

    public GroupSelector getGroup() {
        return this.group;
    }

    public List<UserSelectorArg> getUsers() {
        return this.users;
    }

    @Override
    public boolean getReturnMembers() {
        return this.returnMembers;
    }

    @Override
    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.group, this.users});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            GroupMembersRemoveArg other = (GroupMembersRemoveArg)obj;
            return !(this.group != other.group && !this.group.equals(other.group) || this.users != other.users && !this.users.equals(other.users) || this.returnMembers != other.returnMembers);
        }
        return false;
    }

    @Override
    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    @Override
    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<GroupMembersRemoveArg> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(GroupMembersRemoveArg value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("group");
            GroupSelector.Serializer.INSTANCE.serialize(value.group, g);
            g.writeFieldName("users");
            StoneSerializers.list(UserSelectorArg.Serializer.INSTANCE).serialize(value.users, g);
            g.writeFieldName("return_members");
            StoneSerializers.boolean_().serialize((Boolean)value.returnMembers, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public GroupMembersRemoveArg deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Boolean f_returnMembers;
            List<UserSelectorArg> f_users;
            GroupSelector f_group;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_group = null;
                f_users = null;
                f_returnMembers = true;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("group".equals(field)) {
                        f_group = GroupSelector.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("users".equals(field)) {
                        f_users = StoneSerializers.list(UserSelectorArg.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("return_members".equals(field)) {
                        f_returnMembers = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_group == null) {
                    throw new JsonParseException(p, "Required field \"group\" missing.");
                }
                if (f_users == null) {
                    throw new JsonParseException(p, "Required field \"users\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            GroupMembersRemoveArg value = new GroupMembersRemoveArg(f_group, f_users, f_returnMembers);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }
}

