/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

class ListMemberDevicesArg {
    protected final String teamMemberId;
    protected final boolean includeWebSessions;
    protected final boolean includeDesktopClients;
    protected final boolean includeMobileClients;

    public ListMemberDevicesArg(String teamMemberId, boolean includeWebSessions, boolean includeDesktopClients, boolean includeMobileClients) {
        if (teamMemberId == null) {
            throw new IllegalArgumentException("Required value for 'teamMemberId' is null");
        }
        this.teamMemberId = teamMemberId;
        this.includeWebSessions = includeWebSessions;
        this.includeDesktopClients = includeDesktopClients;
        this.includeMobileClients = includeMobileClients;
    }

    public ListMemberDevicesArg(String teamMemberId) {
        this(teamMemberId, true, true, true);
    }

    public String getTeamMemberId() {
        return this.teamMemberId;
    }

    public boolean getIncludeWebSessions() {
        return this.includeWebSessions;
    }

    public boolean getIncludeDesktopClients() {
        return this.includeDesktopClients;
    }

    public boolean getIncludeMobileClients() {
        return this.includeMobileClients;
    }

    public static Builder newBuilder(String teamMemberId) {
        return new Builder(teamMemberId);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.teamMemberId, this.includeWebSessions, this.includeDesktopClients, this.includeMobileClients});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            ListMemberDevicesArg other = (ListMemberDevicesArg)obj;
            return (this.teamMemberId == other.teamMemberId || this.teamMemberId.equals(other.teamMemberId)) && this.includeWebSessions == other.includeWebSessions && this.includeDesktopClients == other.includeDesktopClients && this.includeMobileClients == other.includeMobileClients;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<ListMemberDevicesArg> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(ListMemberDevicesArg value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("team_member_id");
            StoneSerializers.string().serialize(value.teamMemberId, g);
            g.writeFieldName("include_web_sessions");
            StoneSerializers.boolean_().serialize((Boolean)value.includeWebSessions, g);
            g.writeFieldName("include_desktop_clients");
            StoneSerializers.boolean_().serialize((Boolean)value.includeDesktopClients, g);
            g.writeFieldName("include_mobile_clients");
            StoneSerializers.boolean_().serialize((Boolean)value.includeMobileClients, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public ListMemberDevicesArg deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Boolean f_includeMobileClients;
            Boolean f_includeDesktopClients;
            Boolean f_includeWebSessions;
            String f_teamMemberId;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_teamMemberId = null;
                f_includeWebSessions = true;
                f_includeDesktopClients = true;
                f_includeMobileClients = true;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("team_member_id".equals(field)) {
                        f_teamMemberId = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("include_web_sessions".equals(field)) {
                        f_includeWebSessions = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("include_desktop_clients".equals(field)) {
                        f_includeDesktopClients = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("include_mobile_clients".equals(field)) {
                        f_includeMobileClients = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_teamMemberId == null) {
                    throw new JsonParseException(p, "Required field \"team_member_id\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            ListMemberDevicesArg value = new ListMemberDevicesArg(f_teamMemberId, f_includeWebSessions, f_includeDesktopClients, f_includeMobileClients);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static class Builder {
        protected final String teamMemberId;
        protected boolean includeWebSessions;
        protected boolean includeDesktopClients;
        protected boolean includeMobileClients;

        protected Builder(String teamMemberId) {
            if (teamMemberId == null) {
                throw new IllegalArgumentException("Required value for 'teamMemberId' is null");
            }
            this.teamMemberId = teamMemberId;
            this.includeWebSessions = true;
            this.includeDesktopClients = true;
            this.includeMobileClients = true;
        }

        public Builder withIncludeWebSessions(Boolean includeWebSessions) {
            this.includeWebSessions = includeWebSessions != null ? includeWebSessions : true;
            return this;
        }

        public Builder withIncludeDesktopClients(Boolean includeDesktopClients) {
            this.includeDesktopClients = includeDesktopClients != null ? includeDesktopClients : true;
            return this;
        }

        public Builder withIncludeMobileClients(Boolean includeMobileClients) {
            this.includeMobileClients = includeMobileClients != null ? includeMobileClients : true;
            return this;
        }

        public ListMemberDevicesArg build() {
            return new ListMemberDevicesArg(this.teamMemberId, this.includeWebSessions, this.includeDesktopClients, this.includeMobileClients);
        }
    }
}

