/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.teamlog;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.team.DesktopPlatform;
import com.dropbox.core.v2.teamlog.DesktopSessionLogInfo;
import com.dropbox.core.v2.teamlog.DeviceSessionLogInfo;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;

public class DesktopDeviceSessionLogInfo
extends DeviceSessionLogInfo {
    protected final DesktopSessionLogInfo sessionInfo;
    protected final String hostName;
    protected final DesktopPlatform clientType;
    protected final String clientVersion;
    protected final String platform;
    protected final boolean isDeleteOnUnlinkSupported;

    public DesktopDeviceSessionLogInfo(String hostName, DesktopPlatform clientType, String platform, boolean isDeleteOnUnlinkSupported, String ipAddress, Date created, Date updated, DesktopSessionLogInfo sessionInfo, String clientVersion) {
        super(ipAddress, created, updated);
        this.sessionInfo = sessionInfo;
        if (hostName == null) {
            throw new IllegalArgumentException("Required value for 'hostName' is null");
        }
        this.hostName = hostName;
        if (clientType == null) {
            throw new IllegalArgumentException("Required value for 'clientType' is null");
        }
        this.clientType = clientType;
        this.clientVersion = clientVersion;
        if (platform == null) {
            throw new IllegalArgumentException("Required value for 'platform' is null");
        }
        this.platform = platform;
        this.isDeleteOnUnlinkSupported = isDeleteOnUnlinkSupported;
    }

    public DesktopDeviceSessionLogInfo(String hostName, DesktopPlatform clientType, String platform, boolean isDeleteOnUnlinkSupported) {
        this(hostName, clientType, platform, isDeleteOnUnlinkSupported, null, null, null, null, null);
    }

    public String getHostName() {
        return this.hostName;
    }

    public DesktopPlatform getClientType() {
        return this.clientType;
    }

    public String getPlatform() {
        return this.platform;
    }

    public boolean getIsDeleteOnUnlinkSupported() {
        return this.isDeleteOnUnlinkSupported;
    }

    @Override
    public String getIpAddress() {
        return this.ipAddress;
    }

    @Override
    public Date getCreated() {
        return this.created;
    }

    @Override
    public Date getUpdated() {
        return this.updated;
    }

    public DesktopSessionLogInfo getSessionInfo() {
        return this.sessionInfo;
    }

    public String getClientVersion() {
        return this.clientVersion;
    }

    public static Builder newBuilder(String hostName, DesktopPlatform clientType, String platform, boolean isDeleteOnUnlinkSupported) {
        return new Builder(hostName, clientType, platform, isDeleteOnUnlinkSupported);
    }

    @Override
    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.sessionInfo, this.hostName, this.clientType, this.clientVersion, this.platform, this.isDeleteOnUnlinkSupported});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            DesktopDeviceSessionLogInfo other = (DesktopDeviceSessionLogInfo)obj;
            return !(this.hostName != other.hostName && !this.hostName.equals(other.hostName) || this.clientType != other.clientType && !this.clientType.equals((Object)other.clientType) || this.platform != other.platform && !this.platform.equals(other.platform) || this.isDeleteOnUnlinkSupported != other.isDeleteOnUnlinkSupported || this.ipAddress != other.ipAddress && (this.ipAddress == null || !this.ipAddress.equals(other.ipAddress)) || this.created != other.created && (this.created == null || !this.created.equals(other.created)) || this.updated != other.updated && (this.updated == null || !this.updated.equals(other.updated)) || this.sessionInfo != other.sessionInfo && (this.sessionInfo == null || !this.sessionInfo.equals(other.sessionInfo)) || this.clientVersion != other.clientVersion && (this.clientVersion == null || !this.clientVersion.equals(other.clientVersion)));
        }
        return false;
    }

    @Override
    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    @Override
    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<DesktopDeviceSessionLogInfo> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(DesktopDeviceSessionLogInfo value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            this.writeTag("desktop_device_session", g);
            g.writeFieldName("host_name");
            StoneSerializers.string().serialize(value.hostName, g);
            g.writeFieldName("client_type");
            DesktopPlatform.Serializer.INSTANCE.serialize(value.clientType, g);
            g.writeFieldName("platform");
            StoneSerializers.string().serialize(value.platform, g);
            g.writeFieldName("is_delete_on_unlink_supported");
            StoneSerializers.boolean_().serialize((Boolean)value.isDeleteOnUnlinkSupported, g);
            if (value.ipAddress != null) {
                g.writeFieldName("ip_address");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.ipAddress, g);
            }
            if (value.created != null) {
                g.writeFieldName("created");
                StoneSerializers.nullable(StoneSerializers.timestamp()).serialize(value.created, g);
            }
            if (value.updated != null) {
                g.writeFieldName("updated");
                StoneSerializers.nullable(StoneSerializers.timestamp()).serialize(value.updated, g);
            }
            if (value.sessionInfo != null) {
                g.writeFieldName("session_info");
                StoneSerializers.nullableStruct(DesktopSessionLogInfo.Serializer.INSTANCE).serialize(value.sessionInfo, g);
            }
            if (value.clientVersion != null) {
                g.writeFieldName("client_version");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.clientVersion, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public DesktopDeviceSessionLogInfo deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            String f_clientVersion;
            DesktopSessionLogInfo f_sessionInfo;
            Date f_updated;
            Date f_created;
            String f_ipAddress;
            Boolean f_isDeleteOnUnlinkSupported;
            String f_platform;
            DesktopPlatform f_clientType;
            String f_hostName;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
                if ("desktop_device_session".equals(tag)) {
                    tag = null;
                }
            }
            if (tag == null) {
                f_hostName = null;
                f_clientType = null;
                f_platform = null;
                f_isDeleteOnUnlinkSupported = null;
                f_ipAddress = null;
                f_created = null;
                f_updated = null;
                f_sessionInfo = null;
                f_clientVersion = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("host_name".equals(field)) {
                        f_hostName = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("client_type".equals(field)) {
                        f_clientType = DesktopPlatform.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("platform".equals(field)) {
                        f_platform = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("is_delete_on_unlink_supported".equals(field)) {
                        f_isDeleteOnUnlinkSupported = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("ip_address".equals(field)) {
                        f_ipAddress = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("created".equals(field)) {
                        f_created = StoneSerializers.nullable(StoneSerializers.timestamp()).deserialize(p);
                        continue;
                    }
                    if ("updated".equals(field)) {
                        f_updated = StoneSerializers.nullable(StoneSerializers.timestamp()).deserialize(p);
                        continue;
                    }
                    if ("session_info".equals(field)) {
                        f_sessionInfo = StoneSerializers.nullableStruct(DesktopSessionLogInfo.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("client_version".equals(field)) {
                        f_clientVersion = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_hostName == null) {
                    throw new JsonParseException(p, "Required field \"host_name\" missing.");
                }
                if (f_clientType == null) {
                    throw new JsonParseException(p, "Required field \"client_type\" missing.");
                }
                if (f_platform == null) {
                    throw new JsonParseException(p, "Required field \"platform\" missing.");
                }
                if (f_isDeleteOnUnlinkSupported == null) {
                    throw new JsonParseException(p, "Required field \"is_delete_on_unlink_supported\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            DesktopDeviceSessionLogInfo value = new DesktopDeviceSessionLogInfo(f_hostName, f_clientType, f_platform, f_isDeleteOnUnlinkSupported, f_ipAddress, f_created, f_updated, f_sessionInfo, f_clientVersion);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static class Builder
    extends DeviceSessionLogInfo.Builder {
        protected final String hostName;
        protected final DesktopPlatform clientType;
        protected final String platform;
        protected final boolean isDeleteOnUnlinkSupported;
        protected DesktopSessionLogInfo sessionInfo;
        protected String clientVersion;

        protected Builder(String hostName, DesktopPlatform clientType, String platform, boolean isDeleteOnUnlinkSupported) {
            if (hostName == null) {
                throw new IllegalArgumentException("Required value for 'hostName' is null");
            }
            this.hostName = hostName;
            if (clientType == null) {
                throw new IllegalArgumentException("Required value for 'clientType' is null");
            }
            this.clientType = clientType;
            if (platform == null) {
                throw new IllegalArgumentException("Required value for 'platform' is null");
            }
            this.platform = platform;
            this.isDeleteOnUnlinkSupported = isDeleteOnUnlinkSupported;
            this.sessionInfo = null;
            this.clientVersion = null;
        }

        public Builder withSessionInfo(DesktopSessionLogInfo sessionInfo) {
            this.sessionInfo = sessionInfo;
            return this;
        }

        public Builder withClientVersion(String clientVersion) {
            this.clientVersion = clientVersion;
            return this;
        }

        @Override
        public Builder withIpAddress(String ipAddress) {
            super.withIpAddress(ipAddress);
            return this;
        }

        @Override
        public Builder withCreated(Date created) {
            super.withCreated(created);
            return this;
        }

        @Override
        public Builder withUpdated(Date updated) {
            super.withUpdated(updated);
            return this;
        }

        @Override
        public DesktopDeviceSessionLogInfo build() {
            return new DesktopDeviceSessionLogInfo(this.hostName, this.clientType, this.platform, this.isDeleteOnUnlinkSupported, this.ipAddress, this.created, this.updated, this.sessionInfo, this.clientVersion);
        }
    }
}

