/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.shaded.io.opencensus.stats;

import javax.annotation.concurrent.Immutable;
import org.exoplatform.clouddrive.shaded.io.opencensus.common.Function;
import org.exoplatform.clouddrive.shaded.io.opencensus.internal.StringUtils;
import org.exoplatform.clouddrive.shaded.io.opencensus.internal.Utils;
import org.exoplatform.clouddrive.shaded.io.opencensus.stats.AutoValue_Measure_MeasureDouble;
import org.exoplatform.clouddrive.shaded.io.opencensus.stats.AutoValue_Measure_MeasureLong;

@Immutable
public abstract class Measure {
    static final int NAME_MAX_LENGTH = 255;
    private static final String ERROR_MESSAGE_INVALID_NAME = "Name should be a ASCII string with a length no greater than 255 characters.";

    public abstract <T> T match(Function<? super MeasureDouble, T> var1, Function<? super MeasureLong, T> var2, Function<? super Measure, T> var3);

    public abstract String getName();

    public abstract String getDescription();

    public abstract String getUnit();

    private Measure() {
    }

    @Immutable
    public static abstract class MeasureLong
    extends Measure {
        MeasureLong() {
        }

        public static MeasureLong create(String name, String description, String unit) {
            Utils.checkArgument(StringUtils.isPrintableString(name) && name.length() <= 255, Measure.ERROR_MESSAGE_INVALID_NAME);
            return new AutoValue_Measure_MeasureLong(name, description, unit);
        }

        @Override
        public <T> T match(Function<? super MeasureDouble, T> p0, Function<? super MeasureLong, T> p1, Function<? super Measure, T> defaultFunction) {
            return p1.apply(this);
        }

        @Override
        public abstract String getName();

        @Override
        public abstract String getDescription();

        @Override
        public abstract String getUnit();
    }

    @Immutable
    public static abstract class MeasureDouble
    extends Measure {
        MeasureDouble() {
        }

        public static MeasureDouble create(String name, String description, String unit) {
            Utils.checkArgument(StringUtils.isPrintableString(name) && name.length() <= 255, Measure.ERROR_MESSAGE_INVALID_NAME);
            return new AutoValue_Measure_MeasureDouble(name, description, unit);
        }

        @Override
        public <T> T match(Function<? super MeasureDouble, T> p0, Function<? super MeasureLong, T> p1, Function<? super Measure, T> defaultFunction) {
            return p0.apply(this);
        }

        @Override
        public abstract String getName();

        @Override
        public abstract String getDescription();

        @Override
        public abstract String getUnit();
    }
}

