/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.ecms.filters;

import java.util.Map;
import java.util.Set;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilterType;

public class FileTypeFilter
implements UIExtensionFilter {
    protected static final Log LOG = ExoLogger.getLogger(FileTypeFilter.class);
    protected Set<String> mimeTypes;

    public boolean accept(Map<String, Object> context) throws Exception {
        if (context == null) {
            return true;
        }
        if (this.mimeTypes == null || this.mimeTypes.isEmpty()) {
            return true;
        }
        String type = context.get("mimeType").toString();
        if (this.mimeTypes.contains(type)) {
            return true;
        }
        for (String accepted : this.mimeTypes) {
            if (!type.startsWith(accepted)) continue;
            return true;
        }
        return false;
    }

    public UIExtensionFilterType getType() {
        return UIExtensionFilterType.MANDATORY;
    }

    public void onDeny(Map<String, Object> context) throws Exception {
    }
}

