/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.shaded.google.api.client.googleapis.auth.oauth2;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.List;
import org.exoplatform.clouddrive.shaded.google.api.client.auth.openidconnect.IdToken;
import org.exoplatform.clouddrive.shaded.google.api.client.googleapis.auth.oauth2.GoogleIdTokenVerifier;
import org.exoplatform.clouddrive.shaded.google.api.client.json.JsonFactory;
import org.exoplatform.clouddrive.shaded.google.api.client.json.webtoken.JsonWebSignature;
import org.exoplatform.clouddrive.shaded.google.api.client.util.Beta;
import org.exoplatform.clouddrive.shaded.google.api.client.util.Key;

@Beta
public class GoogleIdToken
extends IdToken {
    public static GoogleIdToken parse(JsonFactory jsonFactory, String idTokenString) throws IOException {
        JsonWebSignature jws = JsonWebSignature.parser(jsonFactory).setPayloadClass(Payload.class).parse(idTokenString);
        return new GoogleIdToken(jws.getHeader(), (Payload)jws.getPayload(), jws.getSignatureBytes(), jws.getSignedContentBytes());
    }

    public GoogleIdToken(JsonWebSignature.Header header, Payload payload, byte[] signatureBytes, byte[] signedContentBytes) {
        super(header, payload, signatureBytes, signedContentBytes);
    }

    public boolean verify(GoogleIdTokenVerifier verifier) throws GeneralSecurityException, IOException {
        return verifier.verify(this);
    }

    @Override
    public Payload getPayload() {
        return (Payload)super.getPayload();
    }

    @Beta
    public static class Payload
    extends IdToken.Payload {
        @Key(value="hd")
        private String hostedDomain;
        @Key(value="email")
        private String email;
        @Key(value="email_verified")
        private Object emailVerified;

        @Deprecated
        public String getUserId() {
            return this.getSubject();
        }

        @Deprecated
        public Payload setUserId(String userId) {
            return this.setSubject(userId);
        }

        @Deprecated
        public String getIssuee() {
            return this.getAuthorizedParty();
        }

        @Deprecated
        public Payload setIssuee(String issuee) {
            return this.setAuthorizedParty(issuee);
        }

        public String getHostedDomain() {
            return this.hostedDomain;
        }

        public Payload setHostedDomain(String hostedDomain) {
            this.hostedDomain = hostedDomain;
            return this;
        }

        public String getEmail() {
            return this.email;
        }

        public Payload setEmail(String email) {
            this.email = email;
            return this;
        }

        public Boolean getEmailVerified() {
            if (this.emailVerified == null) {
                return null;
            }
            if (this.emailVerified instanceof Boolean) {
                return (Boolean)this.emailVerified;
            }
            return Boolean.valueOf((String)this.emailVerified);
        }

        public Payload setEmailVerified(Boolean emailVerified) {
            this.emailVerified = emailVerified;
            return this;
        }

        @Override
        public Payload setAuthorizationTimeSeconds(Long authorizationTimeSeconds) {
            return (Payload)super.setAuthorizationTimeSeconds(authorizationTimeSeconds);
        }

        @Override
        public Payload setAuthorizedParty(String authorizedParty) {
            return (Payload)super.setAuthorizedParty(authorizedParty);
        }

        @Override
        public Payload setNonce(String nonce) {
            return (Payload)super.setNonce(nonce);
        }

        @Override
        public Payload setAccessTokenHash(String accessTokenHash) {
            return (Payload)super.setAccessTokenHash(accessTokenHash);
        }

        @Override
        public Payload setClassReference(String classReference) {
            return (Payload)super.setClassReference(classReference);
        }

        @Override
        public Payload setMethodsReferences(List<String> methodsReferences) {
            return (Payload)super.setMethodsReferences(methodsReferences);
        }

        @Override
        public Payload setExpirationTimeSeconds(Long expirationTimeSeconds) {
            return (Payload)super.setExpirationTimeSeconds(expirationTimeSeconds);
        }

        @Override
        public Payload setNotBeforeTimeSeconds(Long notBeforeTimeSeconds) {
            return (Payload)super.setNotBeforeTimeSeconds(notBeforeTimeSeconds);
        }

        @Override
        public Payload setIssuedAtTimeSeconds(Long issuedAtTimeSeconds) {
            return (Payload)super.setIssuedAtTimeSeconds(issuedAtTimeSeconds);
        }

        @Override
        public Payload setIssuer(String issuer) {
            return (Payload)super.setIssuer(issuer);
        }

        @Override
        public Payload setAudience(Object audience) {
            return (Payload)super.setAudience(audience);
        }

        @Override
        public Payload setJwtId(String jwtId) {
            return (Payload)super.setJwtId(jwtId);
        }

        @Override
        public Payload setType(String type) {
            return (Payload)super.setType(type);
        }

        @Override
        public Payload setSubject(String subject) {
            return (Payload)super.setSubject(subject);
        }

        @Override
        public Payload set(String fieldName, Object value) {
            return (Payload)super.set(fieldName, value);
        }

        @Override
        public Payload clone() {
            return (Payload)super.clone();
        }
    }
}

