/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.json;

import com.dropbox.core.json.JsonDateReader;
import com.dropbox.core.json.JsonReader;
import com.dropbox.core.util.LangUtil;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public abstract class JsonWriter<T> {
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final String[] weekdays = new String[]{null, "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    private static final String[] months = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec", null};

    public static String formatDate(Date date) {
        SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT);
        df.setTimeZone(UTC);
        return df.format(date);
    }

    public abstract void write(T var1, JsonGenerator var2) throws IOException;

    public void write(T value, JsonGenerator g, int level) throws IOException {
        this.write(value, g);
    }

    public void writeFields(T value, JsonGenerator g) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String writeToString(T value, boolean indent) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            JsonGenerator g = JsonReader.jsonFactory.createGenerator((OutputStream)out);
            if (indent) {
                g = g.useDefaultPrettyPrinter();
            }
            try {
                this.write(value, g);
            }
            finally {
                g.flush();
            }
            return new String(out.toByteArray(), "UTF-8");
        }
        catch (IOException ex) {
            throw LangUtil.mkAssert("Impossible", ex);
        }
    }

    public final String writeToString(T value) {
        return this.writeToString(value, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeToStream(T value, OutputStream out, boolean indent) throws IOException {
        JsonGenerator g = JsonReader.jsonFactory.createGenerator(out);
        if (indent) {
            g = g.useDefaultPrettyPrinter();
        }
        try {
            this.write(value, g);
        }
        finally {
            g.flush();
        }
    }

    public final void writeToStream(T value, OutputStream out) throws IOException {
        this.writeToStream(value, out, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeToFile(T value, File file, boolean indent) throws IOException {
        FileOutputStream fout = new FileOutputStream(file);
        try {
            this.writeToStream(value, fout, indent);
        }
        finally {
            fout.close();
        }
    }

    public final void writeToFile(T value, File file) throws IOException {
        this.writeToFile(value, file, true);
    }

    public final void writeToFile(T value, String fileName, boolean indent) throws IOException {
        this.writeToFile(value, new File(fileName), indent);
    }

    public final void writeToFile(T value, String fileName) throws IOException {
        this.writeToFile(value, fileName, true);
    }

    public final void writeDateIso(Date date, JsonGenerator g) throws IOException {
        g.writeString(JsonWriter.formatDate(date));
    }

    public final void writeDate(Date date, JsonGenerator g) throws IOException {
        GregorianCalendar c = new GregorianCalendar(JsonDateReader.UTC);
        c.setTime(date);
        String year = Integer.toString(c.get(1));
        String month = months[c.get(2)];
        String day = JsonWriter.zeroPad(Integer.toString(c.get(5)), 2);
        String hour = JsonWriter.zeroPad(Integer.toString(c.get(11)), 2);
        String minute = JsonWriter.zeroPad(Integer.toString(c.get(12)), 2);
        String second = JsonWriter.zeroPad(Integer.toString(c.get(13)), 2);
        String weekday = weekdays[c.get(7)];
        StringBuilder buf = new StringBuilder();
        buf.append(weekday).append(", ");
        buf.append(day).append(" ").append(month).append(" ").append(year).append(" ");
        buf.append(hour).append(":").append(minute).append(":").append(second).append(" +0000");
        g.writeString(buf.toString());
    }

    private static String zeroPad(String v, int desiredLength) {
        while (v.length() < desiredLength) {
            v = "0" + v;
        }
        return v;
    }
}

