/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.paper;

import com.dropbox.core.DbxApiException;
import com.dropbox.core.DbxDownloader;
import com.dropbox.core.DbxException;
import com.dropbox.core.DbxWrappedException;
import com.dropbox.core.http.HttpRequestor;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.v2.DbxRawClientV2;
import com.dropbox.core.v2.paper.AddMember;
import com.dropbox.core.v2.paper.AddPaperDocUser;
import com.dropbox.core.v2.paper.AddPaperDocUserMemberResult;
import com.dropbox.core.v2.paper.DocLookupError;
import com.dropbox.core.v2.paper.DocLookupErrorException;
import com.dropbox.core.v2.paper.DocsCreateUploader;
import com.dropbox.core.v2.paper.DocsDownloadBuilder;
import com.dropbox.core.v2.paper.DocsListBuilder;
import com.dropbox.core.v2.paper.DocsUpdateUploader;
import com.dropbox.core.v2.paper.DocsUsersAddBuilder;
import com.dropbox.core.v2.paper.DocsUsersListBuilder;
import com.dropbox.core.v2.paper.ExportFormat;
import com.dropbox.core.v2.paper.FoldersContainingPaperDoc;
import com.dropbox.core.v2.paper.ImportFormat;
import com.dropbox.core.v2.paper.ListDocsCursorError;
import com.dropbox.core.v2.paper.ListDocsCursorErrorException;
import com.dropbox.core.v2.paper.ListPaperDocsArgs;
import com.dropbox.core.v2.paper.ListPaperDocsContinueArgs;
import com.dropbox.core.v2.paper.ListPaperDocsResponse;
import com.dropbox.core.v2.paper.ListUsersCursorError;
import com.dropbox.core.v2.paper.ListUsersCursorErrorException;
import com.dropbox.core.v2.paper.ListUsersOnFolderArgs;
import com.dropbox.core.v2.paper.ListUsersOnFolderContinueArgs;
import com.dropbox.core.v2.paper.ListUsersOnFolderResponse;
import com.dropbox.core.v2.paper.ListUsersOnPaperDocArgs;
import com.dropbox.core.v2.paper.ListUsersOnPaperDocContinueArgs;
import com.dropbox.core.v2.paper.ListUsersOnPaperDocResponse;
import com.dropbox.core.v2.paper.PaperDocCreateArgs;
import com.dropbox.core.v2.paper.PaperDocExport;
import com.dropbox.core.v2.paper.PaperDocExportResult;
import com.dropbox.core.v2.paper.PaperDocSharingPolicy;
import com.dropbox.core.v2.paper.PaperDocUpdateArgs;
import com.dropbox.core.v2.paper.PaperDocUpdatePolicy;
import com.dropbox.core.v2.paper.RefPaperDoc;
import com.dropbox.core.v2.paper.RemovePaperDocUser;
import com.dropbox.core.v2.paper.SharingPolicy;
import com.dropbox.core.v2.sharing.MemberSelector;
import java.util.Collections;
import java.util.List;

public class DbxUserPaperRequests {
    private final DbxRawClientV2 client;

    public DbxUserPaperRequests(DbxRawClientV2 client) {
        this.client = client;
    }

    void docsArchive(RefPaperDoc arg) throws DocLookupErrorException, DbxException {
        try {
            this.client.rpcStyle(this.client.getHost().getApi(), "2/paper/docs/archive", arg, false, RefPaperDoc.Serializer.INSTANCE, StoneSerializers.void_(), DocLookupError.Serializer.INSTANCE);
        }
        catch (DbxWrappedException ex) {
            throw new DocLookupErrorException("2/paper/docs/archive", ex.getRequestId(), ex.getUserMessage(), (DocLookupError)((Object)ex.getErrorValue()));
        }
    }

    public void docsArchive(String docId) throws DocLookupErrorException, DbxException {
        RefPaperDoc _arg = new RefPaperDoc(docId);
        this.docsArchive(_arg);
    }

    DocsCreateUploader docsCreate(PaperDocCreateArgs arg) throws DbxException {
        HttpRequestor.Uploader _uploader = this.client.uploadStyle(this.client.getHost().getApi(), "2/paper/docs/create", arg, false, PaperDocCreateArgs.Serializer.INSTANCE);
        return new DocsCreateUploader(_uploader, this.client.getUserId());
    }

    public DocsCreateUploader docsCreate(ImportFormat importFormat) throws DbxException {
        PaperDocCreateArgs _arg = new PaperDocCreateArgs(importFormat);
        return this.docsCreate(_arg);
    }

    public DocsCreateUploader docsCreate(ImportFormat importFormat, String parentFolderId) throws DbxException {
        PaperDocCreateArgs _arg = new PaperDocCreateArgs(importFormat, parentFolderId);
        return this.docsCreate(_arg);
    }

    DbxDownloader<PaperDocExportResult> docsDownload(PaperDocExport arg, List<HttpRequestor.Header> _headers) throws DocLookupErrorException, DbxException {
        try {
            return this.client.downloadStyle(this.client.getHost().getApi(), "2/paper/docs/download", arg, false, _headers, PaperDocExport.Serializer.INSTANCE, PaperDocExportResult.Serializer.INSTANCE, DocLookupError.Serializer.INSTANCE);
        }
        catch (DbxWrappedException ex) {
            throw new DocLookupErrorException("2/paper/docs/download", ex.getRequestId(), ex.getUserMessage(), (DocLookupError)((Object)ex.getErrorValue()));
        }
    }

    public DbxDownloader<PaperDocExportResult> docsDownload(String docId, ExportFormat exportFormat) throws DocLookupErrorException, DbxException {
        PaperDocExport _arg = new PaperDocExport(docId, exportFormat);
        return this.docsDownload(_arg, Collections.<HttpRequestor.Header>emptyList());
    }

    public DocsDownloadBuilder docsDownloadBuilder(String docId, ExportFormat exportFormat) {
        return new DocsDownloadBuilder(this, docId, exportFormat);
    }

    ListUsersOnFolderResponse docsFolderUsersList(ListUsersOnFolderArgs arg) throws DocLookupErrorException, DbxException {
        try {
            return this.client.rpcStyle(this.client.getHost().getApi(), "2/paper/docs/folder_users/list", arg, false, ListUsersOnFolderArgs.Serializer.INSTANCE, ListUsersOnFolderResponse.Serializer.INSTANCE, DocLookupError.Serializer.INSTANCE);
        }
        catch (DbxWrappedException ex) {
            throw new DocLookupErrorException("2/paper/docs/folder_users/list", ex.getRequestId(), ex.getUserMessage(), (DocLookupError)((Object)ex.getErrorValue()));
        }
    }

    public ListUsersOnFolderResponse docsFolderUsersList(String docId) throws DocLookupErrorException, DbxException {
        ListUsersOnFolderArgs _arg = new ListUsersOnFolderArgs(docId);
        return this.docsFolderUsersList(_arg);
    }

    public ListUsersOnFolderResponse docsFolderUsersList(String docId, int limit) throws DocLookupErrorException, DbxException {
        if (limit < 1) {
            throw new IllegalArgumentException("Number 'limit' is smaller than 1");
        }
        if (limit > 1000) {
            throw new IllegalArgumentException("Number 'limit' is larger than 1000");
        }
        ListUsersOnFolderArgs _arg = new ListUsersOnFolderArgs(docId, limit);
        return this.docsFolderUsersList(_arg);
    }

    ListUsersOnFolderResponse docsFolderUsersListContinue(ListUsersOnFolderContinueArgs arg) throws ListUsersCursorErrorException, DbxException {
        try {
            return this.client.rpcStyle(this.client.getHost().getApi(), "2/paper/docs/folder_users/list/continue", arg, false, ListUsersOnFolderContinueArgs.Serializer.INSTANCE, ListUsersOnFolderResponse.Serializer.INSTANCE, ListUsersCursorError.Serializer.INSTANCE);
        }
        catch (DbxWrappedException ex) {
            throw new ListUsersCursorErrorException("2/paper/docs/folder_users/list/continue", ex.getRequestId(), ex.getUserMessage(), (ListUsersCursorError)ex.getErrorValue());
        }
    }

    public ListUsersOnFolderResponse docsFolderUsersListContinue(String docId, String cursor) throws ListUsersCursorErrorException, DbxException {
        ListUsersOnFolderContinueArgs _arg = new ListUsersOnFolderContinueArgs(docId, cursor);
        return this.docsFolderUsersListContinue(_arg);
    }

    FoldersContainingPaperDoc docsGetFolderInfo(RefPaperDoc arg) throws DocLookupErrorException, DbxException {
        try {
            return this.client.rpcStyle(this.client.getHost().getApi(), "2/paper/docs/get_folder_info", arg, false, RefPaperDoc.Serializer.INSTANCE, FoldersContainingPaperDoc.Serializer.INSTANCE, DocLookupError.Serializer.INSTANCE);
        }
        catch (DbxWrappedException ex) {
            throw new DocLookupErrorException("2/paper/docs/get_folder_info", ex.getRequestId(), ex.getUserMessage(), (DocLookupError)((Object)ex.getErrorValue()));
        }
    }

    public FoldersContainingPaperDoc docsGetFolderInfo(String docId) throws DocLookupErrorException, DbxException {
        RefPaperDoc _arg = new RefPaperDoc(docId);
        return this.docsGetFolderInfo(_arg);
    }

    ListPaperDocsResponse docsList(ListPaperDocsArgs arg) throws DbxApiException, DbxException {
        try {
            return this.client.rpcStyle(this.client.getHost().getApi(), "2/paper/docs/list", arg, false, ListPaperDocsArgs.Serializer.INSTANCE, ListPaperDocsResponse.Serializer.INSTANCE, StoneSerializers.void_());
        }
        catch (DbxWrappedException ex) {
            throw new DbxApiException(ex.getRequestId(), ex.getUserMessage(), "Unexpected error response for \"docs/list\":" + ex.getErrorValue());
        }
    }

    public ListPaperDocsResponse docsList() throws DbxApiException, DbxException {
        ListPaperDocsArgs _arg = new ListPaperDocsArgs();
        return this.docsList(_arg);
    }

    public DocsListBuilder docsListBuilder() {
        ListPaperDocsArgs.Builder argBuilder_ = ListPaperDocsArgs.newBuilder();
        return new DocsListBuilder(this, argBuilder_);
    }

    ListPaperDocsResponse docsListContinue(ListPaperDocsContinueArgs arg) throws ListDocsCursorErrorException, DbxException {
        try {
            return this.client.rpcStyle(this.client.getHost().getApi(), "2/paper/docs/list/continue", arg, false, ListPaperDocsContinueArgs.Serializer.INSTANCE, ListPaperDocsResponse.Serializer.INSTANCE, ListDocsCursorError.Serializer.INSTANCE);
        }
        catch (DbxWrappedException ex) {
            throw new ListDocsCursorErrorException("2/paper/docs/list/continue", ex.getRequestId(), ex.getUserMessage(), (ListDocsCursorError)ex.getErrorValue());
        }
    }

    public ListPaperDocsResponse docsListContinue(String cursor) throws ListDocsCursorErrorException, DbxException {
        ListPaperDocsContinueArgs _arg = new ListPaperDocsContinueArgs(cursor);
        return this.docsListContinue(_arg);
    }

    void docsPermanentlyDelete(RefPaperDoc arg) throws DocLookupErrorException, DbxException {
        try {
            this.client.rpcStyle(this.client.getHost().getApi(), "2/paper/docs/permanently_delete", arg, false, RefPaperDoc.Serializer.INSTANCE, StoneSerializers.void_(), DocLookupError.Serializer.INSTANCE);
        }
        catch (DbxWrappedException ex) {
            throw new DocLookupErrorException("2/paper/docs/permanently_delete", ex.getRequestId(), ex.getUserMessage(), (DocLookupError)((Object)ex.getErrorValue()));
        }
    }

    public void docsPermanentlyDelete(String docId) throws DocLookupErrorException, DbxException {
        RefPaperDoc _arg = new RefPaperDoc(docId);
        this.docsPermanentlyDelete(_arg);
    }

    SharingPolicy docsSharingPolicyGet(RefPaperDoc arg) throws DocLookupErrorException, DbxException {
        try {
            return this.client.rpcStyle(this.client.getHost().getApi(), "2/paper/docs/sharing_policy/get", arg, false, RefPaperDoc.Serializer.INSTANCE, SharingPolicy.Serializer.INSTANCE, DocLookupError.Serializer.INSTANCE);
        }
        catch (DbxWrappedException ex) {
            throw new DocLookupErrorException("2/paper/docs/sharing_policy/get", ex.getRequestId(), ex.getUserMessage(), (DocLookupError)((Object)ex.getErrorValue()));
        }
    }

    public SharingPolicy docsSharingPolicyGet(String docId) throws DocLookupErrorException, DbxException {
        RefPaperDoc _arg = new RefPaperDoc(docId);
        return this.docsSharingPolicyGet(_arg);
    }

    void docsSharingPolicySet(PaperDocSharingPolicy arg) throws DocLookupErrorException, DbxException {
        try {
            this.client.rpcStyle(this.client.getHost().getApi(), "2/paper/docs/sharing_policy/set", arg, false, PaperDocSharingPolicy.Serializer.INSTANCE, StoneSerializers.void_(), DocLookupError.Serializer.INSTANCE);
        }
        catch (DbxWrappedException ex) {
            throw new DocLookupErrorException("2/paper/docs/sharing_policy/set", ex.getRequestId(), ex.getUserMessage(), (DocLookupError)((Object)ex.getErrorValue()));
        }
    }

    public void docsSharingPolicySet(String docId, SharingPolicy sharingPolicy) throws DocLookupErrorException, DbxException {
        PaperDocSharingPolicy _arg = new PaperDocSharingPolicy(docId, sharingPolicy);
        this.docsSharingPolicySet(_arg);
    }

    DocsUpdateUploader docsUpdate(PaperDocUpdateArgs arg) throws DbxException {
        HttpRequestor.Uploader _uploader = this.client.uploadStyle(this.client.getHost().getApi(), "2/paper/docs/update", arg, false, PaperDocUpdateArgs.Serializer.INSTANCE);
        return new DocsUpdateUploader(_uploader, this.client.getUserId());
    }

    public DocsUpdateUploader docsUpdate(String docId, PaperDocUpdatePolicy docUpdatePolicy, long revision, ImportFormat importFormat) throws DbxException {
        PaperDocUpdateArgs _arg = new PaperDocUpdateArgs(docId, docUpdatePolicy, revision, importFormat);
        return this.docsUpdate(_arg);
    }

    List<AddPaperDocUserMemberResult> docsUsersAdd(AddPaperDocUser arg) throws DocLookupErrorException, DbxException {
        try {
            return this.client.rpcStyle(this.client.getHost().getApi(), "2/paper/docs/users/add", arg, false, AddPaperDocUser.Serializer.INSTANCE, StoneSerializers.list(AddPaperDocUserMemberResult.Serializer.INSTANCE), DocLookupError.Serializer.INSTANCE);
        }
        catch (DbxWrappedException ex) {
            throw new DocLookupErrorException("2/paper/docs/users/add", ex.getRequestId(), ex.getUserMessage(), (DocLookupError)((Object)ex.getErrorValue()));
        }
    }

    public List<AddPaperDocUserMemberResult> docsUsersAdd(String docId, List<AddMember> members) throws DocLookupErrorException, DbxException {
        AddPaperDocUser _arg = new AddPaperDocUser(docId, members);
        return this.docsUsersAdd(_arg);
    }

    public DocsUsersAddBuilder docsUsersAddBuilder(String docId, List<AddMember> members) {
        AddPaperDocUser.Builder argBuilder_ = AddPaperDocUser.newBuilder(docId, members);
        return new DocsUsersAddBuilder(this, argBuilder_);
    }

    ListUsersOnPaperDocResponse docsUsersList(ListUsersOnPaperDocArgs arg) throws DocLookupErrorException, DbxException {
        try {
            return this.client.rpcStyle(this.client.getHost().getApi(), "2/paper/docs/users/list", arg, false, ListUsersOnPaperDocArgs.Serializer.INSTANCE, ListUsersOnPaperDocResponse.Serializer.INSTANCE, DocLookupError.Serializer.INSTANCE);
        }
        catch (DbxWrappedException ex) {
            throw new DocLookupErrorException("2/paper/docs/users/list", ex.getRequestId(), ex.getUserMessage(), (DocLookupError)((Object)ex.getErrorValue()));
        }
    }

    public ListUsersOnPaperDocResponse docsUsersList(String docId) throws DocLookupErrorException, DbxException {
        ListUsersOnPaperDocArgs _arg = new ListUsersOnPaperDocArgs(docId);
        return this.docsUsersList(_arg);
    }

    public DocsUsersListBuilder docsUsersListBuilder(String docId) {
        ListUsersOnPaperDocArgs.Builder argBuilder_ = ListUsersOnPaperDocArgs.newBuilder(docId);
        return new DocsUsersListBuilder(this, argBuilder_);
    }

    ListUsersOnPaperDocResponse docsUsersListContinue(ListUsersOnPaperDocContinueArgs arg) throws ListUsersCursorErrorException, DbxException {
        try {
            return this.client.rpcStyle(this.client.getHost().getApi(), "2/paper/docs/users/list/continue", arg, false, ListUsersOnPaperDocContinueArgs.Serializer.INSTANCE, ListUsersOnPaperDocResponse.Serializer.INSTANCE, ListUsersCursorError.Serializer.INSTANCE);
        }
        catch (DbxWrappedException ex) {
            throw new ListUsersCursorErrorException("2/paper/docs/users/list/continue", ex.getRequestId(), ex.getUserMessage(), (ListUsersCursorError)ex.getErrorValue());
        }
    }

    public ListUsersOnPaperDocResponse docsUsersListContinue(String docId, String cursor) throws ListUsersCursorErrorException, DbxException {
        ListUsersOnPaperDocContinueArgs _arg = new ListUsersOnPaperDocContinueArgs(docId, cursor);
        return this.docsUsersListContinue(_arg);
    }

    void docsUsersRemove(RemovePaperDocUser arg) throws DocLookupErrorException, DbxException {
        try {
            this.client.rpcStyle(this.client.getHost().getApi(), "2/paper/docs/users/remove", arg, false, RemovePaperDocUser.Serializer.INSTANCE, StoneSerializers.void_(), DocLookupError.Serializer.INSTANCE);
        }
        catch (DbxWrappedException ex) {
            throw new DocLookupErrorException("2/paper/docs/users/remove", ex.getRequestId(), ex.getUserMessage(), (DocLookupError)((Object)ex.getErrorValue()));
        }
    }

    public void docsUsersRemove(String docId, MemberSelector member) throws DocLookupErrorException, DbxException {
        RemovePaperDocUser _arg = new RemovePaperDocUser(docId, member);
        this.docsUsersRemove(_arg);
    }
}

