/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.UnionSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;

public final class AddMemberSelectorError {
    public static final AddMemberSelectorError AUTOMATIC_GROUP = new AddMemberSelectorError().withTag(Tag.AUTOMATIC_GROUP);
    public static final AddMemberSelectorError GROUP_DELETED = new AddMemberSelectorError().withTag(Tag.GROUP_DELETED);
    public static final AddMemberSelectorError GROUP_NOT_ON_TEAM = new AddMemberSelectorError().withTag(Tag.GROUP_NOT_ON_TEAM);
    public static final AddMemberSelectorError OTHER = new AddMemberSelectorError().withTag(Tag.OTHER);
    private Tag _tag;
    private String invalidDropboxIdValue;
    private String invalidEmailValue;
    private String unverifiedDropboxIdValue;

    private AddMemberSelectorError() {
    }

    private AddMemberSelectorError withTag(Tag _tag) {
        AddMemberSelectorError result = new AddMemberSelectorError();
        result._tag = _tag;
        return result;
    }

    private AddMemberSelectorError withTagAndInvalidDropboxId(Tag _tag, String invalidDropboxIdValue) {
        AddMemberSelectorError result = new AddMemberSelectorError();
        result._tag = _tag;
        result.invalidDropboxIdValue = invalidDropboxIdValue;
        return result;
    }

    private AddMemberSelectorError withTagAndInvalidEmail(Tag _tag, String invalidEmailValue) {
        AddMemberSelectorError result = new AddMemberSelectorError();
        result._tag = _tag;
        result.invalidEmailValue = invalidEmailValue;
        return result;
    }

    private AddMemberSelectorError withTagAndUnverifiedDropboxId(Tag _tag, String unverifiedDropboxIdValue) {
        AddMemberSelectorError result = new AddMemberSelectorError();
        result._tag = _tag;
        result.unverifiedDropboxIdValue = unverifiedDropboxIdValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isAutomaticGroup() {
        return this._tag == Tag.AUTOMATIC_GROUP;
    }

    public boolean isInvalidDropboxId() {
        return this._tag == Tag.INVALID_DROPBOX_ID;
    }

    public static AddMemberSelectorError invalidDropboxId(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        if (value.length() < 1) {
            throw new IllegalArgumentException("String is shorter than 1");
        }
        return new AddMemberSelectorError().withTagAndInvalidDropboxId(Tag.INVALID_DROPBOX_ID, value);
    }

    public String getInvalidDropboxIdValue() {
        if (this._tag != Tag.INVALID_DROPBOX_ID) {
            throw new IllegalStateException("Invalid tag: required Tag.INVALID_DROPBOX_ID, but was Tag." + this._tag.name());
        }
        return this.invalidDropboxIdValue;
    }

    public boolean isInvalidEmail() {
        return this._tag == Tag.INVALID_EMAIL;
    }

    public static AddMemberSelectorError invalidEmail(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        if (value.length() > 255) {
            throw new IllegalArgumentException("String is longer than 255");
        }
        if (!Pattern.matches("^['&A-Za-z0-9._%+-]+@[A-Za-z0-9-][A-Za-z0-9.-]*\\.[A-Za-z]{2,15}$", value)) {
            throw new IllegalArgumentException("String does not match pattern");
        }
        return new AddMemberSelectorError().withTagAndInvalidEmail(Tag.INVALID_EMAIL, value);
    }

    public String getInvalidEmailValue() {
        if (this._tag != Tag.INVALID_EMAIL) {
            throw new IllegalStateException("Invalid tag: required Tag.INVALID_EMAIL, but was Tag." + this._tag.name());
        }
        return this.invalidEmailValue;
    }

    public boolean isUnverifiedDropboxId() {
        return this._tag == Tag.UNVERIFIED_DROPBOX_ID;
    }

    public static AddMemberSelectorError unverifiedDropboxId(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        if (value.length() < 1) {
            throw new IllegalArgumentException("String is shorter than 1");
        }
        return new AddMemberSelectorError().withTagAndUnverifiedDropboxId(Tag.UNVERIFIED_DROPBOX_ID, value);
    }

    public String getUnverifiedDropboxIdValue() {
        if (this._tag != Tag.UNVERIFIED_DROPBOX_ID) {
            throw new IllegalStateException("Invalid tag: required Tag.UNVERIFIED_DROPBOX_ID, but was Tag." + this._tag.name());
        }
        return this.unverifiedDropboxIdValue;
    }

    public boolean isGroupDeleted() {
        return this._tag == Tag.GROUP_DELETED;
    }

    public boolean isGroupNotOnTeam() {
        return this._tag == Tag.GROUP_NOT_ON_TEAM;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.invalidDropboxIdValue, this.invalidEmailValue, this.unverifiedDropboxIdValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof AddMemberSelectorError) {
            AddMemberSelectorError other = (AddMemberSelectorError)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case AUTOMATIC_GROUP: {
                    return true;
                }
                case INVALID_DROPBOX_ID: {
                    return this.invalidDropboxIdValue == other.invalidDropboxIdValue || this.invalidDropboxIdValue.equals(other.invalidDropboxIdValue);
                }
                case INVALID_EMAIL: {
                    return this.invalidEmailValue == other.invalidEmailValue || this.invalidEmailValue.equals(other.invalidEmailValue);
                }
                case UNVERIFIED_DROPBOX_ID: {
                    return this.unverifiedDropboxIdValue == other.unverifiedDropboxIdValue || this.unverifiedDropboxIdValue.equals(other.unverifiedDropboxIdValue);
                }
                case GROUP_DELETED: {
                    return true;
                }
                case GROUP_NOT_ON_TEAM: {
                    return true;
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<AddMemberSelectorError> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(AddMemberSelectorError value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case AUTOMATIC_GROUP: {
                    g.writeString("automatic_group");
                    break;
                }
                case INVALID_DROPBOX_ID: {
                    g.writeStartObject();
                    this.writeTag("invalid_dropbox_id", g);
                    g.writeFieldName("invalid_dropbox_id");
                    StoneSerializers.string().serialize(value.invalidDropboxIdValue, g);
                    g.writeEndObject();
                    break;
                }
                case INVALID_EMAIL: {
                    g.writeStartObject();
                    this.writeTag("invalid_email", g);
                    g.writeFieldName("invalid_email");
                    StoneSerializers.string().serialize(value.invalidEmailValue, g);
                    g.writeEndObject();
                    break;
                }
                case UNVERIFIED_DROPBOX_ID: {
                    g.writeStartObject();
                    this.writeTag("unverified_dropbox_id", g);
                    g.writeFieldName("unverified_dropbox_id");
                    StoneSerializers.string().serialize(value.unverifiedDropboxIdValue, g);
                    g.writeEndObject();
                    break;
                }
                case GROUP_DELETED: {
                    g.writeString("group_deleted");
                    break;
                }
                case GROUP_NOT_ON_TEAM: {
                    g.writeString("group_not_on_team");
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public AddMemberSelectorError deserialize(JsonParser p) throws IOException, JsonParseException {
            AddMemberSelectorError value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("automatic_group".equals(tag)) {
                value = AUTOMATIC_GROUP;
            } else if ("invalid_dropbox_id".equals(tag)) {
                String fieldValue = null;
                Serializer.expectField("invalid_dropbox_id", p);
                fieldValue = StoneSerializers.string().deserialize(p);
                value = AddMemberSelectorError.invalidDropboxId(fieldValue);
            } else if ("invalid_email".equals(tag)) {
                String fieldValue = null;
                Serializer.expectField("invalid_email", p);
                fieldValue = StoneSerializers.string().deserialize(p);
                value = AddMemberSelectorError.invalidEmail(fieldValue);
            } else if ("unverified_dropbox_id".equals(tag)) {
                String fieldValue = null;
                Serializer.expectField("unverified_dropbox_id", p);
                fieldValue = StoneSerializers.string().deserialize(p);
                value = AddMemberSelectorError.unverifiedDropboxId(fieldValue);
            } else {
                value = "group_deleted".equals(tag) ? GROUP_DELETED : ("group_not_on_team".equals(tag) ? GROUP_NOT_ON_TEAM : OTHER);
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        AUTOMATIC_GROUP,
        INVALID_DROPBOX_ID,
        INVALID_EMAIL,
        UNVERIFIED_DROPBOX_ID,
        GROUP_DELETED,
        GROUP_NOT_ON_TEAM,
        OTHER;

    }
}

