/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.jcr;

import java.util.Collection;
import java.util.LinkedHashSet;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.clouddrive.jcr.NodeFinder;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;

public class JCRNodeFinder
implements NodeFinder {
    protected final RepositoryService jcrService;
    protected final SessionProviderService sessionProviderService;
    protected final NodeHierarchyCreator hierarchyCreator;

    public JCRNodeFinder(RepositoryService jcrService, SessionProviderService sessionProviderService, NodeHierarchyCreator hierarchyCreator) {
        this.jcrService = jcrService;
        this.sessionProviderService = sessionProviderService;
        this.hierarchyCreator = hierarchyCreator;
    }

    @Override
    public Item getItem(Session userSession, String path, boolean symlinkTarget) throws PathNotFoundException, RepositoryException {
        return userSession.getItem(path);
    }

    @Override
    public Item findItem(Session userSession, String path) throws PathNotFoundException, RepositoryException {
        return userSession.getItem(path);
    }

    @Override
    public Collection<Node> findLinked(Session session, String uuid) throws PathNotFoundException, RepositoryException {
        LinkedHashSet<Node> res = new LinkedHashSet<Node>();
        try {
            Node target = session.getNodeByUUID(uuid);
            PropertyIterator piter = target.getReferences();
            while (piter.hasNext()) {
                res.add(piter.nextProperty().getParent());
            }
        }
        catch (ItemNotFoundException itemNotFoundException) {
            // empty catch block
        }
        return res;
    }

    @Override
    public String cleanName(String name) {
        return name;
    }

    @Override
    public Node getUserNode(String userName) throws Exception {
        SessionProvider sessionProvider = this.sessionProviderService.getSessionProvider(null);
        Node userNode = this.hierarchyCreator.getUserNode(sessionProvider, userName);
        return userNode;
    }
}

