/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.utils;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class Web {
    protected static final Log LOG = ExoLogger.getLogger(Web.class);

    private Web() {
    }

    public static String formEncode(String str) {
        try {
            return URLEncoder.encode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn((Object)("Cannot encode " + str + ":" + e));
            return str;
        }
    }

    public static String formDecode(String str) {
        try {
            return URLDecoder.decode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn((Object)("Cannot decode " + str + ":" + e));
            return str;
        }
    }

    public static String pathEncode(String path) {
        try {
            URI uri = new URI(null, null, path, null);
            return uri.getPath();
        }
        catch (URISyntaxException e) {
            LOG.warn((Object)("Cannot encode URL path " + path + ":" + e));
            return path;
        }
    }

    public static String pathDecode(String path) {
        try {
            URI uri = new URI(null, null, path, null);
            return uri.getRawPath();
        }
        catch (URISyntaxException e) {
            LOG.warn((Object)("Cannot decode URL path " + path + ":" + e));
            return path;
        }
    }
}

