/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.dropbox;

import javax.jcr.RepositoryException;
import org.exoplatform.clouddrive.dropbox.DropboxConnector;
import org.exoplatform.services.cms.clouddrives.CloudDriveException;
import org.exoplatform.services.cms.clouddrives.CloudProvider;
import org.exoplatform.services.jcr.RepositoryService;

public class DropboxProvider
extends CloudProvider {
    protected final DropboxConnector.API authFactory;
    protected final RepositoryService jcrService;

    public DropboxProvider(String id, String name, DropboxConnector.API authFactory, RepositoryService jcrService) {
        super(id, name);
        this.authFactory = authFactory;
        this.jcrService = jcrService;
    }

    public String getAuthURL() throws CloudDriveException {
        String authState;
        if (this.jcrService != null) {
            try {
                authState = this.jcrService.getCurrentRepository().getConfiguration().getName();
            }
            catch (RepositoryException e) {
                throw new CloudDriveException((Throwable)e);
            }
        } else {
            authState = "__no_state_set__";
        }
        String authURL = this.authFactory.authLink(authState);
        return authURL;
    }

    public boolean retryOnProviderError() {
        return true;
    }

    public String getErrorMessage(String error, String errorDescription) {
        return error;
    }
}

