/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.teamlog;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.util.LangUtil;
import com.dropbox.core.v2.teamlog.DesktopDeviceSessionLogInfo;
import com.dropbox.core.v2.teamlog.LegacyDeviceSessionLogInfo;
import com.dropbox.core.v2.teamlog.MobileDeviceSessionLogInfo;
import com.dropbox.core.v2.teamlog.WebDeviceSessionLogInfo;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;

public class DeviceSessionLogInfo {
    protected final String ipAddress;
    protected final Date created;
    protected final Date updated;

    public DeviceSessionLogInfo(String ipAddress, Date created, Date updated) {
        this.ipAddress = ipAddress;
        this.created = LangUtil.truncateMillis(created);
        this.updated = LangUtil.truncateMillis(updated);
    }

    public DeviceSessionLogInfo() {
        this(null, null, null);
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public Date getCreated() {
        return this.created;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.ipAddress, this.created, this.updated});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            DeviceSessionLogInfo other = (DeviceSessionLogInfo)obj;
            return (this.ipAddress == other.ipAddress || this.ipAddress != null && this.ipAddress.equals(other.ipAddress)) && (this.created == other.created || this.created != null && this.created.equals(other.created)) && (this.updated == other.updated || this.updated != null && this.updated.equals(other.updated));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<DeviceSessionLogInfo> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(DeviceSessionLogInfo value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (value instanceof DesktopDeviceSessionLogInfo) {
                DesktopDeviceSessionLogInfo.Serializer.INSTANCE.serialize((DesktopDeviceSessionLogInfo)value, g, collapse);
                return;
            }
            if (value instanceof MobileDeviceSessionLogInfo) {
                MobileDeviceSessionLogInfo.Serializer.INSTANCE.serialize((MobileDeviceSessionLogInfo)value, g, collapse);
                return;
            }
            if (value instanceof WebDeviceSessionLogInfo) {
                WebDeviceSessionLogInfo.Serializer.INSTANCE.serialize((WebDeviceSessionLogInfo)value, g, collapse);
                return;
            }
            if (value instanceof LegacyDeviceSessionLogInfo) {
                LegacyDeviceSessionLogInfo.Serializer.INSTANCE.serialize((LegacyDeviceSessionLogInfo)value, g, collapse);
                return;
            }
            if (!collapse) {
                g.writeStartObject();
            }
            if (value.ipAddress != null) {
                g.writeFieldName("ip_address");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.ipAddress, g);
            }
            if (value.created != null) {
                g.writeFieldName("created");
                StoneSerializers.nullable(StoneSerializers.timestamp()).serialize(value.created, g);
            }
            if (value.updated != null) {
                g.writeFieldName("updated");
                StoneSerializers.nullable(StoneSerializers.timestamp()).serialize(value.updated, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public DeviceSessionLogInfo deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            DeviceSessionLogInfo value;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
                if ("".equals(tag)) {
                    tag = null;
                }
            }
            if (tag == null) {
                String f_ipAddress = null;
                Date f_created = null;
                Date f_updated = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("ip_address".equals(field)) {
                        f_ipAddress = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("created".equals(field)) {
                        f_created = StoneSerializers.nullable(StoneSerializers.timestamp()).deserialize(p);
                        continue;
                    }
                    if ("updated".equals(field)) {
                        f_updated = StoneSerializers.nullable(StoneSerializers.timestamp()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                value = new DeviceSessionLogInfo(f_ipAddress, f_created, f_updated);
            } else if ("".equals(tag)) {
                value = INSTANCE.deserialize(p, true);
            } else if ("desktop_device_session".equals(tag)) {
                value = DesktopDeviceSessionLogInfo.Serializer.INSTANCE.deserialize(p, true);
            } else if ("mobile_device_session".equals(tag)) {
                value = MobileDeviceSessionLogInfo.Serializer.INSTANCE.deserialize(p, true);
            } else if ("web_device_session".equals(tag)) {
                value = WebDeviceSessionLogInfo.Serializer.INSTANCE.deserialize(p, true);
            } else if ("legacy_device_session".equals(tag)) {
                value = LegacyDeviceSessionLogInfo.Serializer.INSTANCE.deserialize(p, true);
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected String ipAddress = null;
        protected Date created = null;
        protected Date updated = null;

        protected Builder() {
        }

        public Builder withIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public Builder withCreated(Date created) {
            this.created = LangUtil.truncateMillis(created);
            return this;
        }

        public Builder withUpdated(Date updated) {
            this.updated = LangUtil.truncateMillis(updated);
            return this;
        }

        public DeviceSessionLogInfo build() {
            return new DeviceSessionLogInfo(this.ipAddress, this.created, this.updated);
        }
    }
}

