/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.users;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.users.SpaceAllocation;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public class SpaceUsage {
    protected final long used;
    protected final SpaceAllocation allocation;

    public SpaceUsage(long used, SpaceAllocation allocation) {
        this.used = used;
        if (allocation == null) {
            throw new IllegalArgumentException("Required value for 'allocation' is null");
        }
        this.allocation = allocation;
    }

    public long getUsed() {
        return this.used;
    }

    public SpaceAllocation getAllocation() {
        return this.allocation;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.used, this.allocation});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            SpaceUsage other = (SpaceUsage)obj;
            return this.used == other.used && (this.allocation == other.allocation || this.allocation.equals(other.allocation));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<SpaceUsage> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(SpaceUsage value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("used");
            StoneSerializers.uInt64().serialize((Long)value.used, g);
            g.writeFieldName("allocation");
            SpaceAllocation.Serializer.INSTANCE.serialize(value.allocation, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public SpaceUsage deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            SpaceAllocation f_allocation;
            Long f_used;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_used = null;
                f_allocation = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("used".equals(field)) {
                        f_used = StoneSerializers.uInt64().deserialize(p);
                        continue;
                    }
                    if ("allocation".equals(field)) {
                        f_allocation = SpaceAllocation.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_used == null) {
                    throw new JsonParseException(p, "Required field \"used\" missing.");
                }
                if (f_allocation == null) {
                    throw new JsonParseException(p, "Required field \"allocation\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            SpaceUsage value = new SpaceUsage(f_used, f_allocation);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

