/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.cmis;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.exoplatform.services.cms.clouddrives.CloudDriveConnector;
import org.exoplatform.services.cms.clouddrives.CloudDriveException;
import org.exoplatform.services.cms.clouddrives.CloudProvider;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class CMISProvider
extends CloudProvider {
    protected static final Log LOG = ExoLogger.getLogger(CMISProvider.class);
    protected final String authURL;
    protected final RepositoryService jcrService;
    protected Set<AtomPub> predefined = new LinkedHashSet<AtomPub>();

    public CMISProvider(String id, String name, String authURL, RepositoryService jcrService) {
        super(id, name);
        this.authURL = authURL;
        this.jcrService = jcrService;
    }

    public String getAuthURL() throws CloudDriveException {
        if (this.jcrService != null) {
            try {
                String currentRepo = this.jcrService.getCurrentRepository().getConfiguration().getName();
                return this.authURL.replace("__no_state_set__", currentRepo);
            }
            catch (RepositoryException e) {
                throw new CloudDriveException((Throwable)e);
            }
        }
        return this.authURL;
    }

    public boolean retryOnProviderError() {
        return true;
    }

    public Set<AtomPub> getPredefinedAtompubServices() {
        return Collections.unmodifiableSet(this.predefined);
    }

    protected void initPredefined(CloudDriveConnector.PredefinedServices predefined) {
        String predefinedProp;
        String propKey = "clouddrive." + this.getId() + ".predefined";
        String predefinedPropOverride = System.getProperty(propKey + ".override", "true");
        if ("true".equalsIgnoreCase(predefinedPropOverride)) {
            for (Object obj : predefined.getServices()) {
                if (obj instanceof AtomPub) {
                    this.predefined.add((AtomPub)obj);
                    continue;
                }
                LOG.warn((Object)("Not supported predefined service: " + predefined.getClass().getName()));
            }
        }
        if ((predefinedProp = System.getProperty(propKey)) != null) {
            for (String ps : predefinedProp.split("\n")) {
                int i = ps.indexOf(":");
                if (i + 1 < ps.length()) {
                    AtomPub p = new AtomPub();
                    p.setName(ps.substring(0, i));
                    p.setUrl(ps.substring(i + 1));
                    this.predefined.add(p);
                    continue;
                }
                LOG.warn((Object)("Cannot load predefined service from property: " + ps));
            }
        }
    }

    public static class AtomPub {
        String name;
        String url;
        int hashCode;

        public void setName(String name) {
            this.hashCode = 0;
            this.name = name;
        }

        public void setUrl(String url) {
            this.hashCode = 0;
            this.url = url;
        }

        public String getName() {
            return this.name;
        }

        public String getUrl() {
            return this.url;
        }

        public int hashCode() {
            if (this.hashCode == 0 && this.url != null) {
                int hc = 1;
                hc = this.name != null ? 17 + this.name.hashCode() : 19;
                this.hashCode = hc = hc * 31 + this.url.hashCode();
            }
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (obj instanceof AtomPub) {
                return (this.name == null || this.name.equals(((AtomPub)obj).getName())) && this.url.equals(((AtomPub)obj).getUrl());
            }
            return false;
        }

        public String toString() {
            return this.name != null ? this.name + ": " + this.url : this.url;
        }
    }
}

