/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.cmis.login;

import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import javax.jcr.RepositoryException;
import org.exoplatform.clouddrive.cmis.login.AuthenticationException;
import org.exoplatform.services.idgenerator.IDGeneratorService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class CodeAuthentication {
    public static final long IDENTITY_LIFETIME = 60000L;
    protected static final Log LOG = ExoLogger.getLogger(CodeAuthentication.class);
    private final Random random = new Random();
    private final IDGeneratorService idGenerator;
    private final RepositoryService jcrService;
    private final ConcurrentHashMap<String, Identity> codes = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Identity> exchanged = new ConcurrentHashMap();

    public CodeAuthentication(IDGeneratorService idGenerator, RepositoryService jcrService) {
        this.idGenerator = idGenerator;
        this.jcrService = jcrService;
    }

    public String authenticate(String serviceURL, String user, String password) {
        Identity prevId;
        Identity id = new Identity(serviceURL, user, password);
        String code = this.idGenerator.generateStringID(id.getCodeSource());
        int counter = 0;
        while ((prevId = this.codes.putIfAbsent(code, id)) != null) {
            if (counter >= 1000) {
                LOG.error((Object)("Cannot find a free code for user " + user));
                throw new IllegalStateException("Code authentication not possible for the moment.");
            }
            ++counter;
            if (prevId.user.equals(user)) {
                this.codes.remove(code, prevId);
            }
            id = new Identity(serviceURL, user, password);
            code = this.idGenerator.generateStringID(id.getCodeSource());
        }
        return code;
    }

    @Deprecated
    public boolean hasCode(String code) {
        Identity id = this.codes.get(code);
        return id != null && System.currentTimeMillis() - id.created < 60000L;
    }

    public Identity exchangeCode(String code) throws AuthenticationException {
        Identity id = this.codes.remove(code);
        if (id != null && System.currentTimeMillis() - id.created < 60000L) {
            this.exchanged.put(code, id);
            return id;
        }
        throw new AuthenticationException("Invalid code");
    }

    public void setCodeContext(String code, String context) throws AuthenticationException {
        Identity id = this.codes.get(code);
        if (id != null && System.currentTimeMillis() - id.created < 60000L) {
            id.setContext(context);
        } else {
            id = this.exchanged.remove(code);
            if (id != null) {
                id.setContext(context);
            } else {
                throw new AuthenticationException("Invalid code");
            }
        }
    }

    @Deprecated
    public boolean hasCodeContext(String code) {
        Identity id = this.codes.get(code);
        if (id != null && System.currentTimeMillis() - id.created < 60000L) {
            return id.getServiceContext() != null;
        }
        return false;
    }

    public class Identity {
        final String user;
        final String password;
        final String serviceURL;
        String serviceContext;
        final long created;

        Identity(String serviceURL, String user, String password) {
            this.serviceURL = serviceURL;
            this.user = user;
            this.password = password;
            this.created = System.currentTimeMillis();
        }

        void setContext(String serviceContext) {
            this.serviceContext = serviceContext;
        }

        Object getCodeSource() {
            StringBuilder src = new StringBuilder();
            src.append(this.user);
            int passPart = CodeAuthentication.this.random.nextInt(this.password.length() - 1);
            if (passPart == 0) {
                passPart = 1;
            }
            src.append(this.password.substring(0, passPart));
            try {
                src.append(CodeAuthentication.this.jcrService.getCurrentRepository().getConfiguration().getName());
            }
            catch (RepositoryException e) {
                LOG.warn((Object)"Error getting current JCR repository", (Throwable)e);
                src.append('?');
            }
            src.append(this.serviceURL);
            src.append(this.serviceContext);
            src.append(this.created);
            return src.toString();
        }

        public String getUser() {
            return this.user;
        }

        public String getPassword() {
            return this.password;
        }

        public String getServiceContext() {
            return this.serviceContext;
        }

        public void setServiceContext(String serviceContext) {
            this.serviceContext = serviceContext;
        }

        public String getServiceURL() {
            return this.serviceURL;
        }

        public long getCreated() {
            return this.created;
        }

        public boolean equals(Object obj) {
            return this == obj;
        }

        protected void finalize() throws Throwable {
            CodeAuthentication.this.exchanged.values().remove(this);
            super.finalize();
        }
    }
}

