/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.ecms.rest;

import javax.annotation.security.RolesAllowed;
import javax.jcr.Item;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.clouddrive.CloudDrive;
import org.exoplatform.clouddrive.CloudDriveException;
import org.exoplatform.clouddrive.CloudDriveService;
import org.exoplatform.clouddrive.CloudFile;
import org.exoplatform.clouddrive.NotCloudFileException;
import org.exoplatform.clouddrive.NotYetCloudFileException;
import org.exoplatform.clouddrive.ecms.action.CloudFileActionService;
import org.exoplatform.clouddrive.ecms.rest.SharedCloudFile;
import org.exoplatform.clouddrive.jcr.JCRLocalCloudFile;
import org.exoplatform.clouddrive.rest.AcceptedCloudFile;
import org.exoplatform.clouddrive.rest.ErrorEntiry;
import org.exoplatform.clouddrive.rest.LinkedCloudFile;
import org.exoplatform.services.cms.documents.DocumentService;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.MembershipEntry;

@Path(value="/clouddrive/document/")
@Produces(value={"application/json"})
public class FileService
implements ResourceContainer {
    protected static final Log LOG = ExoLogger.getLogger(FileService.class);
    protected final CloudDriveService cloudDrives;
    protected final RepositoryService jcrService;
    protected final SessionProviderService sessionProviders;
    protected final DocumentService documentService;
    protected final CloudFileActionService cloudActions;

    public FileService(CloudDriveService cloudDrives, RepositoryService jcrService, SessionProviderService sessionProviders, DocumentService documentService, CloudFileActionService cloudActions) {
        this.cloudDrives = cloudDrives;
        this.jcrService = jcrService;
        this.sessionProviders = sessionProviders;
        this.documentService = documentService;
        this.cloudActions = cloudActions;
    }

    @GET
    @Path(value="/file/")
    @RolesAllowed(value={"users"})
    public Response getFile(@Context UriInfo uriInfo, @QueryParam(value="workspace") String workspace, @QueryParam(value="path") String path) {
        if (workspace != null) {
            if (path != null) {
                try {
                    CloudDrive local = this.cloudDrives.findDrive(workspace, path);
                    if (local != null) {
                        try {
                            Object file = local.getFile(path);
                            if (!file.getPath().equals(path)) {
                                file = new LinkedCloudFile(file, path);
                            } else {
                                Identity currentIdentity = ConversationState.getCurrent().getIdentity();
                                if (!local.getLocalUser().equals(currentIdentity.getUserId())) {
                                    ExtendedNode fileNode = this.fileNode((CloudFile)file, workspace);
                                    if (fileNode != null) {
                                        String openLink = null;
                                        String filePath = null;
                                        block8: for (AccessControlEntry ace : fileNode.getACL().getPermissionEntries()) {
                                            MembershipEntry me = ace.getMembershipEntry();
                                            if (me != null) {
                                                NodeIterator niter;
                                                DriveData groupDrive;
                                                if (!currentIdentity.getGroups().contains(me.getGroup()) || (groupDrive = this.cloudActions.getGroupDrive(me.getGroup())) == null || !(niter = this.cloudActions.getCloudFileLinks((Node)fileNode, me.getGroup(), groupDrive.getHomePath(), false)).hasNext()) continue;
                                                Node linkNode = niter.nextNode();
                                                filePath = linkNode.getPath();
                                                openLink = this.documentService.getLinkInDocumentsApp(linkNode.getPath(), groupDrive);
                                                break;
                                            }
                                            if (!ace.getIdentity().equals(currentIdentity.getUserId())) continue;
                                            Node profileNode = this.cloudActions.getUserProfileNode(currentIdentity.getUserId());
                                            String userPath = profileNode.getPath();
                                            NodeIterator niter = this.cloudActions.getCloudFileLinks((Node)fileNode, currentIdentity.getUserId(), userPath, false);
                                            while (niter.hasNext()) {
                                                Node linkNode = niter.nextNode();
                                                filePath = linkNode.getPath();
                                                DriveData linkDrive = this.documentService.getDriveOfNode(filePath);
                                                if (linkDrive != null) {
                                                    openLink = this.documentService.getLinkInDocumentsApp(linkNode.getPath(), linkDrive);
                                                    break block8;
                                                }
                                                LOG.warn((Object)("Cannot find Documents drive for shared Cloud File: " + filePath));
                                            }
                                        }
                                        if (openLink != null) {
                                            file = new SharedCloudFile((CloudFile)file, filePath, openLink);
                                        }
                                    } else {
                                        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)ErrorEntiry.message((String)"File node cannot be found.")).build();
                                    }
                                }
                            }
                            return Response.ok().entity(file).build();
                        }
                        catch (NotYetCloudFileException e) {
                            return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)new AcceptedCloudFile(path)).build();
                        }
                        catch (NotCloudFileException e) {
                            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ErrorEntiry.notCloudFile((String)e.getMessage(), (String)workspace, (String)path)).build();
                        }
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Item " + workspace + ":" + path + " not a cloud file or drive not connected."));
                    }
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ErrorEntiry.notCloudDrive((String)"Not a cloud file or drive not connected", (String)workspace, (String)path)).build();
                }
                catch (LoginException e) {
                    LOG.warn((Object)("Error login to read drive file " + workspace + ":" + path + ": " + e.getMessage()));
                    return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)ErrorEntiry.message((String)"Authentication error")).build();
                }
                catch (CloudDriveException e) {
                    LOG.warn((Object)("Error reading file " + workspace + ":" + path), (Throwable)e);
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorEntiry.message((String)("Error reading file. " + e.getMessage()))).build();
                }
                catch (RepositoryException e) {
                    LOG.error((Object)("Error reading file " + workspace + ":" + path), (Throwable)e);
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)ErrorEntiry.message((String)"Error reading file: storage error.")).build();
                }
                catch (Throwable e) {
                    LOG.error((Object)("Error reading file " + workspace + ":" + path), e);
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)ErrorEntiry.message((String)"Error reading file: runtime error.")).build();
                }
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorEntiry.message((String)"Null path")).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorEntiry.message((String)"Null workspace")).build();
    }

    protected ExtendedNode fileNode(CloudFile file, String workspace) throws PathNotFoundException, LoginException, NoSuchWorkspaceException, RepositoryException {
        ExtendedNode node = JCRLocalCloudFile.class.isAssignableFrom(file.getClass()) ? (ExtendedNode)ExtendedNode.class.cast(((JCRLocalCloudFile)JCRLocalCloudFile.class.cast(file)).getNode()) : null;
        if (node == null) {
            SessionProvider sp = this.sessionProviders.getSessionProvider(null);
            if (sp != null) {
                Item item = sp.getSession(workspace, this.jcrService.getCurrentRepository()).getItem(file.getPath());
                if (ExtendedNode.class.isAssignableFrom(item.getClass())) {
                    node = (ExtendedNode)ExtendedNode.class.cast(item);
                } else {
                    LOG.warn((Object)("Cannot cast cloud file node from item: " + item));
                }
            } else {
                LOG.warn((Object)("Cannot get session provider to read cloud file node: " + file.getPath()));
            }
        }
        return node;
    }
}

