/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.restatom.collections;

import java.util.List;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.model.Base;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.abdera.model.Link;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.context.ResponseContextException;
import org.xcmis.restatom.AtomCMIS;
import org.xcmis.restatom.collections.CmisObjectCollection;
import org.xcmis.spi.Connection;
import org.xcmis.spi.FilterNotValidException;
import org.xcmis.spi.InvalidArgumentException;
import org.xcmis.spi.ItemsTree;
import org.xcmis.spi.ObjectNotFoundException;
import org.xcmis.spi.model.CmisObject;
import org.xcmis.spi.model.IncludeRelationships;

public class FolderDescentantsCollection
extends CmisObjectCollection {
    public FolderDescentantsCollection(Connection connection) {
        super(connection);
        this.setHref("/descendants");
    }

    public Iterable<CmisObject> getEntries(RequestContext request) throws ResponseContextException {
        throw new UnsupportedOperationException("entries");
    }

    public String getTitle(RequestContext request) {
        return "Folder Descendants";
    }

    protected void addChildren(Entry entry, List<ItemsTree<CmisObject>> children, IRI feedIri, RequestContext request) throws ResponseContextException {
        Element childrenElement = entry.addExtension(AtomCMIS.CHILDREN);
        String entryId = entry.getId().toString();
        Feed childFeed = request.getAbdera().getFactory().newFeed((Base)childrenElement);
        childFeed.setId("ch:" + entryId);
        childFeed.setTitle("Folder Children");
        childFeed.addAuthor(entry.getAuthor());
        childFeed.setUpdated(entry.getUpdated());
        List links = entry.getLinks(new String[]{"service", "self", "down", "http://docs.oasis-open.org/ns/cmis/link/200908/foldertree", "up"});
        for (Link l : links) {
            childFeed.addLink((Link)l.clone());
        }
        childFeed.addLink(this.getObjectLink(entryId, request), "via", "application/atom+xml;type=entry", null, null, -1L);
        Element numItems = request.getAbdera().getFactory().newElement(AtomCMIS.NUM_ITEMS, (Base)childrenElement);
        numItems.setText(Integer.toString(children.size()));
        for (ItemsTree<CmisObject> oifContainer : children) {
            Entry ch = request.getAbdera().getFactory().newEntry((Base)childFeed);
            this.addEntryDetails(request, ch, feedIri, (CmisObject)oifContainer.getContainer());
            if (((CmisObject)oifContainer.getContainer()).getPathSegment() != null) {
                Element pathSegment = ch.addExtension(AtomCMIS.PATH_SEGMENT);
                pathSegment.setText(((CmisObject)oifContainer.getContainer()).getPathSegment());
            }
            if (oifContainer.getChildren() == null || oifContainer.getChildren().size() <= 0) continue;
            this.addChildren(ch, oifContainer.getChildren(), feedIri, request);
        }
    }

    protected void addFeedDetails(Feed feed, RequestContext request) throws ResponseContextException {
        try {
            List descendants;
            IncludeRelationships includeRelationships;
            boolean includeAllowableActions = this.getBooleanParameter(request, "includeAllowableActions", false);
            boolean includePathSegments = this.getBooleanParameter(request, "includePathSegment", false);
            String propertyFilter = request.getParameter("filter");
            String renditionFilter = request.getParameter("renditionFilter");
            try {
                includeRelationships = request.getParameter("includeRelationships") == null || request.getParameter("includeRelationships").length() == 0 ? IncludeRelationships.NONE : IncludeRelationships.fromValue((String)request.getParameter("includeRelationships"));
            }
            catch (IllegalArgumentException iae) {
                String msg = "Invalid parameter " + request.getParameter("includeRelationships");
                throw new ResponseContextException(msg, 400);
            }
            int depth = this.getIntegerParameter(request, "depth", -1);
            Connection connection = this.getConnection(request);
            String objectId = this.getId(request);
            if (!objectId.equals(connection.getStorage().getRepositoryInfo().getRootFolderId())) {
                CmisObject parent = connection.getFolderParent(objectId, true, null);
                feed.addLink(this.getObjectLink(this.getId(parent), request), "up", "application/atom+xml;type=entry", null, null, -1L);
            }
            if ((descendants = connection.getDescendants(objectId, depth, includeAllowableActions, includeRelationships, includePathSegments, true, propertyFilter, renditionFilter)).size() > 0) {
                Element numItems = feed.addExtension(AtomCMIS.NUM_ITEMS);
                numItems.setText(Integer.toString(descendants.size()));
                for (ItemsTree oifContainer : descendants) {
                    Entry e = feed.addEntry();
                    IRI feedIri = new IRI(this.getFeedIriForEntry(oifContainer.getContainer(), request));
                    this.addEntryDetails(request, e, feedIri, (CmisObject)oifContainer.getContainer());
                    if (((CmisObject)oifContainer.getContainer()).getPathSegment() != null) {
                        Element pathSegment = e.addExtension(AtomCMIS.PATH_SEGMENT);
                        pathSegment.setText(((CmisObject)oifContainer.getContainer()).getPathSegment());
                    }
                    if (oifContainer.getChildren() == null || oifContainer.getChildren().size() <= 0) continue;
                    this.addChildren(e, oifContainer.getChildren(), feedIri, request);
                }
            }
        }
        catch (FilterNotValidException fe) {
            throw new ResponseContextException(this.createErrorResponse(fe, 400));
        }
        catch (ObjectNotFoundException onfe) {
            throw new ResponseContextException(this.createErrorResponse(onfe, 404));
        }
        catch (InvalidArgumentException iae) {
            throw new ResponseContextException(this.createErrorResponse(iae, 400));
        }
        catch (Throwable t) {
            throw new ResponseContextException(this.createErrorResponse(t, 500));
        }
    }

    @Override
    protected Feed createFeedBase(RequestContext request) throws ResponseContextException {
        String folderTree;
        Feed feed = super.createFeedBase(request);
        String id = this.getId(request);
        feed.addLink(this.getChildrenLink(id, request), "down", "application/atom+xml;type=feed", null, null, -1L);
        String descendants = this.getDescendantsLink(id, request);
        if (descendants != null) {
            feed.addLink(descendants, "down", "application/cmistree+xml", null, null, -1L);
        }
        if ((folderTree = this.getFolderTreeLink(id, request)) != null) {
            feed.addLink(folderTree, "http://docs.oasis-open.org/ns/cmis/link/200908/foldertree", "application/atom+xml;type=feed", null, null, -1L);
        }
        return feed;
    }
}

