/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.server.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.abdera.model.Categories;
import org.apache.abdera.protocol.server.CategoriesInfo;
import org.apache.abdera.protocol.server.CategoryInfo;
import org.apache.abdera.protocol.server.RequestContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleCategoriesInfo
implements CategoriesInfo,
Serializable {
    private static final long serialVersionUID = 8732335394387909260L;
    private final String href;
    private final String scheme;
    private final boolean fixed;
    private final List<CategoryInfo> list = new ArrayList<CategoryInfo>();

    public SimpleCategoriesInfo() {
        this(null, false, new CategoryInfo[0]);
    }

    public SimpleCategoriesInfo(boolean fixed) {
        this(null, fixed, new CategoryInfo[0]);
    }

    public SimpleCategoriesInfo(String href) {
        this.href = href;
        this.scheme = null;
        this.fixed = false;
    }

    public SimpleCategoriesInfo(String scheme, boolean fixed, CategoryInfo ... categories) {
        this.href = null;
        this.scheme = scheme;
        this.fixed = fixed;
        this.addCategoryInfo(categories);
    }

    @Override
    public String getHref(RequestContext request) {
        return this.href;
    }

    @Override
    public String getScheme(RequestContext request) {
        return this.scheme;
    }

    @Override
    public boolean isFixed(RequestContext request) {
        return this.fixed;
    }

    @Override
    public Iterator<CategoryInfo> iterator() {
        return this.list.iterator();
    }

    public SimpleCategoriesInfo addCategoryInfo(CategoryInfo ... categories) {
        for (CategoryInfo cat : categories) {
            this.list.add(cat);
        }
        return this;
    }

    public SimpleCategoriesInfo setCategoryInfo(CategoryInfo ... categories) {
        this.list.clear();
        return this.addCategoryInfo(categories);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fixed ? 1231 : 1237);
        result = 31 * result + (this.href == null ? 0 : this.href.hashCode());
        result = 31 * result + (this.list == null ? 0 : ((Object)this.list).hashCode());
        result = 31 * result + (this.scheme == null ? 0 : this.scheme.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleCategoriesInfo other = (SimpleCategoriesInfo)obj;
        if (this.fixed != other.fixed) {
            return false;
        }
        if (this.href == null ? other.href != null : !this.href.equals(other.href)) {
            return false;
        }
        if (this.list == null ? other.list != null : !((Object)this.list).equals(other.list)) {
            return false;
        }
        return !(this.scheme == null ? other.scheme != null : !this.scheme.equals(other.scheme));
    }

    @Override
    public Categories asCategoriesElement(RequestContext request) {
        Categories cats = request.getAbdera().getFactory().newCategories();
        if (this.href != null) {
            cats.setHref(this.href);
        } else {
            cats.setFixed(this.fixed);
            cats.setScheme(this.scheme);
            for (CategoryInfo cat : this) {
                cats.addCategory(cat.asCategoryElement(request));
            }
        }
        return cats;
    }
}

