/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.search.lucene.index.merge;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import org.xcmis.search.lucene.index.LuceneIndexDataManager;
import org.xcmis.search.lucene.index.merge.IndexSizeAggregatePolicy;
import org.xcmis.spi.utils.Logger;

public class DocumentCountAggregatePolicy
extends IndexSizeAggregatePolicy {
    private final Logger log = Logger.getLogger(DocumentCountAggregatePolicy.class);
    public static final int DEFAULT_MAX_DOCUMENTS_4_DIR = 150;
    public static final int DEFAULT_MIN_DOCUMENTS_4_DIR = 0;
    private int maxDocuments4Dir = 150;
    private int minDocuments4Dir = 0;

    public int getMinDocuments4Dir() {
        return this.minDocuments4Dir;
    }

    public void setMinDocuments4Dir(int minDocuments4Dir) {
        this.minDocuments4Dir = minDocuments4Dir;
    }

    public int getMaxDocuments4Dir() {
        return this.maxDocuments4Dir;
    }

    public void setMaxDocuments4Dir(int maxDocuments4Dir) {
        this.maxDocuments4Dir = maxDocuments4Dir;
    }

    @Override
    public Collection<LuceneIndexDataManager> findIndexDataManagerToAggrigate(Collection<LuceneIndexDataManager> aggregateCandidat, long requiredCandidatCount, long reguiredTotalCandidatSize) {
        Collection<LuceneIndexDataManager> result = null;
        if (requiredCandidatCount == 0L && reguiredTotalCandidatSize == 0L) {
            result = new HashSet<LuceneIndexDataManager>(super.findIndexDataManagerToAggrigate(aggregateCandidat, requiredCandidatCount, reguiredTotalCandidatSize));
            for (LuceneIndexDataManager luceneIndexDataManager : aggregateCandidat) {
                if ((long)this.minDocuments4Dir >= luceneIndexDataManager.getDocumentCount() || luceneIndexDataManager.getDocumentCount() >= (long)this.maxDocuments4Dir) continue;
                result.add(luceneIndexDataManager);
            }
            result.addAll(super.findIndexDataManagerToAggrigate(aggregateCandidat, requiredCandidatCount, reguiredTotalCandidatSize));
        } else if (requiredCandidatCount < (long)aggregateCandidat.size()) {
            result = new ArrayList<LuceneIndexDataManager>();
            LuceneIndexDataManager[] indexes = new LuceneIndexDataManager[aggregateCandidat.size()];
            aggregateCandidat.toArray(indexes);
            Arrays.sort(indexes, new DocumentCountComparator());
            int i = 0;
            while ((long)result.size() < requiredCandidatCount && i < indexes.length) {
                LuceneIndexDataManager index;
                if ((long)this.minDocuments4Dir >= (index = indexes[i++]).getDocumentCount() || index.getDocumentCount() >= (long)this.maxDocuments4Dir) continue;
                result.add(index);
            }
        } else {
            result = aggregateCandidat;
        }
        return result;
    }

    public class DocumentCountComparator
    implements Comparator<LuceneIndexDataManager> {
        @Override
        public int compare(LuceneIndexDataManager o1, LuceneIndexDataManager o2) {
            return (int)(o1.getDocumentCount() - o2.getDocumentCount());
        }
    }
}

