/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.spi;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import org.xcmis.spi.BaseItemsIterator;
import org.xcmis.spi.ContentStream;
import org.xcmis.spi.DocumentData;
import org.xcmis.spi.ItemsIterator;
import org.xcmis.spi.ObjectData;
import org.xcmis.spi.RenditionContentStream;
import org.xcmis.spi.RenditionProvider;
import org.xcmis.spi.model.BaseType;
import org.xcmis.spi.model.Rendition;
import org.xcmis.spi.utils.CmisUtils;
import org.xcmis.spi.utils.Logger;
import org.xcmis.spi.utils.MimeType;

public class RenditionManager {
    private static final Logger LOG = Logger.getLogger(RenditionManager.class);
    private static AtomicReference<RenditionManager> manager = new AtomicReference();
    protected Map<MimeType, RenditionProvider> renditionProviders = new TreeMap<MimeType, RenditionProvider>(new Comparator<MimeType>(){

        @Override
        public int compare(MimeType m1, MimeType m2) {
            if (m1.getType().equals("*") && !m2.getType().equals("*")) {
                return 1;
            }
            if (!m1.getType().equals("*") && m2.getType().equals("*")) {
                return -1;
            }
            if (m1.getSubType().equals("*") && !m2.getSubType().equals("*")) {
                return 1;
            }
            if (!m1.getSubType().equals("*") && m2.getSubType().equals("*")) {
                return -1;
            }
            return m1.toString().compareToIgnoreCase(m2.toString());
        }
    });

    public static RenditionManager getInstance() {
        RenditionManager s = manager.get();
        if (s == null) {
            manager.compareAndSet(null, new RenditionManager());
            s = manager.get();
        }
        return s;
    }

    public static void setInstance(RenditionManager inst) {
        manager.set(inst);
    }

    private static String decode(String in) {
        StringBuffer out = new StringBuffer();
        for (int offset = 0; offset < in.length(); offset += 2) {
            int part = Integer.parseInt(in.substring(offset, offset + 2), 16);
            out.append((char)part);
        }
        return out.toString();
    }

    private static String encode(String in) {
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < in.length(); ++i) {
            out.append(Integer.toHexString(in.charAt(i)));
        }
        return out.toString();
    }

    protected RenditionManager() {
    }

    public void addRenditionProviders(List<String> provs) {
        if (provs != null && !provs.isEmpty()) {
            for (String one : provs) {
                try {
                    RenditionProvider prov = (RenditionProvider)Class.forName(one).newInstance();
                    for (MimeType mimeType : prov.getSupportedMediaType()) {
                        this.renditionProviders.put(mimeType, prov);
                    }
                }
                catch (Exception e) {
                    LOG.error("Cannot instantiate rendition provider instance: ", e);
                }
            }
        }
    }

    public ItemsIterator<Rendition> getRenditions(MimeType mime) {
        if (mime == null) {
            throw new NullPointerException("Mime-type may not be null.");
        }
        ArrayList<Rendition> renditions = new ArrayList<Rendition>();
        for (Map.Entry<MimeType, RenditionProvider> e : this.renditionProviders.entrySet()) {
            if (!e.getKey().match(mime)) continue;
            Rendition rendition = new Rendition();
            rendition.setStreamId(RenditionManager.encode(e.getKey().toString()));
            rendition.setKind(e.getValue().getKind());
            rendition.setMimeType(e.getValue().getProducedMediaType().toString());
            renditions.add(rendition);
        }
        return new BaseItemsIterator<Rendition>(renditions);
    }

    public ItemsIterator<Rendition> getRenditions(ObjectData object) {
        if (object.getBaseType() == BaseType.DOCUMENT && ((DocumentData)object).hasContent()) {
            MimeType mime = MimeType.fromString(((DocumentData)object).getContentStreamMimeType());
            return this.getRenditions(mime);
        }
        return CmisUtils.emptyItemsIterator();
    }

    public RenditionContentStream getStream(ContentStream stream, MimeType mime) throws IOException {
        for (Map.Entry<MimeType, RenditionProvider> e : this.renditionProviders.entrySet()) {
            if (!e.getKey().match(mime)) continue;
            RenditionProvider renditionProvider = e.getValue();
            RenditionContentStream renditionContentStream = renditionProvider.getRenditionStream(stream);
            return renditionContentStream;
        }
        return null;
    }

    public RenditionContentStream getStream(ObjectData object, String streamId) throws IOException {
        if (object.getBaseType() == BaseType.DOCUMENT && ((DocumentData)object).hasContent()) {
            MimeType mime = MimeType.fromString(RenditionManager.decode(streamId));
            return this.getStream(((DocumentData)object).getContentStream(), mime);
        }
        return null;
    }
}

