/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.restatom;

import java.net.URI;
import javax.ws.rs.core.UriBuilder;
import org.apache.abdera.model.Collection;
import org.apache.abdera.protocol.server.CategoriesInfo;
import org.apache.abdera.protocol.server.CollectionInfo;
import org.apache.abdera.protocol.server.RequestContext;
import org.xcmis.restatom.AtomCMIS;

class CmisCollectionInfo
implements CollectionInfo {
    private static final String[] accept = new String[]{"application/atom+xml;type=entry"};
    private static final CategoriesInfo[] noCategories = new CategoriesInfo[0];
    private static final String[] noSegments = new String[0];
    private final String title;
    private final String relativeHref;
    private final String collectionType;

    CmisCollectionInfo(String title, String relativeHref, String collectionType) {
        this.title = title;
        this.relativeHref = relativeHref;
        this.collectionType = collectionType;
    }

    public Collection asCollectionElement(RequestContext request) {
        throw new UnsupportedOperationException();
    }

    public Collection asCollectionElement(RequestContext request, String baseUri, String ... segments) {
        Collection collection = request.getAbdera().getFactory().newCollection();
        collection.setHref(this.getHref(request, baseUri, segments));
        collection.setTitle(this.getTitle(request));
        collection.addSimpleExtension(AtomCMIS.COLLECTION_TYPE, this.collectionType);
        return collection;
    }

    public String[] getAccepts(RequestContext request) {
        return accept;
    }

    public CategoriesInfo[] getCategoriesInfo(RequestContext request) {
        return noCategories;
    }

    public String getCollectionType() {
        return this.collectionType;
    }

    public String getHref(RequestContext request) {
        throw new UnsupportedOperationException();
    }

    public String getHref(RequestContext request, String baseUri, String ... segments) {
        URI uri = UriBuilder.fromUri((String)baseUri).path(this.relativeHref).segment(segments == null ? noSegments : segments).build(new Object[0]);
        return uri.toString();
    }

    public String getTitle(RequestContext request) {
        return this.title;
    }
}

