/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.search.model.source;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.xcmis.search.QueryObjectModelVisitor;
import org.xcmis.search.VisitException;
import org.xcmis.search.Visitors;
import org.xcmis.search.model.source.Source;
import org.xcmis.search.model.source.join.JoinCondition;
import org.xcmis.search.model.source.join.JoinType;

public class Join
extends Source {
    private static final long serialVersionUID = 1211161706067474072L;
    private final JoinCondition joinCondition;
    private final JoinType joinType;
    private final Source left;
    private final Source right;
    private final int hcode;

    public Join(Source left, JoinType joinType, Source right, JoinCondition joinCondition) {
        Validate.notNull((Object)left, (String)"The left argument may not be null");
        Validate.notNull((Object)right, (String)"The right argument may not be null");
        Validate.notNull((Object)((Object)joinType), (String)"The joinType argument may not be null");
        Validate.notNull((Object)joinCondition, (String)"The joinCondition argument may not be null");
        this.left = left;
        this.right = right;
        this.joinType = joinType;
        this.joinCondition = joinCondition;
        this.hcode = new HashCodeBuilder().append((Object)left).append((Object)right).append((Object)right).append((Object)joinCondition).toHashCode();
    }

    @Override
    public void accept(QueryObjectModelVisitor visitor) throws VisitException {
        visitor.visit(this);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        Join rhs = (Join)obj;
        return new EqualsBuilder().append((Object)this.left, (Object)rhs.left).append((Object)this.right, (Object)rhs.right).append((Object)this.joinType, (Object)rhs.joinType).append((Object)this.joinCondition, (Object)rhs.joinCondition).isEquals();
    }

    public final JoinCondition getJoinCondition() {
        return this.joinCondition;
    }

    public final Source getLeft() {
        return this.left;
    }

    public final Source getRight() {
        return this.right;
    }

    public final JoinType getType() {
        return this.joinType;
    }

    public int hashCode() {
        return this.hcode;
    }

    public String toString() {
        return Visitors.readable(this);
    }
}

