/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.client.cache;

import java.io.IOException;
import org.apache.abdera.Abdera;
import org.apache.abdera.protocol.client.ClientResponse;
import org.apache.abdera.protocol.client.RequestOptions;
import org.apache.abdera.protocol.client.cache.Cache;
import org.apache.abdera.protocol.client.cache.CachedResponse;
import org.apache.abdera.protocol.util.CacheControlUtil;

public abstract class AbstractCache
implements Cache {
    protected final Abdera abdera;

    protected AbstractCache(Abdera abdera) {
        this.abdera = abdera;
    }

    public Cache.Disposition disposition(Object key, RequestOptions options) {
        CachedResponse response = this.get(key);
        if (response != null && options != null) {
            if (options.isNoCache()) {
                return Cache.Disposition.TRANSPARENT;
            }
            if (response.isNoCache()) {
                return Cache.Disposition.STALE;
            }
            if (options != null && options.isOnlyIfCached()) {
                return Cache.Disposition.FRESH;
            }
            if (response.isMustRevalidate()) {
                return Cache.Disposition.STALE;
            }
            if (response.getCachedTime() != -1L) {
                if (response.isFresh()) {
                    long maxAge = options.getMaxAge();
                    long currentAge = response.getCurrentAge();
                    long minFresh = options.getMinFresh();
                    if (maxAge != -1L) {
                        return maxAge > currentAge ? Cache.Disposition.FRESH : Cache.Disposition.STALE;
                    }
                    if (minFresh != -1L) {
                        return response.getFreshnessLifetime() < currentAge + minFresh ? Cache.Disposition.TRANSPARENT : Cache.Disposition.FRESH;
                    }
                    return Cache.Disposition.FRESH;
                }
                long maxStale = options.getMaxStale();
                if (maxStale != -1L) {
                    return maxStale < response.getHowStale() ? Cache.Disposition.STALE : Cache.Disposition.FRESH;
                }
                return Cache.Disposition.STALE;
            }
        }
        return Cache.Disposition.TRANSPARENT;
    }

    protected abstract void add(Object var1, CachedResponse var2);

    protected abstract CachedResponse createCachedResponse(ClientResponse var1, Object var2) throws IOException;

    private boolean shouldUpdateCache(ClientResponse response, boolean allowedByDefault) {
        if (allowedByDefault) {
            return !response.isNoCache() && !response.isNoStore() && response.getMaxAge() != 0L;
        }
        return response.getExpires() != null || response.getMaxAge() > 0L || response.isMustRevalidate() || response.isPublic() || response.isPrivate();
    }

    public ClientResponse update(Object key, RequestOptions options, ClientResponse response, ClientResponse cached_response) {
        int status = response.getStatus();
        String uri = response.getUri();
        String method = response.getMethod();
        if (!CacheControlUtil.isIdempotent((String)method)) {
            this.remove(uri);
            return response;
        }
        switch (status) {
            case 200: 
            case 203: 
            case 300: 
            case 301: 
            case 410: {
                if (this.shouldUpdateCache(response, true)) {
                    return this.update(key, options, response);
                }
                this.remove(uri);
                break;
            }
            case 304: 
            case 412: {
                if (cached_response != null) {
                    return cached_response;
                }
            }
            default: {
                if (this.shouldUpdateCache(response, false)) {
                    return this.update(key, options, response);
                }
                this.remove(uri);
            }
        }
        return response;
    }

    private ClientResponse update(Object key, RequestOptions options, ClientResponse response) {
        try {
            CachedResponse cachedResponse = this.createCachedResponse(response, key);
            this.add(key, cachedResponse);
            return cachedResponse;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

