/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.spi;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.xcmis.spi.CmisRuntimeException;
import org.xcmis.spi.DocumentData;
import org.xcmis.spi.FolderData;
import org.xcmis.spi.ObjectData;
import org.xcmis.spi.model.AccessControlEntry;
import org.xcmis.spi.model.AllowableActions;
import org.xcmis.spi.model.BaseType;
import org.xcmis.spi.model.CapabilityACL;
import org.xcmis.spi.model.Permission;
import org.xcmis.spi.model.PermissionMapping;
import org.xcmis.spi.model.RepositoryCapabilities;
import org.xcmis.spi.model.RepositoryInfo;
import org.xcmis.spi.model.TypeDefinition;
import org.xcmis.spi.utils.CmisUtils;

public class PermissionService {
    public AllowableActions calculateAllowableActions(ObjectData object, String userId, RepositoryInfo repositoryInfo) {
        if (repositoryInfo.getCapabilities().getCapabilityACL().equals((Object)CapabilityACL.NONE)) {
            return AllowableActions.ALL();
        }
        if (userId == null) {
            userId = repositoryInfo.getPrincipalAnonymous();
        }
        PermissionMapping permissionMapping = repositoryInfo.getAclCapability().getMapping();
        AllowableActions actions = new AllowableActions();
        TypeDefinition type = object.getTypeDefinition();
        RepositoryCapabilities capabilities = repositoryInfo.getCapabilities();
        for (String action : AllowableActions.DEFAULT) {
            if ("canGetDescendents".equals(action)) {
                if (!capabilities.isCapabilityGetDescendants() || BaseType.FOLDER != type.getBaseId() || !this.hasPermission(object, permissionMapping.getPermissions("canGetDescendents.Folder"), userId, repositoryInfo)) continue;
                actions.setCanGetDescendants(true);
                continue;
            }
            if ("canGetFolderTree".equals(action)) {
                if (!capabilities.isCapabilityGetFolderTree() || BaseType.FOLDER != type.getBaseId() || !this.hasPermission(object, permissionMapping.getPermissions("canGetFolderTree.Folder"), userId, repositoryInfo)) continue;
                actions.setCanGetFolderTree(true);
                continue;
            }
            if ("canGetChildren".equals(action)) {
                if (BaseType.FOLDER != type.getBaseId() || !this.hasPermission(object, permissionMapping.getPermissions("canGetChildren.Folder"), userId, repositoryInfo)) continue;
                actions.setCanGetChildren(true);
                continue;
            }
            if ("canGetObjectParents".equals(action)) {
                if (!type.isFileable() || !this.hasPermission(object, permissionMapping.getPermissions("canGetObjectParents.Object"), userId, repositoryInfo)) continue;
                actions.setCanGetObjectParents(true);
                continue;
            }
            if ("canGetFolderParent".equals(action)) {
                if (BaseType.FOLDER != type.getBaseId() || !this.hasPermission(object, permissionMapping.getPermissions("canGetFolderParent.Folder"), userId, repositoryInfo)) continue;
                actions.setCanGetFolderParent(true);
                continue;
            }
            if ("canCreateDocument".equals(action)) {
                if (BaseType.FOLDER != type.getBaseId() || !this.hasPermission(object, permissionMapping.getPermissions("canCreateDocument.Folder"), userId, repositoryInfo)) continue;
                actions.setCanCreateDocument(true);
                continue;
            }
            if ("canCreateFolder".equals(action)) {
                if (BaseType.FOLDER != type.getBaseId() || !this.hasPermission(object, permissionMapping.getPermissions("canCreateFolder.Folder"), userId, repositoryInfo)) continue;
                actions.setCanCreateFolder(true);
                continue;
            }
            if ("canCreateRelationship".equals(action)) {
                if (BaseType.RELATIONSHIP == type.getBaseId() || !this.hasPermission(object, permissionMapping.getPermissions("canCreateRelationship.Source"), userId, repositoryInfo) || !this.hasPermission(object, permissionMapping.getPermissions("canCreateRelationship.Target"), userId, repositoryInfo)) continue;
                actions.setCanCreateRelationship(true);
                continue;
            }
            if ("canGetProperties".equals(action)) {
                if (!this.hasPermission(object, permissionMapping.getPermissions("canGetProperties.Object"), userId, repositoryInfo)) continue;
                actions.setCanGetProperties(true);
                continue;
            }
            if ("canGetContentStream".equals(action)) {
                if (BaseType.DOCUMENT != type.getBaseId() || !this.hasPermission(object, permissionMapping.getPermissions("canGetContentStream.Object"), userId, repositoryInfo)) continue;
                actions.setCanGetContentStream(true);
                continue;
            }
            if ("canUpdateProperties".equals(action)) {
                if (!this.hasPermission(object, permissionMapping.getPermissions("canUpdateProperties.Object"), userId, repositoryInfo)) continue;
                actions.setCanUpdateProperties(true);
                continue;
            }
            if ("canMoveObject".equals(action)) {
                if (!type.isFileable() || !this.hasPermission(object, permissionMapping.getPermissions("canMoveObject.Object"), userId, repositoryInfo)) continue;
                actions.setCanMoveObject(true);
                continue;
            }
            if ("canDelete".equals(action)) {
                if (BaseType.FOLDER == type.getBaseId()) {
                    if (((FolderData)object).hasChildren() || !this.hasPermission(object, permissionMapping.getPermissions("canDelete.Object"), userId, repositoryInfo)) continue;
                    actions.setCanDeleteObject(true);
                    continue;
                }
                if (!this.hasPermission(object, permissionMapping.getPermissions("canDelete.Object"), userId, repositoryInfo)) continue;
                actions.setCanDeleteObject(true);
                continue;
            }
            if ("canDeleteTree".equals(action)) {
                if (BaseType.FOLDER != type.getBaseId() || !this.hasPermission(object, permissionMapping.getPermissions("canDeleteTree.Folder"), userId, repositoryInfo)) continue;
                actions.setCanDeleteTree(true);
                continue;
            }
            if ("canSetContentStream".equals(action)) {
                if (BaseType.DOCUMENT != type.getBaseId() || !this.hasPermission(object, permissionMapping.getPermissions("canSetContentStream.Document"), userId, repositoryInfo)) continue;
                actions.setCanSetContentStream(true);
                continue;
            }
            if ("canDeleteContentStream".equals(action)) {
                if (BaseType.DOCUMENT != type.getBaseId() || !this.hasPermission(object, permissionMapping.getPermissions("canDeleteContentStream.Document"), userId, repositoryInfo)) continue;
                actions.setCanDeleteContentStream(true);
                continue;
            }
            if ("canRenditions".equals(action)) {
                if (BaseType.DOCUMENT != type.getBaseId() || !this.hasPermission(object, permissionMapping.getPermissions("canRenditions.Object"), userId, repositoryInfo)) continue;
                actions.setCanGetRenditions(true);
                continue;
            }
            if ("canAddToFolder".equals(action)) {
                if (!type.isFileable() || !this.hasPermission(object, permissionMapping.getPermissions("canAddToFolder.Object"), userId, repositoryInfo)) continue;
                actions.setCanAddObjectToFolder(true);
                continue;
            }
            if ("canRemoveObjectFromFolder".equals(action)) {
                if (!type.isFileable() || type.getBaseId() == BaseType.FOLDER || !this.hasPermission(object, permissionMapping.getPermissions("canRemoveObjectFromFolder.Object"), userId, repositoryInfo) || !repositoryInfo.getCapabilities().isCapabilityUnfiling() && object.getParents().size() <= 1) continue;
                actions.setCanRemoveObjectFromFolder(true);
                continue;
            }
            if ("canCheckout".equals(action)) {
                if (!type.isVersionable() || !this.hasPermission(object, permissionMapping.getPermissions("canCheckout.Document"), userId, repositoryInfo)) continue;
                actions.setCanCheckOut(true);
                continue;
            }
            if ("canCancelCheckout".equals(action)) {
                if (!type.isVersionable() || !((DocumentData)object).isVersionSeriesCheckedOut() || !this.hasPermission(object, permissionMapping.getPermissions("canCancelCheckout.Document"), userId, repositoryInfo)) continue;
                actions.setCanCancelCheckOut(true);
                continue;
            }
            if ("canCheckin".equals(action)) {
                if (!type.isVersionable() || !((DocumentData)object).isPWC() || !this.hasPermission(object, permissionMapping.getPermissions("canCheckin.Document"), userId, repositoryInfo)) continue;
                actions.setCanCancelCheckOut(true);
                continue;
            }
            if ("canGetAllVersions".equals(action)) {
                if (BaseType.DOCUMENT != type.getBaseId() || !this.hasPermission(object, permissionMapping.getPermissions("canGetAllVersions.Document"), userId, repositoryInfo)) continue;
                actions.setCanGetAllVersions(true);
                continue;
            }
            if ("canGetObjectRelationships".equals(action)) {
                if (BaseType.RELATIONSHIP == type.getBaseId() || !this.hasPermission(object, permissionMapping.getPermissions("canGetObjectRelationships.Object"), userId, repositoryInfo)) continue;
                actions.setCanGetObjectRelationships(true);
                continue;
            }
            if ("canAddPolicy".equals(action)) {
                if (!type.isControllablePolicy() || !this.hasPermission(object, permissionMapping.getPermissions("canAddPolicy.Object"), userId, repositoryInfo)) continue;
                actions.setCanApplyPolicy(true);
                continue;
            }
            if ("canRemovePolicy".equals(action)) {
                if (!type.isControllablePolicy() || !this.hasPermission(object, permissionMapping.getPermissions("canRemovePolicy.Object"), userId, repositoryInfo)) continue;
                actions.setCanRemovePolicy(true);
                continue;
            }
            if ("canGetAppliedPolicies".equals(action)) {
                if (!type.isControllablePolicy() || !this.hasPermission(object, permissionMapping.getPermissions("canGetAppliedPolicies.Object"), userId, repositoryInfo)) continue;
                actions.setCanGetAppliedPolicies(true);
                continue;
            }
            if ("canGetACL".equals(action)) {
                if (!type.isControllableACL() || !this.hasPermission(object, permissionMapping.getPermissions("canGetACL.Object"), userId, repositoryInfo)) continue;
                actions.setCanGetACL(true);
                continue;
            }
            if (!"canApplyACL".equals(action) || !type.isControllableACL() || !this.hasPermission(object, permissionMapping.getPermissions("canApplyACL.Object"), userId, repositoryInfo)) continue;
            actions.setCanApplyACL(true);
        }
        return actions;
    }

    public boolean hasPermission(ObjectData object, Collection<String> permissions, String userId, RepositoryInfo repositoryInfo) {
        List<AccessControlEntry> acl;
        if (permissions == null || permissions.size() == 0) {
            throw new CmisRuntimeException("Permissions set may not be null or empty.");
        }
        if (userId == null) {
            userId = repositoryInfo.getPrincipalAnonymous();
        }
        if ((acl = object.getACL(false)).size() == 0) {
            return true;
        }
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        CmisUtils.addAclToPermissionMap(map, acl);
        for (String principal : new String[]{repositoryInfo.getPrincipalAnyone(), userId}) {
            Set p = (Set)map.get(principal);
            if (p == null) continue;
            if (p.contains(Permission.BasicPermissions.CMIS_ALL.value())) {
                return true;
            }
            return p.containsAll(permissions);
        }
        return false;
    }
}

