/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.search.model.operand;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.xcmis.search.Visitors;
import org.xcmis.search.model.QueryElement;
import org.xcmis.search.model.source.SelectorName;

public abstract class DynamicOperand
implements QueryElement {
    private static final long serialVersionUID = 1L;
    private final Set<SelectorName> selectorNames;
    private final int hcode;

    protected DynamicOperand(Collection<SelectorName> selectorNames) {
        Validate.noNullElements(selectorNames, (String)"The selectorNames argument may not be null");
        this.selectorNames = Collections.unmodifiableSet(new LinkedHashSet<SelectorName>(selectorNames));
        this.hcode = new HashCodeBuilder().append(selectorNames).toHashCode();
    }

    protected DynamicOperand(DynamicOperand operand) {
        this((Collection<SelectorName>)operand.getSelectorNames());
    }

    protected DynamicOperand(DynamicOperand ... operands) {
        Validate.noNullElements((Object[])operands, (String)"The operands argument may not be null");
        LinkedHashSet<SelectorName> names = new LinkedHashSet<SelectorName>();
        for (DynamicOperand operand : operands) {
            names.addAll(operand.getSelectorNames());
        }
        this.selectorNames = Collections.unmodifiableSet(names);
        this.hcode = new HashCodeBuilder().append(this.selectorNames).toHashCode();
    }

    protected DynamicOperand(Iterable<? extends DynamicOperand> operands) {
        Validate.notNull(operands, (String)"The operands argument may not be null");
        if (operands == null) {
            throw new IllegalArgumentException("operands shoud not be null");
        }
        LinkedHashSet<SelectorName> names = new LinkedHashSet<SelectorName>();
        for (DynamicOperand dynamicOperand : operands) {
            Validate.notNull((Object)dynamicOperand, (String)"The operand argument may not be null");
            names.addAll(dynamicOperand.getSelectorNames());
        }
        this.selectorNames = Collections.unmodifiableSet(names);
        this.hcode = new HashCodeBuilder().append(this.selectorNames).toHashCode();
    }

    protected DynamicOperand(SelectorName ... selectorNames) {
        if (selectorNames.length == 1) {
            Validate.notNull((Object)selectorNames, (String)"The selectorNames argument may not be null");
            this.selectorNames = Collections.singleton(selectorNames[0]);
        } else {
            Validate.noNullElements((Object[])selectorNames, (String)"The selectorNames argument may not be null");
            this.selectorNames = Collections.unmodifiableSet(new LinkedHashSet<SelectorName>(Arrays.asList(selectorNames)));
        }
        this.hcode = new HashCodeBuilder().append((Object[])selectorNames).toHashCode();
    }

    public Set<SelectorName> getSelectorNames() {
        return this.selectorNames;
    }

    public String toString() {
        return Visitors.readable(this);
    }

    public int hashCode() {
        return this.hcode;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        DynamicOperand rhs = (DynamicOperand)obj;
        return new EqualsBuilder().append(this.selectorNames, rhs.selectorNames).isEquals();
    }
}

