/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.spi;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.xcmis.spi.ChangeLogTokenHolder;
import org.xcmis.spi.ChangeTokenHolder;
import org.xcmis.spi.CmisRuntimeException;
import org.xcmis.spi.ConstraintException;
import org.xcmis.spi.ContentAlreadyExistsException;
import org.xcmis.spi.ContentStream;
import org.xcmis.spi.DocumentData;
import org.xcmis.spi.FilterNotValidException;
import org.xcmis.spi.FolderData;
import org.xcmis.spi.InvalidArgumentException;
import org.xcmis.spi.ItemsIterator;
import org.xcmis.spi.ItemsList;
import org.xcmis.spi.ItemsTree;
import org.xcmis.spi.NameConstraintViolationException;
import org.xcmis.spi.NotSupportedException;
import org.xcmis.spi.ObjectData;
import org.xcmis.spi.ObjectNotFoundException;
import org.xcmis.spi.PolicyData;
import org.xcmis.spi.PropertyFilter;
import org.xcmis.spi.RelationshipData;
import org.xcmis.spi.RenditionFilter;
import org.xcmis.spi.Storage;
import org.xcmis.spi.StorageException;
import org.xcmis.spi.StreamNotSupportedException;
import org.xcmis.spi.TypeNotFoundException;
import org.xcmis.spi.UpdateConflictException;
import org.xcmis.spi.VersioningException;
import org.xcmis.spi.model.AccessControlEntry;
import org.xcmis.spi.model.AccessControlPropagation;
import org.xcmis.spi.model.AllowableActions;
import org.xcmis.spi.model.BaseType;
import org.xcmis.spi.model.CapabilityACL;
import org.xcmis.spi.model.CapabilityRendition;
import org.xcmis.spi.model.ChangeEvent;
import org.xcmis.spi.model.ChangeInfo;
import org.xcmis.spi.model.ChangeType;
import org.xcmis.spi.model.CmisObject;
import org.xcmis.spi.model.ContentStreamAllowed;
import org.xcmis.spi.model.IncludeRelationships;
import org.xcmis.spi.model.ObjectInfo;
import org.xcmis.spi.model.ObjectParent;
import org.xcmis.spi.model.Permission;
import org.xcmis.spi.model.Property;
import org.xcmis.spi.model.PropertyDefinition;
import org.xcmis.spi.model.RelationshipDirection;
import org.xcmis.spi.model.Rendition;
import org.xcmis.spi.model.TypeDefinition;
import org.xcmis.spi.model.UnfileObject;
import org.xcmis.spi.model.VersioningState;
import org.xcmis.spi.model.impl.DecimalProperty;
import org.xcmis.spi.model.impl.IdProperty;
import org.xcmis.spi.query.Query;
import org.xcmis.spi.query.Result;
import org.xcmis.spi.query.Score;
import org.xcmis.spi.utils.CmisUtils;
import org.xcmis.spi.utils.Logger;

public abstract class Connection {
    protected static final int CREATE = 1;
    protected static final int UPDATE = 2;
    protected static final int VERSION = 4;
    private static final Logger LOG = Logger.getLogger(Connection.class);
    protected Storage storage;

    public Connection(Storage storage) {
        this.storage = storage;
    }

    public void addObjectToFolder(String objectId, String folderId, boolean allVersions) throws ObjectNotFoundException, ConstraintException {
        this.checkConnection();
        if (!this.storage.getRepositoryInfo().getCapabilities().isCapabilityMultifiling()) {
            throw new NotSupportedException("Multi-filing is not supported.");
        }
        if (!allVersions && !this.storage.getRepositoryInfo().getCapabilities().isCapabilityVersionSpecificFiling()) {
            throw new ConstraintException("Version-specific filling capability is not supported.");
        }
        ObjectData object = this.storage.getObjectById(objectId);
        ObjectData folder = this.storage.getObjectById(folderId);
        if (folder.getBaseType() != BaseType.FOLDER) {
            throw new InvalidArgumentException("Object " + folderId + " is not a folder object.");
        }
        if (!object.getTypeDefinition().isFileable()) {
            throw new InvalidArgumentException("Object " + objectId + " is not fileable.");
        }
        if (!((FolderData)folder).isAllowedChildType(object.getTypeId())) {
            throw new ConstraintException("Object type " + object.getTypeId() + " is not allowed as child for destination folder");
        }
        ((FolderData)folder).addObject(object);
    }

    public String addType(TypeDefinition type) throws ConstraintException, StorageException {
        this.checkConnection();
        String id = this.storage.addType(type);
        return id;
    }

    public void applyACL(String objectId, List<AccessControlEntry> addACL, List<AccessControlEntry> removeACL, AccessControlPropagation propagation) throws ObjectNotFoundException, ConstraintException {
        AccessControlPropagation storagePropagation;
        if (!(addACL != null && addACL.size() != 0 || removeACL != null && removeACL.size() != 0)) {
            return;
        }
        this.checkConnection();
        if (propagation == null) {
            propagation = AccessControlPropagation.REPOSITORYDETERMINED;
        }
        if (propagation != (storagePropagation = this.storage.getRepositoryInfo().getAclCapability().getPropagation())) {
            throw new ConstraintException("Specified ACL propagation '" + (Object)((Object)propagation) + "' does not to supported by repository '" + (Object)((Object)storagePropagation) + "' ");
        }
        ObjectData object = this.storage.getObjectById(objectId);
        TypeDefinition typeDefinition = object.getTypeDefinition();
        this.checkACL(typeDefinition, addACL, removeACL);
        List<AccessControlEntry> mergedACL = CmisUtils.mergeACLs(object.getACL(false), addACL, removeACL);
        object.setACL(mergedACL);
    }

    public void applyPolicy(String policyId, String objectId) throws ConstraintException, ObjectNotFoundException {
        this.checkConnection();
        ObjectData object = this.storage.getObjectById(objectId);
        if (!object.getTypeDefinition().isControllablePolicy()) {
            throw new ConstraintException("Object type " + object.getTypeId() + " is not controllable by policy.");
        }
        ObjectData policy = this.storage.getObjectById(policyId);
        if (policy.getBaseType() != BaseType.POLICY) {
            throw new InvalidArgumentException("Object " + policy.getObjectId() + " is not a Policy object.");
        }
        object.applyPolicy((PolicyData)policy);
    }

    public void cancelCheckout(String documentId) throws ObjectNotFoundException, ConstraintException, UpdateConflictException, VersioningException, StorageException {
        this.checkConnection();
        ObjectData document = this.storage.getObjectById(documentId);
        if (!document.getTypeDefinition().isVersionable()) {
            throw new ConstraintException("Type " + document.getTypeId() + " is not versionable.");
        }
        if (document.getBaseType() != BaseType.DOCUMENT) {
            throw new InvalidArgumentException("Object " + documentId + " is not a Document object.");
        }
        if (!((DocumentData)document).isVersionSeriesCheckedOut()) {
            throw new InvalidArgumentException("There is no Private Working Copy in version series.");
        }
        ((DocumentData)document).cancelCheckout();
    }

    public String checkin(String documentId, boolean major, Map<String, Property<?>> properties, ContentStream content, String checkinComment, List<AccessControlEntry> addACL, List<AccessControlEntry> removeACL, Collection<String> policies) throws ObjectNotFoundException, ConstraintException, VersioningException, NameConstraintViolationException, UpdateConflictException, StreamNotSupportedException, StorageException {
        this.checkConnection();
        ObjectData pwc = this.storage.getObjectById(documentId);
        if (!pwc.getTypeDefinition().isVersionable()) {
            throw new ConstraintException("Type " + pwc.getTypeId() + " is not versionable.");
        }
        if (pwc.getBaseType() != BaseType.DOCUMENT) {
            throw new InvalidArgumentException("Object " + documentId + " is not a Document object.");
        }
        if (!((DocumentData)pwc).isPWC()) {
            throw new VersioningException("Object " + documentId + " is not Private Working Copy.");
        }
        TypeDefinition typeDefinition = pwc.getTypeDefinition();
        this.checkProperties(typeDefinition, properties, 4);
        if (typeDefinition.getContentStreamAllowed() == ContentStreamAllowed.NOT_ALLOWED && content != null) {
            throw new StreamNotSupportedException("Content stream not allowed for object of type " + typeDefinition.getId());
        }
        this.checkACL(typeDefinition, addACL, removeACL);
        this.checkPolicies(typeDefinition, policies);
        DocumentData version = ((DocumentData)pwc).checkin(major, checkinComment, properties, content, CmisUtils.mergeACLs(pwc.getACL(false), addACL, removeACL), this.createPolicyList(policies));
        return version.getObjectId();
    }

    public String checkout(String documentId) throws ObjectNotFoundException, ConstraintException, UpdateConflictException, VersioningException, StorageException {
        this.checkConnection();
        ObjectData document = this.storage.getObjectById(documentId);
        if (!document.getTypeDefinition().isVersionable()) {
            throw new ConstraintException("Type " + document.getTypeId() + " is not versionable.");
        }
        if (document.getBaseType() != BaseType.DOCUMENT) {
            throw new InvalidArgumentException("Object " + documentId + " is not a Document object.");
        }
        DocumentData pwc = ((DocumentData)document).checkout();
        return pwc.getObjectId();
    }

    public abstract void close();

    public String createDocument(String parentId, Map<String, Property<?>> properties, ContentStream content, List<AccessControlEntry> addACL, List<AccessControlEntry> removeACL, Collection<String> policies, VersioningState versioningState) throws ObjectNotFoundException, TypeNotFoundException, ConstraintException, StreamNotSupportedException, NameConstraintViolationException, StorageException {
        this.checkConnection();
        if (properties == null) {
            throw new InvalidArgumentException("Properties may not by null.");
        }
        String typeId = this.getTypeId(properties);
        TypeDefinition typeDefinition = this.getTypeDefinition(typeId, true);
        if (typeDefinition.getBaseId() != BaseType.DOCUMENT) {
            throw new ConstraintException("Type " + typeId + " is not type whose base type is cmis:document.");
        }
        ObjectData parent = null;
        if (parentId != null) {
            parent = this.storage.getObjectById(parentId);
            if (parent.getBaseType() != BaseType.FOLDER) {
                throw new InvalidArgumentException("Object " + parentId + " is not a Folder object.");
            }
            if (!((FolderData)parent).isAllowedChildType(typeId)) {
                throw new ConstraintException("Object type " + typeId + " is not allowed as child for destination folder");
            }
        } else if (!this.storage.getRepositoryInfo().getCapabilities().isCapabilityUnfiling()) {
            throw new ConstraintException("Unfiling capability is not supported, parent folder must be provided.");
        }
        if (versioningState == null) {
            versioningState = VersioningState.MAJOR;
        }
        if (versioningState == VersioningState.NONE && typeDefinition.isVersionable()) {
            throw new ConstraintException("Type " + typeDefinition.getId() + " is versionable, versioning state 'none' not allowed.");
        }
        this.checkProperties(typeDefinition, properties, 1);
        this.checkContent(typeDefinition, content);
        this.checkACL(typeDefinition, addACL, removeACL);
        this.checkPolicies(typeDefinition, policies);
        try {
            DocumentData newDocument = this.storage.createDocument((FolderData)parent, typeDefinition, properties, content, CmisUtils.mergeACLs(parent != null ? parent.getACL(false) : null, addACL, removeACL), this.createPolicyList(policies), versioningState);
            return newDocument.getObjectId();
        }
        catch (IOException ioe) {
            throw new CmisRuntimeException(ioe.getMessage(), ioe);
        }
    }

    public String createDocumentFromSource(String sourceId, String parentId, Map<String, Property<?>> properties, List<AccessControlEntry> addACL, List<AccessControlEntry> removeACL, Collection<String> policies, VersioningState versioningState) throws ObjectNotFoundException, ConstraintException, NameConstraintViolationException, StorageException {
        this.checkConnection();
        ObjectData source = this.storage.getObjectById(sourceId);
        TypeDefinition typeDefinition = source.getTypeDefinition();
        if (typeDefinition.getBaseId() != BaseType.DOCUMENT) {
            throw new ConstraintException("Source object is not Document.");
        }
        ObjectData parent = null;
        if (parentId != null) {
            parent = this.storage.getObjectById(parentId);
            if (parent.getBaseType() != BaseType.FOLDER) {
                throw new InvalidArgumentException("Object " + parentId + " is not a Folder object.");
            }
            if (!((FolderData)parent).isAllowedChildType(typeDefinition.getId())) {
                throw new ConstraintException("Object type " + typeDefinition.getId() + " is not allowed as child for destination folder");
            }
        } else if (!this.storage.getRepositoryInfo().getCapabilities().isCapabilityUnfiling()) {
            throw new ConstraintException("Unfiling capability is not supported, parent folder must be provided.");
        }
        if (versioningState == null) {
            versioningState = VersioningState.MAJOR;
        }
        this.checkProperties(typeDefinition, properties, 1);
        this.checkACL(typeDefinition, addACL, removeACL);
        this.checkPolicies(typeDefinition, policies);
        DocumentData newDocument = this.storage.copyDocument((DocumentData)source, (FolderData)parent, properties, CmisUtils.mergeACLs(parent != null ? parent.getACL(false) : null, addACL, removeACL), this.createPolicyList(policies), versioningState);
        return newDocument.getObjectId();
    }

    public String createFolder(String parentId, Map<String, Property<?>> properties, List<AccessControlEntry> addACL, List<AccessControlEntry> removeACL, Collection<String> policies) throws ObjectNotFoundException, TypeNotFoundException, ConstraintException, NameConstraintViolationException, StorageException {
        this.checkConnection();
        if (properties == null) {
            throw new InvalidArgumentException("Properties may not by null.");
        }
        if (parentId == null) {
            throw new ConstraintException("Parent folder id is not specified.");
        }
        String typeId = this.getTypeId(properties);
        TypeDefinition typeDefinition = this.getTypeDefinition(typeId, true);
        if (typeDefinition.getBaseId() != BaseType.FOLDER) {
            throw new ConstraintException("Type " + typeId + " is not type whose base type is cmis:folder.");
        }
        ObjectData parent = this.storage.getObjectById(parentId);
        if (parent.getBaseType() != BaseType.FOLDER) {
            throw new InvalidArgumentException("Object " + parentId + " is not a Folder object.");
        }
        if (!((FolderData)parent).isAllowedChildType(typeId)) {
            throw new ConstraintException("Object type " + typeId + " is not allowed as child for destination folder");
        }
        this.checkProperties(typeDefinition, properties, 1);
        this.checkACL(typeDefinition, addACL, removeACL);
        this.checkPolicies(typeDefinition, policies);
        FolderData newFolder = this.storage.createFolder((FolderData)parent, typeDefinition, properties, CmisUtils.mergeACLs(parent.getACL(false), addACL, removeACL), this.createPolicyList(policies));
        return newFolder.getObjectId();
    }

    public String createPolicy(String parentId, Map<String, Property<?>> properties, List<AccessControlEntry> addACL, List<AccessControlEntry> removeACL, Collection<String> policies) throws ObjectNotFoundException, TypeNotFoundException, ConstraintException, NameConstraintViolationException, StorageException {
        this.checkConnection();
        if (properties == null) {
            throw new InvalidArgumentException("Properties may not by null.");
        }
        String typeId = this.getTypeId(properties);
        TypeDefinition typeDefinition = this.getTypeDefinition(typeId, true);
        if (typeDefinition.getBaseId() != BaseType.POLICY) {
            throw new ConstraintException("Type " + typeId + " is not type whose base type is cmis:policy.");
        }
        ObjectData parent = null;
        if (parentId != null) {
            parent = this.storage.getObjectById(parentId);
            if (parent.getBaseType() != BaseType.FOLDER) {
                throw new InvalidArgumentException("Object " + parentId + " is not a Folder object.");
            }
            if (!((FolderData)parent).isAllowedChildType(typeId)) {
                throw new ConstraintException("Object type " + typeId + " is not allowed as child for destination folder");
            }
        } else if (typeDefinition.isFileable()) {
            throw new ConstraintException("Policy type is fileable. Parent folder must be provided.");
        }
        this.checkProperties(typeDefinition, properties, 1);
        this.checkACL(typeDefinition, addACL, removeACL);
        this.checkPolicies(typeDefinition, policies);
        PolicyData newPolicy = this.storage.createPolicy((FolderData)parent, typeDefinition, properties, CmisUtils.mergeACLs(parent != null ? parent.getACL(false) : null, addACL, removeACL), this.createPolicyList(policies));
        return newPolicy.getObjectId();
    }

    public String createRelationship(Map<String, Property<?>> properties, List<AccessControlEntry> addACL, List<AccessControlEntry> removeACL, Collection<String> policies) throws ObjectNotFoundException, TypeNotFoundException, ConstraintException, NameConstraintViolationException, StorageException {
        this.checkConnection();
        if (properties == null) {
            throw new InvalidArgumentException("Properties may not by null.");
        }
        String typeId = this.getTypeId(properties);
        TypeDefinition typeDefinition = this.getTypeDefinition(typeId, true);
        if (typeDefinition.getBaseId() != BaseType.RELATIONSHIP) {
            throw new ConstraintException("Type " + typeId + " is not type whose base type is cmis:relationship.");
        }
        String sourceId = this.getSourceId(properties);
        String targetId = this.getTargetId(properties);
        ObjectData source = this.storage.getObjectById(sourceId);
        if (typeDefinition.getAllowedSourceTypes() != null && !Arrays.asList(typeDefinition.getAllowedSourceTypes()).contains(source.getTypeId())) {
            throw new ConstraintException("Source object type " + source.getTypeId() + " is not supported.");
        }
        ObjectData target = this.storage.getObjectById(targetId);
        if (typeDefinition.getAllowedTargetTypes() != null && !Arrays.asList(typeDefinition.getAllowedTargetTypes()).contains(target.getTypeId())) {
            throw new ConstraintException("Target object type " + target.getTypeId() + " is not supported.");
        }
        this.checkProperties(typeDefinition, properties, 1);
        this.checkACL(typeDefinition, addACL, removeACL);
        this.checkPolicies(typeDefinition, policies);
        RelationshipData newRelationship = this.storage.createRelationship(source, target, typeDefinition, properties, CmisUtils.mergeACLs(null, addACL, removeACL), this.createPolicyList(policies));
        return newRelationship.getObjectId();
    }

    private String getTypeId(Map<String, Property<?>> properties) {
        String typeId = this.getSingleValue(properties, "cmis:objectTypeId");
        if (typeId == null) {
            throw new InvalidArgumentException("Type Id ('cmis:objectTypeId') is not specified.");
        }
        return typeId;
    }

    private String getSourceId(Map<String, Property<?>> properties) {
        String typeId = this.getSingleValue(properties, "cmis:sourceId");
        if (typeId == null) {
            throw new InvalidArgumentException("Source Id ('cmis:sourceId')  is not specified.");
        }
        return typeId;
    }

    private String getTargetId(Map<String, Property<?>> properties) {
        String typeId = this.getSingleValue(properties, "cmis:targetId");
        if (typeId == null) {
            throw new InvalidArgumentException("Target Id ('cmis:targetId') is not specified.");
        }
        return typeId;
    }

    private String getSingleValue(Map<String, Property<?>> properties, String name) {
        String value = null;
        Property<?> typeProperty = properties.get(name);
        if (typeProperty != null && typeProperty.getValues().size() > 0) {
            value = (String)typeProperty.getValues().get(0);
        }
        return value;
    }

    public String deleteContentStream(String documentId, ChangeTokenHolder changeTokenHolder) throws ObjectNotFoundException, ConstraintException, UpdateConflictException, VersioningException, StorageException {
        this.checkConnection();
        if (changeTokenHolder == null) {
            throw new NullPointerException("changeTokenHolder may not by null.");
        }
        ObjectData document = this.storage.getObjectById(documentId);
        if (document.getBaseType() != BaseType.DOCUMENT) {
            throw new InvalidArgumentException("Object " + documentId + " is not Document.");
        }
        if (document.getTypeDefinition().getContentStreamAllowed() == ContentStreamAllowed.REQUIRED) {
            throw new ConstraintException("Content stream is required for object and may not be removed.");
        }
        this.validateChangeToken(document, (String)changeTokenHolder.getValue());
        try {
            ((DocumentData)document).setContentStream(null);
        }
        catch (IOException never) {
            throw new CmisRuntimeException("Unable delete document content stream. " + never.getMessage(), never);
        }
        String changeToken = document.getChangeToken();
        changeTokenHolder.setValue(changeToken);
        return document.getObjectId();
    }

    public void deleteObject(String objectId, Boolean deleteAllVersions) throws ObjectNotFoundException, ConstraintException, UpdateConflictException, VersioningException, StorageException {
        this.checkConnection();
        ObjectData object = this.storage.getObjectById(objectId);
        if (object.getBaseType() == BaseType.FOLDER) {
            if (((FolderData)object).hasChildren()) {
                throw new ConstraintException("Failed delete object. Object " + objectId + " is Folder and contains one or more objects.");
            }
            if (((FolderData)object).isRoot()) {
                throw new ConstraintException("Root folder can't be deleted.");
            }
        }
        if (deleteAllVersions == null) {
            deleteAllVersions = true;
        }
        this.storage.deleteObject(object, deleteAllVersions);
    }

    public Collection<String> deleteTree(String folderId, Boolean deleteAllVersions, UnfileObject unfileObject, Boolean continueOnFailure) throws ObjectNotFoundException, ConstraintException, UpdateConflictException {
        this.checkConnection();
        ObjectData folder = this.storage.getObjectById(folderId);
        if (folder.getBaseType() != BaseType.FOLDER) {
            throw new ConstraintException("Failed delete tree. Object " + folderId + " is not a Folder.");
        }
        if (((FolderData)folder).isRoot()) {
            throw new ConstraintException("Root folder can't be removed.");
        }
        if (unfileObject == null) {
            unfileObject = UnfileObject.DELETE;
        }
        if (deleteAllVersions == null) {
            deleteAllVersions = true;
        }
        if (continueOnFailure == null) {
            continueOnFailure = false;
        }
        if (unfileObject != UnfileObject.DELETE && !this.storage.getRepositoryInfo().getCapabilities().isCapabilityUnfiling()) {
            throw new InvalidArgumentException("Unfiling capability is not supported. Parameter 'unfileObject' may not be other then 'DELETE'.");
        }
        Collection<String> failedDelete = this.storage.deleteTree((FolderData)folder, deleteAllVersions, unfileObject, continueOnFailure);
        return failedDelete;
    }

    public List<AccessControlEntry> getACL(String objectId, boolean onlyBasicPermissions) throws ObjectNotFoundException {
        this.checkConnection();
        if (this.storage.getRepositoryInfo().getCapabilities().getCapabilityACL() == CapabilityACL.NONE) {
            throw new NotSupportedException("ACL capability is not supported.");
        }
        ObjectData object = this.storage.getObjectById(objectId);
        List<AccessControlEntry> acl = object.getACL(onlyBasicPermissions);
        return acl;
    }

    public AllowableActions getAllowableActions(String objectId) throws ObjectNotFoundException {
        this.checkConnection();
        ObjectData object = this.storage.getObjectById(objectId);
        return this.storage.calculateAllowableActions(object);
    }

    public List<CmisObject> getAllVersions(String versionSeriesId, boolean includeAllowableActions, boolean includeObjectInfo, String propertyFilter) throws ObjectNotFoundException, FilterNotValidException {
        this.checkConnection();
        Collection<DocumentData> versions = this.storage.getAllVersions(versionSeriesId);
        PropertyFilter parsedPropertyFilter = new PropertyFilter(propertyFilter);
        ArrayList<CmisObject> cmisVersions = new ArrayList<CmisObject>(versions.size());
        for (DocumentData objectData : versions) {
            cmisVersions.add(this.getCmisObject(objectData, includeAllowableActions, IncludeRelationships.NONE, false, false, includeObjectInfo, parsedPropertyFilter, RenditionFilter.NONE_FILTER));
        }
        return cmisVersions;
    }

    public List<CmisObject> getAppliedPolicies(String objectId, boolean includeObjectInfo, String propertyFilter) throws ObjectNotFoundException, FilterNotValidException {
        this.checkConnection();
        ObjectData object = this.storage.getObjectById(objectId);
        Collection<PolicyData> policies = object.getPolicies();
        PropertyFilter parsedPropertyFilter = new PropertyFilter(propertyFilter);
        ArrayList<CmisObject> policyIDs = new ArrayList<CmisObject>(policies.size());
        for (PolicyData policy : policies) {
            CmisObject cmisPolicy = this.getCmisObject(policy, false, IncludeRelationships.NONE, false, false, includeObjectInfo, parsedPropertyFilter, RenditionFilter.NONE_FILTER);
            policyIDs.add(cmisPolicy);
        }
        return policyIDs;
    }

    public ItemsList<CmisObject> getCheckedOutDocs(String folderId, boolean includeAllowableActions, IncludeRelationships includeRelationships, boolean includeObjectInfo, String propertyFilter, String renditionFilter, String orderBy, int maxItems, int skipCount) throws ObjectNotFoundException, InvalidArgumentException, FilterNotValidException {
        this.checkConnection();
        if (skipCount < 0) {
            throw new InvalidArgumentException("skipCount parameter is negative.");
        }
        ObjectData folder = null;
        if (folderId != null && (folder = this.storage.getObjectById(folderId)).getBaseType() != BaseType.FOLDER) {
            throw new InvalidArgumentException("Can't get checkedout documents. Object " + folderId + " is not a Folder.");
        }
        ItemsIterator<DocumentData> iterator = this.storage.getCheckedOutDocuments((FolderData)folder, orderBy);
        try {
            if (skipCount > 0) {
                iterator.skip(skipCount);
            }
        }
        catch (NoSuchElementException nse) {
            throw new InvalidArgumentException("skipCount parameter is greater then total number of items");
        }
        PropertyFilter parsedPropertyFilter = new PropertyFilter(propertyFilter);
        RenditionFilter parsedRenditionFilter = new RenditionFilter(renditionFilter);
        if (includeRelationships == null) {
            includeRelationships = IncludeRelationships.NONE;
        }
        ItemsList<CmisObject> checkedout = new ItemsList<CmisObject>();
        for (int count = 0; iterator.hasNext() && (maxItems < 0 || count < maxItems); ++count) {
            ObjectData pwcData = (ObjectData)iterator.next();
            CmisObject pwc = this.getCmisObject(pwcData, includeAllowableActions, includeRelationships, false, false, includeObjectInfo, parsedPropertyFilter, parsedRenditionFilter);
            checkedout.getItems().add(pwc);
        }
        checkedout.setHasMoreItems(iterator.hasNext());
        checkedout.setNumItems(iterator.size());
        return checkedout;
    }

    public ItemsList<CmisObject> getChildren(String folderId, boolean includeAllowableActions, IncludeRelationships includeRelationships, boolean includePathSegments, boolean includeObjectInfo, String propertyFilter, String renditionFilter, String orderBy, int maxItems, int skipCount) throws ObjectNotFoundException, InvalidArgumentException, FilterNotValidException {
        this.checkConnection();
        if (skipCount < 0) {
            throw new InvalidArgumentException("skipCount parameter is negative.");
        }
        ObjectData folder = this.storage.getObjectById(folderId);
        if (folder.getBaseType() != BaseType.FOLDER) {
            throw new InvalidArgumentException("Can't get children. Object " + folderId + " is not a Folder.");
        }
        ItemsIterator<ObjectData> iterator = ((FolderData)folder).getChildren(orderBy);
        try {
            if (skipCount > 0) {
                iterator.skip(skipCount);
            }
        }
        catch (NoSuchElementException nse) {
            throw new InvalidArgumentException("'skipCount' parameter is greater then total number of items");
        }
        PropertyFilter parsedPropertyFilter = new PropertyFilter(propertyFilter);
        RenditionFilter parsedRenditionFilter = new RenditionFilter(renditionFilter);
        if (includeRelationships == null) {
            includeRelationships = IncludeRelationships.NONE;
        }
        ItemsList<CmisObject> cmisChildren = new ItemsList<CmisObject>();
        for (int count = 0; iterator.hasNext() && (maxItems < 0 || count < maxItems); ++count) {
            ObjectData childData = (ObjectData)iterator.next();
            CmisObject child = this.getCmisObject(childData, includeAllowableActions, includeRelationships, false, false, includeObjectInfo, parsedPropertyFilter, parsedRenditionFilter);
            if (includePathSegments) {
                child.setPathSegment(childData.getName());
            }
            cmisChildren.getItems().add(child);
        }
        cmisChildren.setHasMoreItems(iterator.hasNext());
        cmisChildren.setNumItems(iterator.size());
        return cmisChildren;
    }

    public ItemsList<CmisObject> getContentChanges(ChangeLogTokenHolder changeLogTokenHolder, boolean includeProperties, String propertyFilter, boolean includePolicyIDs, boolean includeAcl, boolean includeObjectInfo, int maxItems) throws ConstraintException, FilterNotValidException {
        if (changeLogTokenHolder == null) {
            throw new NullPointerException("ChangeLogTokenHolder may not by null.");
        }
        String token = (String)changeLogTokenHolder.getValue();
        ItemsIterator<ChangeEvent> iterator = this.storage.getChangeLog(token);
        PropertyFilter parsedPropertyFilter = includeProperties ? new PropertyFilter(propertyFilter) : null;
        ItemsList<CmisObject> cmisChanges = new ItemsList<CmisObject>();
        for (int count = 0; iterator.hasNext() && (maxItems < 0 || count < maxItems); ++count) {
            ChangeEvent event = (ChangeEvent)iterator.next();
            String objectId = event.getObjectId();
            CmisObject cmis = new CmisObject();
            if (includePolicyIDs && event.getType() == ChangeType.SECURITY && event.getPolicyIds() != null && event.getPolicyIds().size() > 0) {
                cmis.getPolicyIds().addAll(event.getPolicyIds());
            }
            if (includeAcl && event.getType() == ChangeType.SECURITY && event.getAcl() != null && event.getAcl().size() > 0) {
                cmis.getACL().addAll(event.getAcl());
            }
            if (includeProperties && event.getType() == ChangeType.UPDATED && event.getProperties() != null) {
                for (Property<?> property : event.getProperties()) {
                    if (!parsedPropertyFilter.accept(property.getQueryName())) continue;
                    String id = property.getId();
                    cmis.getProperties().put(id, property);
                }
            }
            if (cmis.getProperties().get("cmis:objectId") == null) {
                cmis.getProperties().put("cmis:objectId", new IdProperty("cmis:objectId", null, null, null, objectId));
            }
            if (includeObjectInfo) {
                ObjectInfo objectInfo = new ObjectInfo();
                objectInfo.setId(objectId);
                cmis.setObjectInfo(objectInfo);
            }
            cmis.setChangeInfo(new ChangeInfo(event.getDate(), event.getType()));
            token = event.getLogToken();
            cmisChanges.getItems().add(cmis);
        }
        cmisChanges.setHasMoreItems(iterator.hasNext());
        cmisChanges.setNumItems(iterator.size());
        changeLogTokenHolder.setValue(token);
        return cmisChanges;
    }

    public ContentStream getContentStream(String objectId, String streamId) throws ObjectNotFoundException, ConstraintException {
        this.checkConnection();
        ObjectData object = this.storage.getObjectById(objectId);
        ContentStream contentStream = null;
        try {
            if (streamId != null) {
                contentStream = object.getContentStream(streamId);
            } else if (object.getBaseType() == BaseType.DOCUMENT) {
                contentStream = ((DocumentData)object).getContentStream();
            }
        }
        catch (IOException ioe) {
            throw new CmisRuntimeException("Unable get content stream. " + ioe.getMessage(), ioe);
        }
        if (contentStream == null) {
            throw new ConstraintException("Object does not have content stream.");
        }
        return contentStream;
    }

    public List<ItemsTree<CmisObject>> getDescendants(String folderId, int depth, boolean includeAllowableActions, IncludeRelationships includeRelationships, boolean includePathSegments, boolean includeObjectInfo, String propertyFilter, String renditionFilter) throws ObjectNotFoundException, FilterNotValidException {
        this.checkConnection();
        if (depth != -1 && depth < 1) {
            throw new InvalidArgumentException("Invalid depth parameter. Must be 1 or greater then 1 or -1 but " + depth + " specified.");
        }
        return this.getObjectTree(folderId, depth, null, includeAllowableActions, includeRelationships, includePathSegments, includeObjectInfo, propertyFilter, renditionFilter);
    }

    public CmisObject getFolderParent(String folderId, boolean includeObjectInfo, String propertyFilter) throws ObjectNotFoundException, FilterNotValidException {
        this.checkConnection();
        ObjectData folder = this.storage.getObjectById(folderId);
        if (folder.getBaseType() != BaseType.FOLDER) {
            throw new InvalidArgumentException("Object " + folderId + " is not a Folder.");
        }
        if (((FolderData)folder).isRoot()) {
            throw new InvalidArgumentException("Can't get parent of root folder.");
        }
        FolderData parent = null;
        try {
            parent = folder.getParent();
        }
        catch (ConstraintException never) {
            throw new CmisRuntimeException(never.getMessage());
        }
        PropertyFilter parsedPropertyFilter = new PropertyFilter(propertyFilter);
        CmisObject cmisParent = this.getCmisObject(parent, false, IncludeRelationships.NONE, false, false, includeObjectInfo, parsedPropertyFilter, RenditionFilter.NONE_FILTER);
        return cmisParent;
    }

    public List<ItemsTree<CmisObject>> getFolderTree(String folderId, int depth, boolean includeAllowableActions, IncludeRelationships includeRelationships, boolean includePathSegments, boolean includeObjectInfo, String propertyFilter, String renditionFilter) throws ObjectNotFoundException, FilterNotValidException {
        this.checkConnection();
        if (depth != -1 && depth < 1) {
            throw new InvalidArgumentException("Invalid depth parameter. Must be 1 or greater then 1 or -1 but " + depth + " specified.");
        }
        return this.getObjectTree(folderId, depth, BaseType.FOLDER, includeAllowableActions, includeRelationships, includePathSegments, includeObjectInfo, propertyFilter, renditionFilter);
    }

    public CmisObject getObject(String objectId, boolean includeAllowableActions, IncludeRelationships includeRelationships, boolean includePolicyIDs, boolean includeAcl, boolean includeObjectInfo, String propertyFilter, String renditionFilter) throws ObjectNotFoundException, FilterNotValidException {
        this.checkConnection();
        PropertyFilter parsedPropertyFilter = new PropertyFilter(propertyFilter);
        RenditionFilter parsedRenditionFilter = new RenditionFilter(renditionFilter);
        if (includeRelationships == null) {
            includeRelationships = IncludeRelationships.NONE;
        }
        ObjectData objectData = this.storage.getObjectById(objectId);
        CmisObject cmisObject = this.getCmisObject(objectData, includeAllowableActions, includeRelationships, includePolicyIDs, includeAcl, includeObjectInfo, parsedPropertyFilter, parsedRenditionFilter);
        return cmisObject;
    }

    public CmisObject getObjectByPath(String path, boolean includeAllowableActions, IncludeRelationships includeRelationships, boolean includePolicyIDs, boolean includeAcl, boolean includeObjectInfo, String propertyFilter, String renditionFilter) throws ObjectNotFoundException, FilterNotValidException {
        this.checkConnection();
        PropertyFilter parsedPropertyFilter = new PropertyFilter(propertyFilter);
        RenditionFilter parsedRenditionFilter = new RenditionFilter(renditionFilter);
        if (includeRelationships == null) {
            includeRelationships = IncludeRelationships.NONE;
        }
        ObjectData object = this.storage.getObjectByPath(path);
        CmisObject cmis = this.getCmisObject(object, includeAllowableActions, includeRelationships, includePolicyIDs, includeAcl, includeObjectInfo, parsedPropertyFilter, parsedRenditionFilter);
        return cmis;
    }

    public CmisObject getObjectOfLatestVersion(String versionSeriesId, boolean major, boolean includeAllowableActions, IncludeRelationships includeRelationships, boolean includePolicyIDs, boolean includeAcl, boolean includeObjectInfo, String propertyFilter, String renditionFilter) throws ObjectNotFoundException, FilterNotValidException {
        this.checkConnection();
        Collection<DocumentData> versions = this.storage.getAllVersions(versionSeriesId);
        PropertyFilter parsedPropertyFilter = new PropertyFilter(propertyFilter);
        RenditionFilter parsedRenditionFilter = new RenditionFilter(renditionFilter);
        if (includeRelationships == null) {
            includeRelationships = IncludeRelationships.NONE;
        }
        if (versions.size() == 1) {
            return this.getCmisObject(versions.iterator().next(), includeAllowableActions, includeRelationships, includePolicyIDs, includeAcl, includeObjectInfo, parsedPropertyFilter, parsedRenditionFilter);
        }
        ArrayList<DocumentData> v = new ArrayList<DocumentData>(versions);
        Collections.sort(v, CmisUtils.versionComparator);
        if (!major) {
            return this.getCmisObject((ObjectData)v.get(0), includeAllowableActions, includeRelationships, includePolicyIDs, includeAcl, includeObjectInfo, parsedPropertyFilter, parsedRenditionFilter);
        }
        for (DocumentData document : v) {
            if (!document.isMajorVersion()) continue;
            return this.getCmisObject(document, includeAllowableActions, includeRelationships, includePolicyIDs, includeAcl, includeObjectInfo, parsedPropertyFilter, parsedRenditionFilter);
        }
        throw new ObjectNotFoundException("Not found any major versions in version series.");
    }

    public List<ObjectParent> getObjectParents(String objectId, boolean includeAllowableActions, IncludeRelationships includeRelationships, boolean includeRelativePathSegment, boolean includeObjectInfo, String propertyFilter, String renditionFilter) throws ObjectNotFoundException, ConstraintException, FilterNotValidException {
        this.checkConnection();
        ObjectData object = this.storage.getObjectById(objectId);
        TypeDefinition typeDefinition = object.getTypeDefinition();
        if (!typeDefinition.isFileable()) {
            throw new ConstraintException("Can't get parents. Object " + objectId + " has type " + object.getTypeId() + " that is not fileable");
        }
        Collection<FolderData> parents = object.getParents();
        PropertyFilter parsedPropertyFilter = new PropertyFilter(propertyFilter);
        RenditionFilter parsedRenditionFilter = new RenditionFilter(renditionFilter);
        if (includeRelationships == null) {
            includeRelationships = IncludeRelationships.NONE;
        }
        ArrayList<ObjectParent> cmisParents = new ArrayList<ObjectParent>(parents.size());
        for (FolderData parent : parents) {
            CmisObject cmisParent = this.getCmisObject(parent, includeAllowableActions, includeRelationships, false, false, includeObjectInfo, parsedPropertyFilter, parsedRenditionFilter);
            ObjectParent parentType = new ObjectParent(cmisParent, includeRelativePathSegment ? object.getName() : null);
            cmisParents.add(parentType);
        }
        return cmisParents;
    }

    public ItemsList<CmisObject> getObjectRelationships(String objectId, RelationshipDirection direction, String typeId, boolean includeSubRelationshipTypes, boolean includeAllowableActions, boolean includeObjectInfo, String propertyFilter, int maxItems, int skipCount) throws FilterNotValidException, ObjectNotFoundException, TypeNotFoundException {
        TypeDefinition type;
        this.checkConnection();
        if (skipCount < 0) {
            throw new InvalidArgumentException("skipCount parameter is negative.");
        }
        if (direction == null) {
            direction = RelationshipDirection.SOURCE;
        }
        if ((type = this.getTypeDefinition(typeId == null ? BaseType.RELATIONSHIP.value() : typeId)).getBaseId() != BaseType.RELATIONSHIP) {
            throw new InvalidArgumentException("Type " + typeId + " is not Relationship type.");
        }
        ObjectData object = this.storage.getObjectById(objectId);
        ItemsIterator<RelationshipData> iterator = object.getRelationships(direction, type, includeSubRelationshipTypes);
        try {
            if (skipCount > 0) {
                iterator.skip(skipCount);
            }
        }
        catch (NoSuchElementException nse) {
            throw new InvalidArgumentException("skipCount parameter is greater then total number of items");
        }
        PropertyFilter parsedPropertyFilter = new PropertyFilter(propertyFilter);
        ItemsList<CmisObject> relationships = new ItemsList<CmisObject>();
        for (int count = 0; iterator.hasNext() && (maxItems < 0 || count < maxItems); ++count) {
            ObjectData rel = (ObjectData)iterator.next();
            CmisObject cmis = this.getCmisObject(rel, includeAllowableActions, null, false, false, includeObjectInfo, parsedPropertyFilter, RenditionFilter.NONE_FILTER);
            relationships.getItems().add(cmis);
        }
        relationships.setHasMoreItems(iterator.hasNext());
        relationships.setNumItems(iterator.size());
        return relationships;
    }

    public CmisObject getProperties(String objectId, boolean includeObjectInfo, String propertyFilter) throws ObjectNotFoundException, FilterNotValidException {
        this.checkConnection();
        ObjectData object = this.storage.getObjectById(objectId);
        PropertyFilter parsedPropertyFilter = new PropertyFilter(propertyFilter);
        CmisObject cmis = this.getCmisObject(object, false, IncludeRelationships.NONE, false, false, includeObjectInfo, parsedPropertyFilter, RenditionFilter.NONE_FILTER);
        return cmis;
    }

    public CmisObject getPropertiesOfLatestVersion(String versionSeriesId, boolean major, boolean includeObjectInfo, String propertyFilter) throws FilterNotValidException, ObjectNotFoundException {
        return this.getObjectOfLatestVersion(versionSeriesId, major, false, null, false, false, includeObjectInfo, propertyFilter, "cmis:none");
    }

    public List<Rendition> getRenditions(String objectId, String renditionFilter, int maxItems, int skipCount) throws ObjectNotFoundException, FilterNotValidException {
        this.checkConnection();
        if (skipCount < 0) {
            throw new InvalidArgumentException("skipCount parameter is negative.");
        }
        if (this.storage.getRepositoryInfo().getCapabilities().getCapabilityRenditions() == CapabilityRendition.NONE) {
            throw new NotSupportedException("Renditions is not supported.");
        }
        ObjectData objectData = this.storage.getObjectById(objectId);
        ItemsIterator<Rendition> iterator = this.storage.getRenditions(objectData);
        try {
            if (skipCount > 0) {
                iterator.skip(skipCount);
            }
        }
        catch (NoSuchElementException nse) {
            throw new InvalidArgumentException("skipCount parameter is greater then total number of items");
        }
        ArrayList<Rendition> renditions = new ArrayList<Rendition>();
        RenditionFilter parsedRenditionFilter = new RenditionFilter(renditionFilter);
        for (int count = 0; iterator.hasNext() && (maxItems < 0 || count < maxItems); ++count) {
            Rendition r = (Rendition)iterator.next();
            if (!parsedRenditionFilter.accept(r)) continue;
            renditions.add(r);
        }
        return renditions;
    }

    public Storage getStorage() {
        return this.storage;
    }

    public ItemsList<TypeDefinition> getTypeChildren(String typeId, boolean includePropertyDefinition, int maxItems, int skipCount) throws TypeNotFoundException {
        this.checkConnection();
        if (skipCount < 0) {
            throw new InvalidArgumentException("skipCount parameter is negative.");
        }
        ItemsIterator<TypeDefinition> iterator = this.storage.getTypeChildren(typeId, includePropertyDefinition);
        try {
            if (skipCount > 0) {
                iterator.skip(skipCount);
            }
        }
        catch (NoSuchElementException nse) {
            throw new InvalidArgumentException("skipCount parameter is greater then total number of items");
        }
        ItemsList<TypeDefinition> typeChildren = new ItemsList<TypeDefinition>();
        for (int count = 0; iterator.hasNext() && (maxItems < 0 || count < maxItems); ++count) {
            TypeDefinition type = (TypeDefinition)iterator.next();
            typeChildren.getItems().add(type);
        }
        typeChildren.setHasMoreItems(iterator.hasNext());
        typeChildren.setNumItems(iterator.size());
        return typeChildren;
    }

    public TypeDefinition getTypeDefinition(String typeId) throws TypeNotFoundException {
        return this.getTypeDefinition(typeId, true);
    }

    public TypeDefinition getTypeDefinition(String typeId, boolean includePropertyDefinition) throws TypeNotFoundException {
        this.checkConnection();
        return this.storage.getTypeDefinition(typeId, includePropertyDefinition);
    }

    public List<ItemsTree<TypeDefinition>> getTypeDescendants(String typeId, int depth, boolean includePropertyDefinition) throws TypeNotFoundException {
        this.checkConnection();
        if (depth != -1 && depth < 1) {
            throw new InvalidArgumentException("Invalid depth parameter. Must be 1 or greater then 1 or -1 but " + depth + " specified.");
        }
        return this.getTypeTree(typeId, depth, includePropertyDefinition);
    }

    public String moveObject(String objectId, String targetFolderId, String sourceFolderId) throws ObjectNotFoundException, NameConstraintViolationException, ConstraintException, UpdateConflictException, VersioningException, StorageException {
        this.checkConnection();
        ObjectData object = this.storage.getObjectById(objectId);
        ObjectData target = this.storage.getObjectById(targetFolderId);
        if (target.getBaseType() != BaseType.FOLDER) {
            throw new InvalidArgumentException("Object " + targetFolderId + " is not a Folder object.");
        }
        if (!((FolderData)target).isAllowedChildType(object.getTypeId())) {
            throw new ConstraintException("Object with type " + object.getTypeId() + " is not allowed as child object fro target folder.");
        }
        if (sourceFolderId == null) {
            throw new InvalidArgumentException("sourceFolderId parameter may not be null");
        }
        boolean found = false;
        for (FolderData one : object.getParents()) {
            if (!one.getObjectId().equals(sourceFolderId)) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new InvalidArgumentException("Specified source folder " + sourceFolderId + " is not a parent of " + objectId);
        }
        ObjectData source = this.storage.getObjectById(sourceFolderId);
        if (source.getBaseType() != BaseType.FOLDER) {
            throw new InvalidArgumentException("Object " + sourceFolderId + " is not a Folder object.");
        }
        ObjectData movedObject = this.storage.moveObject(object, (FolderData)target, (FolderData)source);
        return movedObject.getObjectId();
    }

    public ItemsList<CmisObject> query(String statement, boolean searchAllVersions, boolean includeAllowableActions, IncludeRelationships includeRelationships, boolean includeObjectInfo, String renditionFilter, int maxItems, int skipCount) throws FilterNotValidException {
        this.checkConnection();
        if (skipCount < 0) {
            throw new InvalidArgumentException("skipCount parameter is negative.");
        }
        ItemsIterator<Result> iterator = this.storage.query(new Query(statement, searchAllVersions));
        try {
            if (skipCount > 0) {
                iterator.skip(skipCount);
            }
        }
        catch (NoSuchElementException nse) {
            throw new InvalidArgumentException("skipCount parameter is greater then total number of items");
        }
        if (includeRelationships == null) {
            includeRelationships = IncludeRelationships.NONE;
        }
        RenditionFilter parsedRenditionFilter = new RenditionFilter(renditionFilter);
        ItemsList<CmisObject> list = new ItemsList<CmisObject>();
        for (int count = 0; iterator.hasNext() && (maxItems < 0 || count < maxItems); ++count) {
            Result result = (Result)iterator.next();
            StringBuilder propertyFilter = new StringBuilder();
            if (result.getPropertyNames() != null) {
                for (String s : result.getPropertyNames()) {
                    if (propertyFilter.length() > 0) {
                        propertyFilter.append(',');
                    }
                    propertyFilter.append(s);
                }
            }
            ObjectData data = null;
            try {
                data = this.storage.getObjectById(result.getObjectId());
            }
            catch (ObjectNotFoundException e) {
                LOG.warn("Object " + result.getObjectId() + " was removed.");
                continue;
            }
            CmisObject object = this.getCmisObject(data, includeAllowableActions, includeRelationships, false, false, includeObjectInfo, new PropertyFilter(propertyFilter.toString()), parsedRenditionFilter);
            Score score = result.getScore();
            if (score != null) {
                String scoreColumnName = score.getScoreColumnName();
                DecimalProperty scoreProperty = new DecimalProperty(scoreColumnName, scoreColumnName, scoreColumnName, scoreColumnName, score.getScoreValue());
                object.getProperties().put(scoreColumnName, scoreProperty);
            }
            list.getItems().add(object);
        }
        list.setHasMoreItems(iterator.hasNext());
        list.setNumItems(iterator.size());
        return list;
    }

    public void removeObjectFromFolder(String objectId, String folderId) throws ObjectNotFoundException {
        this.checkConnection();
        ObjectData object = this.storage.getObjectById(objectId);
        Collection<FolderData> parents = object.getParents();
        if (!(folderId != null && parents.size() != 1 || this.storage.getRepositoryInfo().getCapabilities().isCapabilityUnfiling())) {
            throw new NotSupportedException("Unfiling is not supported.");
        }
        if (!object.getTypeDefinition().isFileable() || object.getBaseType() == BaseType.FOLDER) {
            throw new InvalidArgumentException("Object " + objectId + " is not fileable or folder. Can't be unfiled.");
        }
        if (folderId != null) {
            ObjectData folder = this.storage.getObjectById(folderId);
            if (folder.getBaseType() != BaseType.FOLDER) {
                throw new InvalidArgumentException("Object " + folderId + " is not a Folder object.");
            }
            ((FolderData)folder).removeObject(object);
        } else {
            this.storage.unfileObject(object);
        }
    }

    public void removePolicy(String policyId, String objectId) throws ConstraintException, ObjectNotFoundException {
        this.checkConnection();
        ObjectData object = this.storage.getObjectById(objectId);
        if (!object.getTypeDefinition().isControllablePolicy()) {
            throw new ConstraintException("Object is not controllable by policy.");
        }
        ObjectData policyData = this.storage.getObjectById(policyId);
        if (policyData.getBaseType() != BaseType.POLICY) {
            throw new InvalidArgumentException("Object " + policyId + " is not a Policy object.");
        }
        object.removePolicy((PolicyData)policyData);
    }

    public void removeType(String typeId) throws TypeNotFoundException, ConstraintException, StorageException {
        this.checkConnection();
        this.storage.removeType(typeId);
    }

    public String setContentStream(String documentId, ContentStream content, ChangeTokenHolder changeTokenHolder, Boolean overwriteFlag) throws ObjectNotFoundException, ContentAlreadyExistsException, ConstraintException, StreamNotSupportedException, UpdateConflictException, VersioningException, StorageException {
        this.checkConnection();
        if (changeTokenHolder == null) {
            throw new NullPointerException("changeTokenHolder may not by null.");
        }
        ObjectData document = this.storage.getObjectById(documentId);
        if (document.getBaseType() != BaseType.DOCUMENT) {
            throw new InvalidArgumentException("Object " + documentId + " is not Document.");
        }
        this.checkContent(document.getTypeDefinition(), content);
        if (overwriteFlag == null) {
            overwriteFlag = true;
        }
        if (!overwriteFlag.booleanValue() && ((DocumentData)document).hasContent()) {
            throw new ContentAlreadyExistsException("Document already has content stream and 'overwriteFlag' is false.");
        }
        this.validateChangeToken(document, (String)changeTokenHolder.getValue());
        try {
            ((DocumentData)document).setContentStream(content);
        }
        catch (IOException ioe) {
            throw new CmisRuntimeException("Unable set document content stream. " + ioe.getMessage(), ioe);
        }
        String changeToken = document.getChangeToken();
        changeTokenHolder.setValue(changeToken);
        return document.getObjectId();
    }

    public String updateProperties(String objectId, ChangeTokenHolder changeTokenHolder, Map<String, Property<?>> properties) throws ObjectNotFoundException, ConstraintException, NameConstraintViolationException, UpdateConflictException, VersioningException, StorageException {
        this.checkConnection();
        if (properties == null) {
            throw new InvalidArgumentException("Properties may not by null.");
        }
        if (changeTokenHolder == null) {
            throw new NullPointerException("changeTokenHolder may not by null.");
        }
        ObjectData object = this.storage.getObjectById(objectId);
        this.validateChangeToken(object, (String)changeTokenHolder.getValue());
        this.checkProperties(object.getTypeDefinition(), properties, 2);
        object.setProperties(properties);
        String changeToken = object.getChangeToken();
        changeTokenHolder.setValue(changeToken);
        return object.getObjectId();
    }

    private List<ItemsTree<CmisObject>> getObjectTree(String folderId, int depth, BaseType typeFilter, boolean includeAllowableActions, IncludeRelationships includeRelationships, boolean includePathSegments, boolean includeObjectInfo, String propertyFilter, String renditionFilter) throws ObjectNotFoundException, InvalidArgumentException, FilterNotValidException {
        ObjectData folder = this.storage.getObjectById(folderId);
        if (folder.getBaseType() != BaseType.FOLDER) {
            throw new InvalidArgumentException("Can't get children. Object " + folderId + " is not a Folder.");
        }
        ArrayList<ItemsTree<CmisObject>> tree = new ArrayList<ItemsTree<CmisObject>>();
        PropertyFilter parsedPropertyFilter = new PropertyFilter(propertyFilter);
        RenditionFilter parsedRenditionFilter = new RenditionFilter(renditionFilter);
        ItemsIterator<ObjectData> children = ((FolderData)folder).getChildren(null);
        while (children.hasNext()) {
            ObjectData childData = (ObjectData)children.next();
            if (typeFilter != null && childData.getBaseType() != typeFilter) continue;
            CmisObject container = this.getCmisObject(childData, includeAllowableActions, includeRelationships, false, false, includeObjectInfo, parsedPropertyFilter, parsedRenditionFilter);
            if (includePathSegments) {
                container.setPathSegment(childData.getName());
            }
            List<ItemsTree<CmisObject>> subTree = childData.getBaseType() == BaseType.FOLDER && (depth > 1 || depth == -1) ? this.getObjectTree(childData.getObjectId(), depth != -1 ? depth - 1 : depth, typeFilter, includeAllowableActions, includeRelationships, includePathSegments, includeObjectInfo, propertyFilter, renditionFilter) : null;
            tree.add(new ItemsTree<CmisObject>(container, subTree));
        }
        return tree;
    }

    private List<ItemsTree<TypeDefinition>> getTypeTree(String typeId, int depth, boolean includePropertyDefinition) throws TypeNotFoundException {
        ArrayList<ItemsTree<TypeDefinition>> tree = new ArrayList<ItemsTree<TypeDefinition>>();
        ItemsIterator<TypeDefinition> children = this.storage.getTypeChildren(typeId, includePropertyDefinition);
        while (children.hasNext()) {
            TypeDefinition childType = (TypeDefinition)children.next();
            List subTree = depth > 1 || depth == -1 ? this.getTypeDescendants(childType.getId(), depth != -1 ? depth - 1 : depth, includePropertyDefinition) : null;
            tree.add(new ItemsTree<TypeDefinition>(childType, subTree));
        }
        return tree;
    }

    protected abstract void checkConnection() throws IllegalStateException;

    protected CmisObject getCmisObject(ObjectData object, boolean includeAllowableActions, IncludeRelationships includeRelationships, boolean includePolicyIds, boolean includeACL, boolean includeObjectInfo, PropertyFilter parsedPropertyFilter, RenditionFilter parsedRenditionFilter) {
        Iterator<Object> iter;
        CmisObject cmis = new CmisObject();
        Map<String, Property<?>> properties = object.getProperties(parsedPropertyFilter);
        if (properties.size() != 0) {
            cmis.getProperties().putAll(properties);
        }
        if (includeAllowableActions) {
            cmis.setAllowableActions(this.storage.calculateAllowableActions(object));
        }
        RelationshipDirection direction = null;
        if (includeRelationships != null) {
            switch (includeRelationships) {
                case BOTH: {
                    direction = RelationshipDirection.EITHER;
                    break;
                }
                case SOURCE: {
                    direction = RelationshipDirection.SOURCE;
                    break;
                }
                case TARGET: {
                    direction = RelationshipDirection.TARGET;
                    break;
                }
            }
            if (direction != null) {
                TypeDefinition relBaseType = null;
                try {
                    relBaseType = this.getTypeDefinition(BaseType.RELATIONSHIP.value());
                }
                catch (TypeNotFoundException e) {
                    // empty catch block
                }
                if (relBaseType != null) {
                    ItemsIterator<RelationshipData> iter2 = object.getRelationships(direction, relBaseType, true);
                    while (iter2.hasNext()) {
                        RelationshipData next = (RelationshipData)iter2.next();
                        cmis.getRelationship().add(this.getCmisObject(next, false, includeRelationships, false, false, includeObjectInfo, PropertyFilter.ALL_FILTER, RenditionFilter.NONE_FILTER));
                    }
                }
            }
        }
        if (includePolicyIds) {
            iter = object.getPolicies().iterator();
            while (iter.hasNext()) {
                cmis.getPolicyIds().add(((PolicyData)iter.next()).getObjectId());
            }
        }
        if (includeACL) {
            iter = object.getACL(true).iterator();
            while (iter.hasNext()) {
                cmis.getACL().add((AccessControlEntry)iter.next());
            }
        }
        if (!parsedRenditionFilter.isNone()) {
            ItemsIterator<Rendition> renditions = this.storage.getRenditions(object);
            while (renditions.hasNext()) {
                Rendition r = (Rendition)renditions.next();
                if (!parsedRenditionFilter.accept(r)) continue;
                cmis.getRenditions().add(r);
            }
        }
        if (includeObjectInfo) {
            BaseType baseType = object.getBaseType();
            ObjectInfo objectInfo = new ObjectInfo();
            objectInfo.setBaseType(baseType);
            objectInfo.setTypeId(object.getTypeId());
            objectInfo.setId(object.getObjectId());
            objectInfo.setName(object.getName());
            objectInfo.setCreatedBy(object.getCreatedBy());
            objectInfo.setCreationDate(object.getCreationDate());
            objectInfo.setLastModifiedBy(object.getLastModifiedBy());
            objectInfo.setLastModificationDate(object.getLastModificationDate());
            objectInfo.setChangeToken(object.getChangeToken());
            if (baseType == BaseType.FOLDER) {
                try {
                    objectInfo.setParentId(((FolderData)object).isRoot() ? null : object.getParent().getObjectId());
                }
                catch (ConstraintException never) {
                    throw new CmisRuntimeException(never.getMessage());
                }
            } else if (baseType == BaseType.DOCUMENT) {
                DocumentData doc = (DocumentData)object;
                objectInfo.setLatestVersion(doc.isLatestVersion());
                objectInfo.setMajorVersion(doc.isMajorVersion());
                objectInfo.setLatestMajorVersion(doc.isLatestMajorVersion());
                objectInfo.setVersionSeriesId(doc.getVersionSeriesId());
                objectInfo.setVersionSeriesCheckedOutId(doc.getVersionSeriesCheckedOutId());
                objectInfo.setVersionSeriesCheckedOutBy(doc.getVersionSeriesCheckedOutBy());
                objectInfo.setVersionLabel(doc.getVersionLabel());
                objectInfo.setContentStreamMimeType(doc.getContentStreamMimeType());
            } else if (baseType == BaseType.RELATIONSHIP) {
                RelationshipData rel = (RelationshipData)object;
                objectInfo.setSourceId(rel.getSourceId());
                objectInfo.setTargetId(rel.getTargetId());
            }
            cmis.setObjectInfo(objectInfo);
        }
        return cmis;
    }

    private void checkContent(TypeDefinition typeDefinition, ContentStream content) throws ConstraintException, StreamNotSupportedException {
        if (typeDefinition.getBaseId() == BaseType.DOCUMENT) {
            if (typeDefinition.getContentStreamAllowed() == ContentStreamAllowed.REQUIRED && content == null) {
                throw new ConstraintException("Content stream required for object of type " + typeDefinition.getId() + ", it can't be null.");
            }
            if (typeDefinition.getContentStreamAllowed() == ContentStreamAllowed.NOT_ALLOWED && content != null) {
                throw new StreamNotSupportedException("Content stream not allowed for object of type " + typeDefinition.getId());
            }
        } else if (content != null) {
            throw new ConstraintException("Object type " + typeDefinition.getId() + " may not have content stream.");
        }
    }

    private void checkProperties(TypeDefinition typeDefinition, Map<String, Property<?>> properties, int operation) throws ConstraintException {
        for (PropertyDefinition<?> definition : typeDefinition.getPropertyDefinitions()) {
            Property<?> property = null;
            if (properties != null && properties.size() != 0) {
                property = properties.get(definition.getId());
            }
            if (definition.isRequired() && operation == 1 && (property == null || property.getValues().size() == 0)) {
                throw new ConstraintException("Required property " + definition.getId() + " can't be not set.");
            }
            if (property == null) continue;
            if (property.getType() != definition.getPropertyType()) {
                throw new ConstraintException("Property type is not match. Property id " + property.getId());
            }
            if (definition.isMultivalued() || property.getValues().size() <= 1) continue;
            throw new ConstraintException("Property " + property.getId() + " is not multi-valued.");
        }
    }

    private void checkACL(TypeDefinition typeDefinition, List<AccessControlEntry> addACL, List<AccessControlEntry> removeACL) throws ConstraintException {
        if (addACL != null && addACL.size() != 0 || removeACL != null && removeACL.size() != 0) {
            CapabilityACL capabilityACL = this.storage.getRepositoryInfo().getCapabilities().getCapabilityACL();
            if (capabilityACL != CapabilityACL.MANAGE) {
                throw new NotSupportedException("Managing of ACL is not supported.");
            }
            if (!typeDefinition.isControllableACL()) {
                throw new ConstraintException("Type " + typeDefinition.getId() + " is not controllable by ACL.");
            }
            List<Permission> permissions = this.storage.getRepositoryInfo().getAclCapability().getPermissions();
            HashSet<String> supportedPermissions = new HashSet<String>();
            if (permissions == null || permissions.size() == 0) {
                for (Permission perm : permissions) {
                    supportedPermissions.add(perm.getPermission());
                }
            }
            this.validatePermissions(supportedPermissions, addACL);
            this.validatePermissions(supportedPermissions, removeACL);
        }
    }

    private void validatePermissions(Set<String> supportedPermissions, List<AccessControlEntry> acl) throws ConstraintException {
        if (acl != null) {
            for (AccessControlEntry ace : acl) {
                for (String perm : ace.getPermissions()) {
                    if (supportedPermissions.contains(perm)) continue;
                    try {
                        Permission.BasicPermissions.fromValue(perm);
                    }
                    catch (IllegalArgumentException iae) {
                        throw new ConstraintException("Unsupported permissions " + perm);
                    }
                }
            }
        }
    }

    private void checkPolicies(TypeDefinition typeDefinition, Collection<String> policies) throws ConstraintException {
        if (policies != null && policies.size() != 0 && !typeDefinition.isControllablePolicy()) {
            throw new ConstraintException("Type " + typeDefinition.getId() + " is not controllable by Policy.");
        }
    }

    private Collection<PolicyData> createPolicyList(Collection<String> policyIds) throws ObjectNotFoundException {
        if (policyIds == null) {
            return null;
        }
        HashSet<PolicyData> policies = new HashSet<PolicyData>();
        for (String policyID : policyIds) {
            ObjectData policy = this.storage.getObjectById(policyID);
            if (policy.getBaseType() != BaseType.POLICY) {
                throw new InvalidArgumentException("Object " + policyID + " is not a Policy object.");
            }
            policies.add((PolicyData)policy);
        }
        return policies;
    }

    protected abstract void validateChangeToken(ObjectData var1, String var2) throws UpdateConflictException;
}

