/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.spi.model;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.xcmis.spi.model.BaseType;
import org.xcmis.spi.model.ContentStreamAllowed;
import org.xcmis.spi.model.PropertyDefinition;

public class TypeDefinition {
    private String id;
    private BaseType baseId;
    private String queryName;
    private String localName;
    private String localNamespace;
    private String parentId;
    private String displayName;
    private String description;
    private boolean creatable;
    private boolean fileable;
    private boolean queryable;
    private boolean fulltextIndexed;
    private boolean includedInSupertypeQuery;
    private boolean controllablePolicy;
    private boolean controllableACL;
    private boolean versionable;
    private String[] allowedSourceTypes;
    private String[] allowedTargetTypes;
    private ContentStreamAllowed contentStreamAllowed;
    private Map<String, PropertyDefinition<?>> propertyDefinitions;

    public TypeDefinition() {
    }

    public TypeDefinition(String id, BaseType baseId, String queryName, String localName, String localNamespace, String parentId, String displayName, String description, boolean creatable, boolean fileable, boolean queryable, boolean fulltextIndexed, boolean includedInSupertypeQuery, boolean controllablePolicy, boolean controllableACL, boolean versionable, String[] allowedSourceTypes, String[] allowedTargetTypes, ContentStreamAllowed contentStreamAllowed, Map<String, PropertyDefinition<?>> propertyDefinitions) {
        this.id = id;
        this.baseId = baseId;
        this.queryName = queryName;
        this.localName = localName;
        this.localNamespace = localNamespace;
        this.parentId = parentId;
        this.displayName = displayName;
        this.description = description;
        this.creatable = creatable;
        this.fileable = fileable;
        this.queryable = queryable;
        this.fulltextIndexed = fulltextIndexed;
        this.includedInSupertypeQuery = includedInSupertypeQuery;
        this.controllablePolicy = controllablePolicy;
        this.controllableACL = controllableACL;
        this.versionable = versionable;
        this.allowedSourceTypes = allowedSourceTypes;
        this.allowedTargetTypes = allowedTargetTypes;
        this.contentStreamAllowed = contentStreamAllowed;
        this.propertyDefinitions = propertyDefinitions;
    }

    public String getId() {
        return this.id;
    }

    public BaseType getBaseId() {
        return this.baseId;
    }

    public String getQueryName() {
        return this.queryName;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getLocalNamespace() {
        return this.localNamespace;
    }

    public String getParentId() {
        return this.parentId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isCreatable() {
        return this.creatable;
    }

    public boolean isFileable() {
        return this.fileable;
    }

    public boolean isQueryable() {
        return this.queryable;
    }

    public boolean isFulltextIndexed() {
        return this.fulltextIndexed;
    }

    public boolean isIncludedInSupertypeQuery() {
        return this.includedInSupertypeQuery;
    }

    public boolean isControllablePolicy() {
        return this.controllablePolicy;
    }

    public boolean isControllableACL() {
        return this.controllableACL;
    }

    public ContentStreamAllowed getContentStreamAllowed() {
        return this.contentStreamAllowed;
    }

    public String[] getAllowedSourceTypes() {
        return this.allowedSourceTypes;
    }

    public String[] getAllowedTargetTypes() {
        return this.allowedTargetTypes;
    }

    public boolean isVersionable() {
        return this.versionable;
    }

    public Collection<PropertyDefinition<?>> getPropertyDefinitions() {
        if (this.propertyDefinitions != null) {
            return Collections.unmodifiableCollection(this.propertyDefinitions.values());
        }
        return null;
    }

    public PropertyDefinition<?> getPropertyDefinitionByQueryName(String queryName) {
        if (this.propertyDefinitions != null) {
            for (PropertyDefinition<?> propertyDefinition : this.propertyDefinitions.values()) {
                if (!queryName.equals(propertyDefinition.getQueryName())) continue;
                return propertyDefinition;
            }
        }
        return null;
    }

    public PropertyDefinition<?> getPropertyDefinition(String id) {
        if (this.propertyDefinitions != null) {
            return this.propertyDefinitions.get(id);
        }
        return null;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setBaseId(BaseType baseId) {
        this.baseId = baseId;
    }

    public void setQueryName(String queryName) {
        this.queryName = queryName;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public void setLocalNamespace(String localNamespace) {
        this.localNamespace = localNamespace;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setCreatable(boolean creatable) {
        this.creatable = creatable;
    }

    public void setFileable(boolean fileable) {
        this.fileable = fileable;
    }

    public void setQueryable(boolean queryable) {
        this.queryable = queryable;
    }

    public void setFulltextIndexed(boolean fulltextIndexed) {
        this.fulltextIndexed = fulltextIndexed;
    }

    public void setIncludedInSupertypeQuery(boolean includedInSupertypeQuery) {
        this.includedInSupertypeQuery = includedInSupertypeQuery;
    }

    public void setControllablePolicy(boolean controllablePolicy) {
        this.controllablePolicy = controllablePolicy;
    }

    public void setControllableACL(boolean controllableACL) {
        this.controllableACL = controllableACL;
    }

    public void setVersionable(boolean versionable) {
        this.versionable = versionable;
    }

    public void setAllowedSourceTypes(String[] allowedSourceTypes) {
        this.allowedSourceTypes = allowedSourceTypes;
    }

    public void setAllowedTargetTypes(String[] allowedTargetTypes) {
        this.allowedTargetTypes = allowedTargetTypes;
    }

    public void setContentStreamAllowed(ContentStreamAllowed contentStreamAllowed) {
        this.contentStreamAllowed = contentStreamAllowed;
    }

    public void setPropertyDefinitions(Map<String, PropertyDefinition<?>> propertyDefinitions) {
        this.propertyDefinitions = new HashMap(propertyDefinitions);
    }
}

