/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.search.lucene.index;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.xcmis.search.lucene.index.ConcurrentDirectoryFactory;
import org.xcmis.search.lucene.index.TransactionLogException;

public class ReadWriteDirectoryFactory
implements ConcurrentDirectoryFactory {
    private final ConcurrentHashMap<String, ReentrantReadWriteLock> locks = new ConcurrentHashMap();

    @Override
    public File createFile(File dir, String fileName, int dirCount) throws IOException, TransactionLogException {
        File file = new File(dir, fileName);
        if (file.exists()) {
            throw new TransactionLogException("File already exist " + file.getAbsolutePath());
        }
        File[] dirs = new File[dirCount];
        File d = dir;
        for (int i = 0; i < dirCount; ++i) {
            if (d == null) {
                throw new NullPointerException("Parent directory is null.");
            }
            dirs[dirCount - 1 - i] = d;
            d = d.getParentFile();
        }
        if (!d.exists()) {
            throw new TransactionLogException(" Storage " + d.getAbsolutePath() + " not exist. ");
        }
        return this.createFile(dirs, fileName, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createFile(File[] dirs, String fileName, int currentIndex) throws IOException, TransactionLogException {
        if (currentIndex < dirs.length) {
            File fileToCreate = dirs[currentIndex];
            String dirPath = fileToCreate.getAbsolutePath();
            this.lockRead(dirPath);
            try {
                if (!fileToCreate.mkdir() && !fileToCreate.exists()) {
                    throw new RuntimeException(" Directory " + fileToCreate.getAbsolutePath() + " was not created. ");
                }
                File file = this.createFile(dirs, fileName, currentIndex + 1);
                return file;
            }
            finally {
                this.unlockRead(dirPath);
            }
        }
        File file = new File(dirs[currentIndex - 1], fileName);
        file.createNewFile();
        return file;
    }

    private ReentrantReadWriteLock getLockByPath(String dir) {
        ReentrantReadWriteLock lock;
        ReentrantReadWriteLock l = this.locks.get(dir);
        if (l == null && (l = this.locks.putIfAbsent(dir, lock = new ReentrantReadWriteLock())) == null) {
            l = lock;
        }
        return l;
    }

    public void lock(String dir) {
        ReentrantReadWriteLock.WriteLock lock = this.getLockByPath(dir).writeLock();
        lock.lock();
    }

    public void lockRead(String dir) {
        ReentrantReadWriteLock.ReadLock lock = this.getLockByPath(dir).readLock();
        lock.lock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDirectory(File dir, int dirCount) throws TransactionLogException {
        String path;
        if (dirCount > 0 && this.tryLock(path = dir.getAbsolutePath())) {
            try {
                if (dir.exists() && dir.list().length == 0) {
                    File parent = dir.getParentFile();
                    if (!dir.delete()) {
                        throw new RuntimeException("Directory was not removed " + dir.getAbsolutePath());
                    }
                    this.removeDirectory(parent, dirCount - 1);
                }
            }
            finally {
                this.unlock(path);
            }
        }
    }

    public boolean tryLock(String dir) {
        ReentrantReadWriteLock.WriteLock lock = this.getLockByPath(dir).writeLock();
        return lock.tryLock();
    }

    public void unlock(String dir) {
        ReentrantReadWriteLock.WriteLock lock = this.getLockByPath(dir).writeLock();
        lock.unlock();
    }

    public void unlockRead(String dir) {
        ReentrantReadWriteLock.ReadLock lock = this.getLockByPath(dir).readLock();
        lock.unlock();
    }
}

