/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.search;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.xcmis.search.QueryObjectModelVisitor;
import org.xcmis.search.VisitException;
import org.xcmis.search.model.Limit;
import org.xcmis.search.model.Query;
import org.xcmis.search.model.QueryElement;
import org.xcmis.search.model.column.Column;
import org.xcmis.search.model.constraint.And;
import org.xcmis.search.model.constraint.ChildNode;
import org.xcmis.search.model.constraint.Comparison;
import org.xcmis.search.model.constraint.DescendantNode;
import org.xcmis.search.model.constraint.FullTextSearch;
import org.xcmis.search.model.constraint.Not;
import org.xcmis.search.model.constraint.Or;
import org.xcmis.search.model.constraint.PropertyExistence;
import org.xcmis.search.model.constraint.SameNode;
import org.xcmis.search.model.operand.BindVariableName;
import org.xcmis.search.model.operand.FullTextSearchScore;
import org.xcmis.search.model.operand.Length;
import org.xcmis.search.model.operand.Literal;
import org.xcmis.search.model.operand.LowerCase;
import org.xcmis.search.model.operand.NodeDepth;
import org.xcmis.search.model.operand.NodeLocalName;
import org.xcmis.search.model.operand.NodeName;
import org.xcmis.search.model.operand.PropertyValue;
import org.xcmis.search.model.operand.UpperCase;
import org.xcmis.search.model.ordering.Ordering;
import org.xcmis.search.model.source.Join;
import org.xcmis.search.model.source.Selector;
import org.xcmis.search.model.source.SelectorName;
import org.xcmis.search.model.source.join.ChildNodeJoinCondition;
import org.xcmis.search.model.source.join.DescendantNodeJoinCondition;
import org.xcmis.search.model.source.join.EquiJoinCondition;
import org.xcmis.search.model.source.join.SameNodeJoinCondition;

public class Visitors {
    public static <StrategyVisitor extends QueryObjectModelVisitor> StrategyVisitor visitAll(QueryElement visitable, StrategyVisitor strategyVisitor) throws VisitException {
        if (visitable != null) {
            visitable.accept(new WalkAllVisitor(strategyVisitor));
        }
        return strategyVisitor;
    }

    public static <GeneralVisitor extends QueryObjectModelVisitor> GeneralVisitor visit(QueryElement visitable, GeneralVisitor visitor) throws VisitException {
        if (visitable != null) {
            visitable.accept(visitor);
        }
        return visitor;
    }

    public static String readable(QueryElement visitable) {
        try {
            return Visitors.visit(visitable, new ReadableVisitor()).getString();
        }
        catch (VisitException e) {
            return "";
        }
    }

    public static Set<SelectorName> getSelectorsReferencedBy(QueryElement visitable) {
        final HashSet<SelectorName> symbols = new HashSet<SelectorName>();
        try {
            Visitors.visit(visitable, new WalkAllVisitor(new AbstractModelVisitor(){

                @Override
                public void visit(ChildNode childNode) {
                    symbols.add(childNode.getSelectorName());
                }

                @Override
                public void visit(ChildNodeJoinCondition joinCondition) {
                    symbols.add(joinCondition.getChildSelectorName());
                    symbols.add(joinCondition.getParentSelectorName());
                }

                @Override
                public void visit(Column column) {
                    if (!column.isFunction()) {
                        symbols.add(column.getSelectorName());
                    }
                }

                @Override
                public void visit(DescendantNode descendant) {
                    symbols.add(descendant.getSelectorName());
                }

                @Override
                public void visit(DescendantNodeJoinCondition joinCondition) {
                    symbols.add(joinCondition.getAncestorSelectorName());
                    symbols.add(joinCondition.getDescendantSelectorName());
                }

                @Override
                public void visit(EquiJoinCondition joinCondition) {
                    symbols.add(joinCondition.getSelector1Name());
                    symbols.add(joinCondition.getSelector2Name());
                }

                @Override
                public void visit(FullTextSearch fullTextSearch) {
                    symbols.add(fullTextSearch.getSelectorName());
                }

                @Override
                public void visit(FullTextSearchScore fullTextSearchScore) {
                    symbols.add(fullTextSearchScore.getSelectorName());
                }

                @Override
                public void visit(Length length) {
                    symbols.add(length.getSelectorName());
                }

                @Override
                public void visit(NodeDepth depth) {
                    symbols.add(depth.getSelectorName());
                }

                @Override
                public void visit(NodeLocalName node) {
                    symbols.add(node.getSelectorName());
                }

                @Override
                public void visit(NodeName node) {
                    symbols.add(node.getSelectorName());
                }

                @Override
                public void visit(Selector node) {
                    if (node.hasAlias()) {
                        symbols.add(node.getAlias());
                    } else {
                        symbols.add(node.getName());
                    }
                }

                @Override
                public void visit(PropertyExistence prop) {
                    symbols.add(prop.getSelectorName());
                }

                @Override
                public void visit(PropertyValue prop) {
                    symbols.add(prop.getSelectorName());
                }

                @Override
                public void visit(SameNode node) {
                    symbols.add(node.getSelectorName());
                }

                @Override
                public void visit(SameNodeJoinCondition joinCondition) {
                    symbols.add(joinCondition.getSelector1Name());
                    symbols.add(joinCondition.getSelector2Name());
                }
            }));
        }
        catch (VisitException visitException) {
            // empty catch block
        }
        return symbols;
    }

    public static class ReadableVisitor
    implements QueryObjectModelVisitor {
        private final StringBuilder sb = new StringBuilder();

        protected final ReadableVisitor append(String string) {
            this.sb.append(string);
            return this;
        }

        protected final ReadableVisitor append(char character) {
            this.sb.append(character);
            return this;
        }

        protected final ReadableVisitor append(int value) {
            this.sb.append(value);
            return this;
        }

        protected final ReadableVisitor append(SelectorName name) {
            this.sb.append(name.getName());
            return this;
        }

        public final String getString() {
            return this.sb.toString();
        }

        public String toString() {
            return this.sb.toString();
        }

        @Override
        public void visit(And and) throws VisitException {
            this.append('(');
            and.getLeft().accept(this);
            this.append(" AND ");
            and.getRight().accept(this);
            this.append(')');
        }

        @Override
        public void visit(BindVariableName variable) {
            this.append('$').append(variable.getVariableName());
        }

        @Override
        public void visit(ChildNode child) {
            this.append("ISCHILDNODE(");
            this.append(child.getSelectorName());
            this.append(',');
            this.append(child.getParentPath());
            this.append(')');
        }

        @Override
        public void visit(ChildNodeJoinCondition condition) {
            this.append("ISCHILDNODE(");
            this.append(condition.getChildSelectorName());
            this.append(',');
            this.append(condition.getParentSelectorName());
            this.append(')');
        }

        @Override
        public void visit(Column column) {
            if (column.isFunction()) {
                this.append(column.getColumnFunction().toString());
                this.append(" AS ").append(column.getColumnName());
            } else {
                this.append(column.getSelectorName());
                if (column.getPropertyName() == null) {
                    this.append(".*");
                } else {
                    String propertyName = column.getPropertyName();
                    this.append('.').append(propertyName);
                    if (!propertyName.equals(column.getColumnName()) && !propertyName.equals(column.getColumnName())) {
                        this.append(" AS ").append(column.getColumnName());
                    }
                }
            }
        }

        @Override
        public void visit(Comparison comparison) throws VisitException {
            comparison.getOperand1().accept(this);
            this.append(' ').append(comparison.getOperator().getSymbol()).append(' ');
            comparison.getOperand2().accept(this);
        }

        @Override
        public void visit(DescendantNode descendant) {
            this.append("ISDESCENDANTNODE(");
            this.append(descendant.getSelectorName());
            this.append(',');
            this.append(descendant.getAncestorPath());
            this.append(')');
        }

        @Override
        public void visit(DescendantNodeJoinCondition condition) {
            this.append("ISDESCENDANTNODE(");
            this.append(condition.getDescendantSelectorName());
            this.append(',');
            this.append(condition.getAncestorSelectorName());
            this.append(')');
        }

        @Override
        public void visit(EquiJoinCondition condition) {
            this.append(condition.getSelector1Name()).append('.').append(condition.getProperty1Name());
            this.append(" = ");
            this.append(condition.getSelector2Name()).append('.').append(condition.getProperty2Name());
        }

        @Override
        public void visit(FullTextSearch fullText) {
            this.append("CONTAINS(").append(fullText.getSelectorName());
            if (fullText.getPropertyName() != null) {
                this.append('.').append(fullText.getPropertyName());
            }
            this.sb.append(",'").append(fullText.getFullTextSearchExpression()).append("')");
        }

        @Override
        public void visit(FullTextSearchScore score) {
            this.append("SCORE(").append(score.getSelectorName()).append(')');
        }

        @Override
        public void visit(Join join) throws VisitException {
            join.getLeft().accept(this);
            this.sb.append(' ').append(join.getType().getSymbol());
            this.append(' ');
            join.getRight().accept(this);
            this.append(" ON ");
            join.getJoinCondition().accept(this);
        }

        @Override
        public void visit(Length length) throws VisitException {
            this.append("LENGTH(");
            length.getPropertyValue().accept(this);
            this.append(')');
        }

        @Override
        public void visit(Limit limit) {
            this.append("LIMIT ").append(limit.getRowLimit());
            if (limit.getOffset() != 0) {
                this.append(" OFFSET ").append(limit.getOffset());
            }
        }

        @Override
        public void visit(Literal literal) {
            Object value = literal.getValue();
            boolean quote = value instanceof String;
            if (quote) {
                this.append('\'');
            }
            this.append(literal.getValue().toString());
            if (quote) {
                this.append('\'');
            }
        }

        @Override
        public void visit(LowerCase lowerCase) throws VisitException {
            this.append("LOWER(");
            lowerCase.getOperand().accept(this);
            this.append(')');
        }

        @Override
        public void visit(NodeDepth depth) {
            this.append("DEPTH(").append(depth.getSelectorName()).append(')');
        }

        @Override
        public void visit(NodeLocalName name) {
            this.append("LOCALNAME(").append(name.getSelectorName()).append(')');
        }

        @Override
        public void visit(NodeName name) {
            this.append("NAME(").append(name.getSelectorName()).append(')');
        }

        @Override
        public void visit(Selector selector) {
            this.append(selector.getName());
            if (selector.hasAlias()) {
                this.append(" AS ").append(selector.getAlias());
            }
        }

        @Override
        public void visit(Not not) throws VisitException {
            this.append('(');
            this.append("NOT ");
            not.getConstraint().accept(this);
            this.append(')');
        }

        @Override
        public void visit(Or or) throws VisitException {
            this.append('(');
            or.getLeft().accept(this);
            this.append(" OR ");
            or.getRight().accept(this);
            this.append(')');
        }

        @Override
        public void visit(Ordering ordering) throws VisitException {
            ordering.getOperand().accept(this);
            this.append(' ').append(ordering.getOrder().getSymbol());
        }

        @Override
        public void visit(PropertyExistence existence) {
            this.append(existence.getSelectorName()).append('.').append(existence.getPropertyName()).append(" IS NOT NULL");
        }

        @Override
        public void visit(PropertyValue value) {
            this.append(value.getSelectorName()).append('.').append(value.getPropertyName());
        }

        @Override
        public void visit(Query query) throws VisitException {
            boolean isFirst;
            this.append("SELECT ");
            if (query.getColumns().isEmpty()) {
                this.append('*');
            } else {
                isFirst = true;
                for (Column column : query.getColumns()) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        this.append(',');
                    }
                    column.accept(this);
                }
            }
            this.append(" FROM ");
            query.getSource().accept(this);
            if (query.getConstraint() != null) {
                this.append(" WHERE ");
                query.getConstraint().accept(this);
            }
            if (!query.getOrderings().isEmpty()) {
                this.append(" ORDER BY ");
                isFirst = true;
                for (Ordering ordering : query.getOrderings()) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        this.append(',');
                    }
                    ordering.accept(this);
                }
            }
            if (!query.getLimits().isUnlimited()) {
                this.append(' ');
                query.getLimits().accept(this);
            }
        }

        @Override
        public void visit(SameNode sameNode) {
            this.append("ISSAMENODE(").append(sameNode.getSelectorName()).append(',').append(sameNode.getPath()).append(')');
        }

        @Override
        public void visit(SameNodeJoinCondition condition) {
            this.append("ISSAMENODE(").append(condition.getSelector1Name()).append(',').append(condition.getSelector2Name());
            if (condition.getSelector2Path() != null) {
                this.append(',').append(condition.getSelector2Path());
            }
            this.append(')');
        }

        @Override
        public void visit(UpperCase upperCase) throws VisitException {
            this.append("UPPER(");
            upperCase.getOperand().accept(this);
            this.append(')');
        }
    }

    public static class WalkAllVisitor
    extends NavigationVisitor {
        protected WalkAllVisitor(QueryObjectModelVisitor strategy) {
            super(strategy);
        }

        @Override
        public void visit(And and) throws VisitException {
            this.strategy.visit(and);
            this.enqueue(and.getLeft());
            this.enqueue(and.getRight());
            this.visitNext();
        }

        @Override
        public void visit(BindVariableName variableName) throws VisitException {
            this.strategy.visit(variableName);
            this.visitNext();
        }

        @Override
        public void visit(ChildNode child) throws VisitException {
            this.strategy.visit(child);
            this.visitNext();
        }

        @Override
        public void visit(ChildNodeJoinCondition joinCondition) throws VisitException {
            this.strategy.visit(joinCondition);
            this.visitNext();
        }

        @Override
        public void visit(Column column) throws VisitException {
            this.strategy.visit(column);
            this.visitNext();
        }

        @Override
        public void visit(Comparison comparison) throws VisitException {
            this.strategy.visit(comparison);
            this.enqueue(comparison.getOperand1());
            this.enqueue(comparison.getOperand2());
            this.visitNext();
        }

        @Override
        public void visit(DescendantNode descendant) throws VisitException {
            this.strategy.visit(descendant);
            this.visitNext();
        }

        @Override
        public void visit(DescendantNodeJoinCondition condition) throws VisitException {
            this.strategy.visit(condition);
            this.visitNext();
        }

        @Override
        public void visit(EquiJoinCondition condition) throws VisitException {
            this.strategy.visit(condition);
            this.visitNext();
        }

        @Override
        public void visit(FullTextSearch fullTextSearch) throws VisitException {
            this.strategy.visit(fullTextSearch);
            this.visitNext();
        }

        @Override
        public void visit(FullTextSearchScore score) throws VisitException {
            this.strategy.visit(score);
            this.visitNext();
        }

        @Override
        public void visit(Join join) throws VisitException {
            this.strategy.visit(join);
            this.enqueue(join.getLeft());
            this.enqueue(join.getJoinCondition());
            this.enqueue(join.getRight());
            this.visitNext();
        }

        @Override
        public void visit(Length length) throws VisitException {
            this.strategy.visit(length);
            this.visitNext();
        }

        @Override
        public void visit(Limit limit) throws VisitException {
            this.strategy.visit(limit);
            this.visitNext();
        }

        @Override
        public void visit(Literal literal) throws VisitException {
            this.strategy.visit(literal);
            this.visitNext();
        }

        @Override
        public void visit(LowerCase lowerCase) throws VisitException {
            this.strategy.visit(lowerCase);
            this.enqueue(lowerCase.getOperand());
            this.visitNext();
        }

        @Override
        public void visit(NodeDepth depth) throws VisitException {
            this.strategy.visit(depth);
            this.visitNext();
        }

        @Override
        public void visit(NodeLocalName nodeLocalName) throws VisitException {
            this.strategy.visit(nodeLocalName);
            this.visitNext();
        }

        @Override
        public void visit(NodeName nodeName) throws VisitException {
            this.strategy.visit(nodeName);
            this.visitNext();
        }

        @Override
        public void visit(Not not) throws VisitException {
            this.strategy.visit(not);
            this.enqueue(not.getConstraint());
            this.visitNext();
        }

        @Override
        public void visit(Or or) throws VisitException {
            this.strategy.visit(or);
            this.enqueue(or.getLeft());
            this.enqueue(or.getRight());
            this.visitNext();
        }

        @Override
        public void visit(Ordering ordering) throws VisitException {
            this.strategy.visit(ordering);
            this.enqueue(ordering.getOperand());
            this.visitNext();
        }

        @Override
        public void visit(PropertyExistence existence) throws VisitException {
            this.strategy.visit(existence);
            this.visitNext();
        }

        @Override
        public void visit(PropertyValue propertyValue) throws VisitException {
            this.strategy.visit(propertyValue);
            this.visitNext();
        }

        @Override
        public void visit(Query query) throws VisitException {
            this.strategy.visit(query);
            this.enqueue(query.getSource());
            this.enqueue(query.getColumns());
            this.enqueue(query.getConstraint());
            this.enqueue(query.getOrderings());
            this.visitNext();
        }

        @Override
        public void visit(SameNode sameNode) throws VisitException {
            this.strategy.visit(sameNode);
            this.visitNext();
        }

        @Override
        public void visit(SameNodeJoinCondition condition) throws VisitException {
            this.strategy.visit(condition);
            this.visitNext();
        }

        @Override
        public void visit(UpperCase upperCase) throws VisitException {
            this.strategy.visit(upperCase);
            this.enqueue(upperCase.getOperand());
            this.visitNext();
        }

        @Override
        public void visit(Selector selector) throws VisitException {
            this.strategy.visit(selector);
            this.visitNext();
        }
    }

    public static abstract class NavigationVisitor
    implements QueryObjectModelVisitor {
        protected final QueryObjectModelVisitor strategy;
        private final LinkedList<? super QueryElement> itemQueue = new LinkedList();

        protected NavigationVisitor(QueryObjectModelVisitor strategy) {
            assert (strategy != null);
            this.strategy = strategy;
        }

        protected final void enqueue(Iterable<? extends QueryElement> objectsToBeVisited) {
            for (QueryElement queryElement : objectsToBeVisited) {
                if (queryElement == null) continue;
                this.itemQueue.add(queryElement);
            }
        }

        protected final void enqueue(QueryElement objectToBeVisited) {
            if (objectToBeVisited != null) {
                this.itemQueue.add(objectToBeVisited);
            }
        }

        protected final void visitNext() throws VisitException {
            if (!this.itemQueue.isEmpty()) {
                QueryElement first = this.itemQueue.removeFirst();
                assert (first != null);
                first.accept(this);
            }
        }
    }

    public static class AbstractModelVisitor
    implements QueryObjectModelVisitor {
        @Override
        public void visit(And node) throws VisitException {
        }

        @Override
        public void visit(BindVariableName node) throws VisitException {
        }

        @Override
        public void visit(ChildNode node) throws VisitException {
        }

        @Override
        public void visit(ChildNodeJoinCondition node) throws VisitException {
        }

        @Override
        public void visit(Column node) throws VisitException {
        }

        @Override
        public void visit(Comparison node) throws VisitException {
        }

        @Override
        public void visit(DescendantNode node) throws VisitException {
        }

        @Override
        public void visit(DescendantNodeJoinCondition node) throws VisitException {
        }

        @Override
        public void visit(EquiJoinCondition node) throws VisitException {
        }

        @Override
        public void visit(FullTextSearch node) throws VisitException {
        }

        @Override
        public void visit(FullTextSearchScore node) throws VisitException {
        }

        @Override
        public void visit(Join node) throws VisitException {
        }

        @Override
        public void visit(Length node) throws VisitException {
        }

        @Override
        public void visit(Limit limit) throws VisitException {
        }

        @Override
        public void visit(Literal node) throws VisitException {
        }

        @Override
        public void visit(LowerCase node) throws VisitException {
        }

        @Override
        public void visit(NodeDepth depth) throws VisitException {
        }

        @Override
        public void visit(NodeLocalName node) throws VisitException {
        }

        @Override
        public void visit(NodeName node) throws VisitException {
        }

        @Override
        public void visit(Not node) throws VisitException {
        }

        @Override
        public void visit(Or node) throws VisitException {
        }

        @Override
        public void visit(Ordering node) throws VisitException {
        }

        @Override
        public void visit(PropertyExistence node) throws VisitException {
        }

        @Override
        public void visit(PropertyValue node) throws VisitException {
        }

        @Override
        public void visit(Query node) throws VisitException {
        }

        @Override
        public void visit(SameNode node) throws VisitException {
        }

        @Override
        public void visit(SameNodeJoinCondition node) throws VisitException {
        }

        @Override
        public void visit(UpperCase node) throws VisitException {
        }

        @Override
        public void visit(Selector selector) {
        }
    }
}

