/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.restatom.collections;

import java.util.Calendar;
import java.util.List;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.model.Base;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.abdera.model.Link;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.context.ResponseContextException;
import org.xcmis.restatom.AtomCMIS;
import org.xcmis.restatom.AtomUtils;
import org.xcmis.restatom.collections.CmisTypeCollection;
import org.xcmis.spi.Connection;
import org.xcmis.spi.InvalidArgumentException;
import org.xcmis.spi.ItemsTree;
import org.xcmis.spi.TypeNotFoundException;
import org.xcmis.spi.model.TypeDefinition;

public class TypesDescendantsCollection
extends CmisTypeCollection {
    public TypesDescendantsCollection(Connection connection) {
        super(connection);
        this.setHref("/typedescendants");
    }

    public Iterable<TypeDefinition> getEntries(RequestContext request) throws ResponseContextException {
        throw new UnsupportedOperationException("entries");
    }

    protected void addFeedDetails(Feed feed, RequestContext request) throws ResponseContextException {
        try {
            String typeId = request.getTarget().getParameter("typeId");
            boolean includePropertyDefinitions = this.getBooleanParameter(request, "includePropertyDefinitions", false);
            int depth = this.getIntegerParameter(request, "depth", -1);
            Connection connection = this.getConnection(request);
            List descendants = connection.getTypeDescendants(typeId, depth, includePropertyDefinitions);
            String down = this.getTypeChildrenLink(typeId, request);
            feed.addLink(down, "down", "application/atom+xml;type=feed", null, null, -1L);
            if (typeId != null) {
                String typeLink = this.getObjectTypeLink(typeId, request);
                feed.addLink(typeLink, "via", "application/atom+xml;type=entry", null, null, -1L);
                TypeDefinition type = connection.getTypeDefinition(typeId);
                String parentType = type.getParentId();
                if (parentType != null) {
                    String parent = this.getObjectTypeLink(parentType, request);
                    feed.addLink(parent, "up", "application/atom+xml;type=entry", null, null, -1L);
                }
            }
            for (ItemsTree typeContainer : descendants) {
                Entry e = feed.addEntry();
                IRI feedIri = new IRI(this.getFeedIriForEntry(typeContainer.getContainer(), request));
                this.addEntryDetails(request, e, feedIri, (TypeDefinition)typeContainer.getContainer());
                if (typeContainer.getChildren() == null || typeContainer.getChildren().isEmpty()) continue;
                this.addChildren(e, typeContainer.getChildren(), feedIri, request);
            }
        }
        catch (InvalidArgumentException iae) {
            throw new ResponseContextException(this.createErrorResponse(iae, 400));
        }
        catch (TypeNotFoundException tnfe) {
            throw new ResponseContextException(this.createErrorResponse(tnfe, 404));
        }
        catch (Throwable t) {
            throw new ResponseContextException(this.createErrorResponse(t, 500));
        }
    }

    protected void addChildren(Entry entry, List<ItemsTree<TypeDefinition>> children, IRI feedIri, RequestContext request) throws ResponseContextException {
        Element childrenElement = entry.addExtension(AtomCMIS.CHILDREN);
        String entryId = entry.getId().toString();
        Feed childFeed = request.getAbdera().getFactory().newFeed((Base)childrenElement);
        childFeed.setId("ch:" + entryId);
        childFeed.setTitle("Type Children");
        childFeed.addAuthor(entry.getAuthor());
        childFeed.setUpdated(entry.getUpdated());
        List links = entry.getLinks(new String[]{"service", "self", "down", "http://docs.oasis-open.org/ns/cmis/link/200908/typedescendants", "up"});
        for (Link l : links) {
            childFeed.addLink((Link)l.clone());
        }
        childFeed.addLink(this.getObjectTypeLink(entryId, request), "via", "application/atom+xml;type=entry", null, null, -1L);
        Element numItems = request.getAbdera().getFactory().newElement(AtomCMIS.NUM_ITEMS, (Base)childrenElement);
        numItems.setText(Integer.toString(children.size()));
        for (ItemsTree<TypeDefinition> typeContainer : children) {
            Entry ch = entry.getFactory().newEntry((Base)childrenElement);
            this.addEntryDetails(request, ch, feedIri, (TypeDefinition)typeContainer.getContainer());
            if (typeContainer.getChildren() == null || typeContainer.getChildren().size() <= 0) continue;
            this.addChildren(ch, typeContainer.getChildren(), feedIri, request);
        }
    }

    @Override
    public String getTitle(RequestContext request) {
        return "Type Descendants";
    }

    protected Feed createFeedBase(RequestContext request) throws ResponseContextException {
        Factory factory = request.getAbdera().getFactory();
        Feed feed = factory.newFeed();
        feed.setId(this.getId(request));
        feed.setTitle(this.getTitle(request));
        feed.addAuthor(this.getAuthor(request));
        feed.setUpdated(AtomUtils.getAtomDate(Calendar.getInstance()));
        feed.addLink(this.getServiceLink(request), "service", "application/atomsvc+xml", null, null, -1L);
        return feed;
    }
}

