/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.spi;

import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.xcmis.spi.DelegatedTypeManager;
import org.xcmis.spi.ItemsIterator;
import org.xcmis.spi.TypeManager;
import org.xcmis.spi.TypeNotFoundException;
import org.xcmis.spi.model.TypeDefinition;

public class QueryNameTypeManager
extends DelegatedTypeManager {
    private final Map<String, String> aliases = new ConcurrentHashMap<String, String>();

    public QueryNameTypeManager(TypeManager typeManager) {
        super(typeManager);
    }

    public TypeDefinition getTypeDefinitionByQueryName(String queryName, boolean includePropertyDefinition) throws TypeNotFoundException {
        String typeId = this.aliases.get(queryName);
        if (typeId == null) {
            TypeDefinition type = this.findTypeDefinitionByQueryName(queryName, includePropertyDefinition);
            this.aliases.put(type.getQueryName(), type.getId());
            return type;
        }
        try {
            return this.getTypeDefinition(typeId, includePropertyDefinition);
        }
        catch (TypeNotFoundException e) {
            throw new TypeNotFoundException("Type with queryName '" + queryName + "' not found.");
        }
    }

    private TypeDefinition findTypeDefinitionByQueryName(String queryName, boolean includePropertyDefinition) throws TypeNotFoundException {
        LinkedList q = new LinkedList();
        ItemsIterator<TypeDefinition> i = this.getTypeChildren(null, true);
        while (i.hasNext()) {
            q.add(i.next());
        }
        while (!q.isEmpty()) {
            TypeDefinition type = (TypeDefinition)q.pop();
            if (type.getQueryName().equals(queryName)) {
                return type;
            }
            ItemsIterator<TypeDefinition> i2 = this.getTypeChildren(type.getId(), true);
            while (i2.hasNext()) {
                q.push(i2.next());
            }
        }
        throw new TypeNotFoundException("Type with queryName '" + queryName + "' not found.");
    }
}

