/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.restatom.abdera;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.ExtensibleElementWrapper;
import org.apache.abdera.parser.stax.FOMExtensibleElement;
import org.xcmis.restatom.AtomCMIS;
import org.xcmis.restatom.abdera.AccessControlEntryTypeElement;
import org.xcmis.restatom.abdera.AllowableActionsElement;
import org.xcmis.restatom.abdera.ChangeEventTypeElement;
import org.xcmis.restatom.abdera.PropertyBooleanElement;
import org.xcmis.restatom.abdera.PropertyDateTimeElement;
import org.xcmis.restatom.abdera.PropertyDecimalElement;
import org.xcmis.restatom.abdera.PropertyElement;
import org.xcmis.restatom.abdera.PropertyHtmlElement;
import org.xcmis.restatom.abdera.PropertyIdElement;
import org.xcmis.restatom.abdera.PropertyIntegerElement;
import org.xcmis.restatom.abdera.PropertyStringElement;
import org.xcmis.restatom.abdera.PropertyUriElement;
import org.xcmis.restatom.abdera.RenditionTypeElement;
import org.xcmis.spi.InvalidArgumentException;
import org.xcmis.spi.model.AccessControlEntry;
import org.xcmis.spi.model.AllowableActions;
import org.xcmis.spi.model.ChangeInfo;
import org.xcmis.spi.model.CmisObject;
import org.xcmis.spi.model.Property;
import org.xcmis.spi.model.PropertyType;
import org.xcmis.spi.model.Rendition;
import org.xcmis.spi.model.impl.BooleanProperty;
import org.xcmis.spi.model.impl.DateTimeProperty;
import org.xcmis.spi.model.impl.DecimalProperty;
import org.xcmis.spi.model.impl.HtmlProperty;
import org.xcmis.spi.model.impl.IdProperty;
import org.xcmis.spi.model.impl.IntegerProperty;
import org.xcmis.spi.model.impl.StringProperty;
import org.xcmis.spi.model.impl.UriProperty;

public class ObjectTypeElement
extends ExtensibleElementWrapper {
    public ObjectTypeElement(Element internal) {
        super(internal);
    }

    public ObjectTypeElement(Factory factory, QName qname) {
        super(factory, qname);
    }

    public AllowableActionsElement getAllowableActionsElement() {
        return (AllowableActionsElement)this.getExtension(AtomCMIS.ALLOWABLE_ACTIONS);
    }

    public CmisObject getObject() {
        CmisObject object = new CmisObject();
        FOMExtensibleElement propertiesElement = (FOMExtensibleElement)this.getExtension(AtomCMIS.PROPERTIES);
        if (propertiesElement != null) {
            Map properties = object.getProperties();
            List propertyElementList = propertiesElement.getElements();
            for (PropertyElement propertyElement : propertyElementList) {
                Object property = propertyElement.getProperty();
                properties.put(propertyElement.getProperty().getId(), property);
            }
        }
        return object;
    }

    public void build(CmisObject objectType) {
        if (objectType != null) {
            List listRendition;
            List accessControlList;
            ChangeInfo changeInfo;
            List relationship;
            AllowableActions allowableActions;
            this.setAttributeValue("xmlns:cmisra", "http://docs.oasis-open.org/ns/cmis/restatom/200908/");
            Map properties = objectType.getProperties();
            if (properties != null && !properties.isEmpty()) {
                FOMExtensibleElement propertiesElement = (FOMExtensibleElement)this.addExtension(AtomCMIS.PROPERTIES);
                Set keys = properties.keySet();
                block10: for (String key : keys) {
                    Property prop = (Property)properties.get(key);
                    PropertyType propertyType = prop.getType();
                    switch (propertyType) {
                        case BOOLEAN: {
                            PropertyElement propElement = (PropertyBooleanElement)propertiesElement.addExtension(AtomCMIS.PROPERTY_BOOLEAN);
                            ((PropertyBooleanElement)propElement).build((BooleanProperty)prop);
                            continue block10;
                        }
                        case DATETIME: {
                            PropertyElement propElement = (PropertyDateTimeElement)propertiesElement.addExtension(AtomCMIS.PROPERTY_DATE_TIME);
                            ((PropertyDateTimeElement)propElement).build((DateTimeProperty)prop);
                            continue block10;
                        }
                        case DECIMAL: {
                            PropertyElement propElement = (PropertyDecimalElement)propertiesElement.addExtension(AtomCMIS.PROPERTY_DECIMAL);
                            ((PropertyDecimalElement)propElement).build((DecimalProperty)prop);
                            continue block10;
                        }
                        case HTML: {
                            PropertyElement propElement = (PropertyHtmlElement)propertiesElement.addExtension(AtomCMIS.PROPERTY_HTML);
                            ((PropertyHtmlElement)propElement).build((HtmlProperty)prop);
                            continue block10;
                        }
                        case ID: {
                            PropertyElement propElement = (PropertyIdElement)propertiesElement.addExtension(AtomCMIS.PROPERTY_ID);
                            ((PropertyIdElement)propElement).build((IdProperty)prop);
                            continue block10;
                        }
                        case STRING: {
                            PropertyElement propElement = (PropertyStringElement)propertiesElement.addExtension(AtomCMIS.PROPERTY_STRING);
                            ((PropertyStringElement)propElement).build((StringProperty)prop);
                            continue block10;
                        }
                        case INTEGER: {
                            PropertyElement propElement = (PropertyIntegerElement)propertiesElement.addExtension(AtomCMIS.PROPERTY_INTEGER);
                            ((PropertyIntegerElement)propElement).build((IntegerProperty)prop);
                            continue block10;
                        }
                        case URI: {
                            PropertyElement propElement = (PropertyUriElement)propertiesElement.addExtension(AtomCMIS.PROPERTY_URI);
                            ((PropertyUriElement)propElement).build((UriProperty)prop);
                            continue block10;
                        }
                    }
                    throw new InvalidArgumentException("Unknown property type " + propertyType.value());
                }
            }
            if ((allowableActions = objectType.getAllowableActions()) != null) {
                AllowableActionsElement actionsElement = (AllowableActionsElement)this.addExtension(AtomCMIS.ALLOWABLE_ACTIONS);
                actionsElement.build(allowableActions);
            }
            if ((relationship = objectType.getRelationship()) != null && relationship.size() > 0) {
                ObjectTypeElement relationshipElement = (ObjectTypeElement)this.addExtension(AtomCMIS.RELATIOSNHIP);
                for (CmisObject cmisObject : relationship) {
                    relationshipElement.build(cmisObject);
                }
            }
            if ((changeInfo = objectType.getChangeInfo()) != null) {
                ChangeEventTypeElement changeEventInfoElement = (ChangeEventTypeElement)this.addExtension(AtomCMIS.CHANGE_EVENT_INFO);
                changeEventInfoElement.build(changeInfo);
            }
            if ((accessControlList = objectType.getACL()) != null) {
                FOMExtensibleElement accessControlListTypeElement = (FOMExtensibleElement)this.addExtension(AtomCMIS.ACL);
                for (AccessControlEntry element : accessControlList) {
                    AccessControlEntryTypeElement ace = (AccessControlEntryTypeElement)accessControlListTypeElement.addExtension(AtomCMIS.PERMISSION);
                    ace.build(element);
                }
            }
            this.addSimpleExtension(AtomCMIS.EXACT_ACL, Boolean.valueOf(objectType.isExactACL()).toString());
            Collection policyIds = objectType.getPolicyIds();
            if (policyIds != null) {
                FOMExtensibleElement listOfIdsTypeTypeElement = (FOMExtensibleElement)this.addExtension(AtomCMIS.POLICY_IDS);
                for (Element element : listOfIdsTypeTypeElement) {
                    listOfIdsTypeTypeElement.addSimpleExtension(AtomCMIS.ID, element.getText());
                }
            }
            if ((listRendition = objectType.getRenditions()) != null) {
                RenditionTypeElement renditionElement = (RenditionTypeElement)this.addExtension(AtomCMIS.RENDITION);
                for (Rendition rendition : listRendition) {
                    renditionElement.build(rendition);
                }
            }
        }
    }
}

