/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.search.lucene;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.xcmis.search.config.IndexConfiguration;
import org.xcmis.search.content.ContentEntry;
import org.xcmis.search.content.command.read.GetChildEntriesCommand;
import org.xcmis.search.content.command.read.GetContentEntryCommand;
import org.xcmis.search.content.command.read.GetUnfiledEntriesCommand;
import org.xcmis.search.lucene.LuceneQueryableIndexStorage;
import org.xcmis.search.lucene.index.IndexException;
import org.xcmis.search.lucene.index.IndexTransactionException;
import org.xcmis.search.lucene.index.LuceneIndexTransaction;
import org.xcmis.search.lucene.index.LuceneIndexer;
import org.xcmis.spi.utils.Logger;

public class IndexRecoveryTool {
    private static final Logger LOG = Logger.getLogger(IndexRecoveryTool.class);
    public static final int BUFFER_MAX_SIZE = 1000;
    private final LuceneIndexer nodeIndexer;
    private final LuceneQueryableIndexStorage indexStorage;
    private final IndexConfiguration indexConfiguration;

    public IndexRecoveryTool(LuceneQueryableIndexStorage indexStorage, LuceneIndexer nodeIndexer, IndexConfiguration indexConfiguration) {
        this.indexStorage = indexStorage;
        this.nodeIndexer = nodeIndexer;
        this.indexConfiguration = indexConfiguration;
    }

    public void recover(Iterator<String> uuids) throws IndexException {
        IndexReader reader = this.indexStorage.getIndexReader();
        try {
            HashMap<String, Document> addedDocuments = new HashMap<String, Document>();
            HashSet<String> removedDocuments = new HashSet<String>();
            while (uuids.hasNext()) {
                String nodeUuid = uuids.next();
                GetContentEntryCommand getCommand = new GetContentEntryCommand(nodeUuid);
                ContentEntry contentEntry = (ContentEntry)this.indexStorage.invokeNextInterceptor(null, getCommand);
                if (contentEntry == null) {
                    if (this.indexStorage.getDocument(nodeUuid, reader) != null) {
                        removedDocuments.add(nodeUuid);
                    }
                } else {
                    Document doc = this.nodeIndexer.createDocument(contentEntry);
                    if (this.indexStorage.getDocument(nodeUuid, reader) != null) {
                        addedDocuments.put(nodeUuid, doc);
                        removedDocuments.add(nodeUuid);
                    } else {
                        addedDocuments.put(nodeUuid, doc);
                    }
                }
                if (!this.checkFlush(addedDocuments, removedDocuments)) continue;
                this.flash(addedDocuments, removedDocuments);
            }
            if (addedDocuments.size() + removedDocuments.size() >= 0) {
                this.indexStorage.save(new LuceneIndexTransaction(addedDocuments, removedDocuments));
            }
        }
        catch (Throwable e) {
            throw new IndexException(e.getLocalizedMessage(), e);
        }
    }

    public void recoverAll() throws IndexException {
        HashMap<String, Document> documentBuffer = new HashMap<String, Document>();
        HashSet<String> removedDocuments = new HashSet<String>();
        try {
            GetUnfiledEntriesCommand getUnfiledEntriesCommand;
            Iterator uuids;
            GetContentEntryCommand getCommand = new GetContentEntryCommand(this.indexConfiguration.getRootUuid());
            ContentEntry rootEntry = (ContentEntry)this.indexStorage.invokeNextInterceptor(null, getCommand);
            if (rootEntry != null) {
                this.restoreBranch(rootEntry, documentBuffer, removedDocuments);
            } else {
                LOG.warn("Root element with id " + this.indexConfiguration.getRootUuid() + " not found ");
            }
            if (documentBuffer.size() > 0) {
                this.flash(documentBuffer, removedDocuments);
            }
            if ((uuids = (Iterator)this.indexStorage.invokeNextInterceptor(null, getUnfiledEntriesCommand = new GetUnfiledEntriesCommand())) != null) {
                this.recover(uuids);
            }
        }
        catch (Throwable e) {
            throw new IndexException(e.getLocalizedMessage(), e);
        }
    }

    private boolean checkFlush(Map<String, Document> documentBuffer, HashSet<String> removedDocuments) {
        return documentBuffer.size() + removedDocuments.size() >= 1000;
    }

    private void flash(Map<String, Document> documentBuffer, HashSet<String> removedDocuments) throws IndexTransactionException, IndexException {
        this.indexStorage.save(new LuceneIndexTransaction(new HashMap<String, Document>(documentBuffer), new HashSet<String>(removedDocuments)));
        documentBuffer.clear();
        removedDocuments.clear();
    }

    private void restoreBranch(ContentEntry branchRoot, Map<String, Document> documentBuffer, HashSet<String> removedDocuments) throws Throwable {
        GetChildEntriesCommand getChildCommand;
        Collection childEntries;
        documentBuffer.put(branchRoot.getIdentifier(), this.nodeIndexer.createDocument(branchRoot));
        if (this.checkFlush(documentBuffer, removedDocuments)) {
            this.flash(documentBuffer, removedDocuments);
        }
        if ((childEntries = (Collection)this.indexStorage.invokeNextInterceptor(null, getChildCommand = new GetChildEntriesCommand(branchRoot.getIdentifier()))) != null) {
            for (ContentEntry contentEntry : childEntries) {
                this.restoreBranch(contentEntry, documentBuffer, removedDocuments);
            }
        } else {
            LOG.warn("Child elements for element with id " + branchRoot.getIdentifier() + " is not found ");
        }
    }
}

