# Addon Copy Folder

## Introduction 
This addon can be used to load a physical folder tree from the machine which runs eXo to the eXo server

## Installation 
To deploy it on eXo server, you will first need to build it locally. 

To build add-on from sources use [Maven 3](http://maven.apache.org/download.html).

Clone the project with:

    git clone git@github.com:exo-addons/copy-folder.git
    cd copy-folder

Build it with

    mvn clean package

Copy the generated jar from `./services/target/copy-folder-services-1.0.x-SNAPSHOT.jar` to the lib folder of your eXo Server

## Configuration
Few properties are available to configure the addon. For changing it, add them in gatein/conf/exo.properties file of your eXo Server. Properties are mandatory to use the addon.

| Property  | Default Value | Usage                                    |
| ------------- | ------------- |------------------------------------------|
| exo.copyfolderservice.source  | No default value | Physical folder to import in eXo         | 
| exo.copyfolderservice.target  | No default value | Target folder in exo                     | 
| exo.copyfolderservice.index  | No default value | Path to index file for permissions       | 
| exo.copyfolderservice.cron.expression  | 0 0 3 * * ? | Cron job expression to launch the import | 


When this addon is launched, the content of folder `exo.copyfolderservice.source` will be copied in `exo.copyfolderservice.target` in exo.

Remark : for Windows installation, '\' must be escaped : 

    exo.copyfolderservice.source=k:\\folder\\to\\import

## Run the addon
After starting eXo, there are two entry points to launch the action :

### Mbeans
Use a tool like Visualvm with the Mbeans plugin to access to the Mbeans of eXo java process. Access to the Mbeans named `exo->portal->copy-folder->CopyFolderService`, then launch the operation `importFromDisk`

### REST Service
To launch the import action, you can access to the url `http://${eXoHostname}/portal/rest/management/copyfolderservice/importFromDisk`

### Cron Job 
The service is automatically launched each day with a cron job, at 03h00.

To modify the cron expression, use the property

    exo.copyfolderservice.cron.expression=0 0 3 * * ?

## Follow the progression
During the execution, the addon will create logs in `${EXO_HOME}/logs/platform.log` :

    022-10-18 09:07:31,385 | INFO  | Launch importFromDisk, from /home/username/foldertocopy to /targetfolder [o.e.c.services.CopyFolderService<Thread-66>] 
    2022-10-18 09:07:31,490 | INFO  | Count done in 75 ms, 5085 directories, 15576 files [o.e.c.services.CopyFolderService<Thread-66>]
    2022-10-18 09:08:12,923 | INFO  | Directories 0% (20/5085), Files 0% (80/15576). [o.e.c.services.CopyFolderService<Thread-66>]
    2022-10-18 09:08:12,923 | INFO  | Directories 0% (20/5085), Files 0% (80/15576). [o.e.c.services.  CopyFolderService<Thread-66>]
    2022-10-18 09:08:24,217 | INFO  | Directories 0% (44/5085), Files 1% (156/15576). [o.e.c.services.CopyFolderService<Thread-66>]
    2022-10-18 09:08:31,158 | INFO  | Directories 1% (53/5085), Files 1% (247/15576). [o.e.c.services.CopyFolderService<Thread-66>] 
    ...
    2022-10-18 09:27:40,856 | INFO  | Directories 99% (5042/5085), Files 99% (15458/15576). [o.e.c.services.CopyFolderService<Thread-66>] 
    2022-10-18 09:27:46,705 | INFO  | Directories 99% (5063/5085), Files 99% (15537/15576). [o.e.c.services.CopyFolderService<Thread-66>]
    2022-10-18 09:27:49,938 | INFO  | End importFromDisk, execution time = 1218553 ms. 5085/5085 directories created, 15576/15576 files created. [o.e.c.services.CopyFolderService<Thread-66>]
    2022-10-18 09:27:49,938 | INFO  | 0 directories in error : [] [o.e.c.services.CopyFolderService<Thread-66>]
    2022-10-18 09:27:49,938 | INFO  | 0 files in error : [] [o.e.c.services.CopyFolderService<Thread-66>]

The two first lines display the source and the target folder, then, the folder and files count to create in eXo. The you can the see the progression of the import. 
At the end, you will fine a summary of the execution, showing execution time, number of copied folders and files, and the list of errors.
If you re-execute the import, only non existing folders and files will be added.

## Permissions index file
During folder creation, we could add permissions on created folder. For that we use the index file configured with property exo.copyfolder.index. This file is a csv file, with this structure :

    Folder;Group;Rights
    /test1;employees;read
    /test1;executive-board;write
    /test2;rewarding;read
    /test2;web-contributors;read
    /test3/test4/test5;rewarding;write

- First column is the folder concerned. 
- Second column is the eXo group to which we want to grant permission. 
- Third column is the permission. It could be `read` or `write`. All other permission is ignored.
You can find a csv example file in the github repository.

For each folder, during the execution, we will search the associated eXo group, and then, grant him rights in function. 

For example, these lines :
    
    /test1;employees;read
    /test1;executive-board;write
will generate this permission in eXo : 
![](/home/romain/exo/eXoProjects/copy-folder/resources/permissions.png)

If more than one group is found when searching by name, the permission is ignored. If no group is found when search by name, the permission is ignored.
    
    2022-10-19 17:04:49,546 | ERROR | Group with name non-existing-group do not exists. Ignore permission. [o.e.c.services.CopyFolderService<Thread-46>]

At the end of the execution, you can find a summary of the execution which list errors about permissions :

    2022-10-19 16:29:40,984 | INFO  | End importFromDisk, execution time = 19 ms. 13/13 directories created, 0/0 files created. [o.e.c.services.CopyFolderService<Thread-46>]
    2022-10-19 16:29:40,984 | INFO  | 0 directories in error : [] [o.e.c.services.CopyFolderService<Thread-46>]
    2022-10-19 16:29:40,984 | INFO  | 0 files in error : [] [o.e.c.services.CopyFolderService<Thread-46>]
    2022-10-19 17:04:49,592 | INFO  | Permissions with error : {/test1=[[non-existing-group,WRITE]]} [o.e.c.services.CopyFolderService<Thread-46>]


## Debug
If you wish to follow the progression folder by folder and file by file, you can activate debug logs.
For that, edit the file ${EXO_HOME}/conf/logback.xml. Search the logger list, and add a new one :

      <logger name="org.exoplatform.copyfolder.services" level="DEBUG" />

This will create logs like this :

    2022-10-18 09:36:35,719 | DEBUG | Folder /targetfolder/testfolder exists. [o.e.c.services.CopyFolderService<Thread-45>]
    2022-10-18 09:36:35,788 | DEBUG | File /targetfolder/2022-10-14_15-28.png not exists. Create it in 61 ms. [o.e.c.services.CopyFolderService<Thread-45>]
    2022-10-18 09:36:35,789 | DEBUG | File /targetfolder/2022-03-30 17-50-30.mkv exists. [o.e.c.services.CopyFolderService<Thread-45>]

Logs will list all files and folder, and indicate if the item exists or if it was created.

You can also add a new appender to send CopyFolderService logs to a specific log file.

Permissions will also add debug logs. When the index file is read, a summary of it is displayed : 

    2022-10-19 17:04:49,322 | DEBUG | PermissionsIndex : {/test3=[[web-contributors,WRITE]], /test1=[[employees,READ], [executive-board,WRITE], [non-existing-group,WRITE]], /test2=[[rewarding,READ], [web-contributors,READ]], /test3/test4=[[web-contributors,READ]], /test3/test4/test5=[[web-contributors,WRITE], [rewarding,WRITE]]} [o.e.c.services.CopyFolderService<Thread-46>] 

Then, when a permission is added on a folder, a debug log is added :

    2022-10-19 17:04:49,422 | DEBUG | Permissions [[web-contributors,READ]] added on folder /test3/test4 in 2 ms [o.e.c.services.CopyFolderService<Thread-46>] 


## JCR Name compliance
To be compliant with JCR name, folders and filename are updated before being created in eXo : 
- The file/folder name is cleaned : '/', ':', '[', ']', '*', ''', '"', '|' are replaced by '_'
- All other characters except letters, digits, whitespace, '.', '-', '_' are removed
- All characters are modified to lower case

The original name is conserved in property exo:title. This property is used for display the item in the file explorer application. 


