/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.copyfolder.services;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.mimetype.DMSMimeTypeResolver;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.util.Text;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;

public class CopyFolderService {
    private static final Log LOG = ExoLogger.getLogger(CopyFolderService.class);
    private static final String SOURCE_FOLDER_PARAM = "sourceFolder";
    private static final String TARGET_FOLDER_PARAM = "targetFolder";
    private static final String INDEX_FOLDER_PARAM = "index";
    private static final String INITIAL_LINE = "Folder;Group;Rights";
    private String targetFolder;
    private String sourceFolder;
    private String indexPath;
    private Map<String, List<Permission>> permissionsIndex = new HashMap<String, List<Permission>>();
    private RepositoryService repositoryService;
    private OrganizationService organizationService;

    public CopyFolderService(InitParams initParams, RepositoryService repositoryService, OrganizationService organizationService) {
        if (initParams != null) {
            if (initParams.getValueParam(SOURCE_FOLDER_PARAM) != null) {
                this.sourceFolder = initParams.getValueParam(SOURCE_FOLDER_PARAM).getValue();
            }
            if (initParams.getValueParam(TARGET_FOLDER_PARAM) != null) {
                this.targetFolder = initParams.getValueParam(TARGET_FOLDER_PARAM).getValue();
            }
            if (initParams.getValueParam(INDEX_FOLDER_PARAM) != null) {
                this.indexPath = initParams.getValueParam(INDEX_FOLDER_PARAM).getValue();
            }
        }
        this.repositoryService = repositoryService;
        this.organizationService = organizationService;
    }

    private void readIndex(String indexPath) {
        Path file = Path.of(indexPath, new String[0]);
        if (Files.exists(file, new LinkOption[0])) {
            try (Stream<String> lines = Files.lines(file);){
                lines.forEach(line -> {
                    if (!line.equals(INITIAL_LINE) && !line.equals("")) {
                        String[] splitted = line.split(";");
                        if (splitted.length != 3) {
                            LOG.error("Line {} have not the correct column number.", new Object[]{line});
                        } else {
                            String folder = splitted[0];
                            String group = splitted[1];
                            String permission = splitted[2];
                            try {
                                Permission perm = new Permission(group, AccessRight.valueOf(permission.toUpperCase()));
                                if (this.permissionsIndex.containsKey(folder)) {
                                    this.permissionsIndex.get(folder).add(perm);
                                } else {
                                    ArrayList<Permission> perms = new ArrayList<Permission>();
                                    perms.add(perm);
                                    this.permissionsIndex.put(folder, perms);
                                }
                            }
                            catch (IllegalArgumentException e) {
                                LOG.error("Line {} contains a non valid permission : {}", new Object[]{line, permission});
                            }
                        }
                    }
                });
            }
            catch (IOException e) {
                LOG.error("Unable to read index file {}", new Object[]{indexPath});
            }
        }
        LOG.debug("PermissionsIndex : {}", new Object[]{this.permissionsIndex.toString()});
    }

    public void importFromDisk() throws RuntimeException {
        if (this.targetFolder == null || this.sourceFolder == null || this.sourceFolder.isEmpty() || this.targetFolder.isEmpty()) {
            LOG.error("Unable to start the import from disk. Mandatory parameters are missing : targerFolder={}, sourceFolder={}", new Object[]{this.targetFolder, this.sourceFolder});
            throw new RuntimeException("Mandatory parameters are missing. targetFolder = " + this.targetFolder + ", sourceFolder = " + this.sourceFolder);
        }
        long startTime = System.currentTimeMillis();
        LOG.info("Launch importFromDisk, from {} to {}", new Object[]{this.sourceFolder, this.targetFolder});
        Result result = new Result();
        this.readIndex(this.indexPath);
        try {
            ManageableRepository repository = this.repositoryService.getDefaultRepository();
            Session session = repository.getSystemSession("collaboration");
            Node targetNode = this.getOrCreateTargetNode(session, this.targetFolder);
            Path path = Path.of(this.sourceFolder, new String[0]);
            if (Files.exists(path, new LinkOption[0])) {
                long startCount = System.currentTimeMillis();
                this.countItems(result, path);
                LOG.info("Count done in {} ms, {} directories, {} files", new Object[]{System.currentTimeMillis() - startCount, result.nbDirectories, result.nbFiles});
                this.fillDirectory(targetNode, path, result);
            } else {
                LOG.error("Path source does not exists (sourceFolder={})", new Object[]{this.sourceFolder});
            }
        }
        catch (RepositoryException | RepositoryConfigurationException e) {
            LOG.error((Object)"Error when getting eXo Repository", e);
        }
        LOG.info("End importFromDisk, execution time = {} ms. {}/{} directories created, {}/{} files created.", new Object[]{System.currentTimeMillis() - startTime, result.currentDirectory, result.nbDirectories, result.currentFiles, result.nbFiles});
        LOG.info("{} directories in error : {}", new Object[]{result.directoriesInError.size(), result.directoriesInError.toString()});
        LOG.info("{} files in error : {}", new Object[]{result.filesInError.size(), result.filesInError.toString()});
        LOG.info("Permissions with error : {}", new Object[]{result.permissionsWithError});
    }

    private void countItems(Result result, Path path) {
        try (Stream<Path> stream = Files.walk(path, new FileVisitOption[0]);){
            stream.forEach(path1 -> (Files.isDirectory(path1, new LinkOption[0]) ? result.nbDirectories : result.nbFiles).getAndIncrement());
        }
        catch (IOException e) {
            LOG.error((Object)"Unable to count folders and files.");
        }
    }

    private void fillDirectory(Node targetNode, Path path, Result result) {
        try (Stream<Path> files = Files.list(path);){
            files.forEach(path1 -> {
                String filename = path1.getFileName().toString();
                if (Files.isDirectory(path1, new LinkOption[0])) {
                    try {
                        Node directoryNode = this.getOrCreateDirectoryChildNode(targetNode, (Path)path1, result);
                        this.fillDirectory(directoryNode, (Path)path1, result);
                    }
                    catch (Exception e) {
                        String targetNodePath = "";
                        try {
                            targetNode.getSession().refresh(false);
                            targetNodePath = targetNode.getPath();
                        }
                        catch (RepositoryException re) {
                            LOG.error((Object)"Unable to refresh session");
                        }
                        result.directoriesInError.add(path1.toString());
                        LOG.error("Unable to create folder {} in node {}.", new Object[]{filename, targetNodePath, e});
                    }
                } else {
                    try {
                        this.getOrCreateFileChildNode(targetNode, (Path)path1, result);
                    }
                    catch (Exception e) {
                        String targetNodePath = "";
                        try {
                            targetNode.getSession().refresh(false);
                            targetNodePath = targetNode.getPath();
                        }
                        catch (RepositoryException re) {
                            LOG.error((Object)"Unable to refresh session");
                        }
                        result.filesInError.add(path1.toString());
                        LOG.error("Unable to create file {} in node {}.", new Object[]{filename, targetNodePath, e});
                    }
                }
                if ((result.currentFiles + result.currentDirectory) % 100 == 0) {
                    LOG.info("Directories {}% ({}/{}), Files {}% ({}/{}).", new Object[]{result.currentDirectory * 100 / result.nbDirectories.intValue(), result.currentDirectory, result.nbDirectories, result.currentFiles * 100 / result.nbFiles.intValue(), result.currentFiles, result.nbFiles});
                }
            });
        }
        catch (IOException e) {
            LOG.error("Unable to read sourceFolder {}", new Object[]{this.sourceFolder, e});
        }
    }

    private Node getOrCreateFileChildNode(Node targetNode, Path path, Result result) throws Exception {
        String filename = path.getFileName().toString();
        String cleanedFileName = Text.escapeIllegalJcrChars((String)Utils.cleanString((String)filename));
        if (targetNode.hasNode(cleanedFileName)) {
            LOG.debug("File {}/{} exists.", new Object[]{targetNode.getPath(), cleanedFileName});
            ++result.currentFiles;
            return targetNode.getNode(cleanedFileName);
        }
        long startTime = System.currentTimeMillis();
        Node addedNode = targetNode.addNode(cleanedFileName, "nt:file");
        if (!addedNode.isNodeType("mix:referenceable")) {
            addedNode.addMixin("mix:referenceable");
        }
        if (!addedNode.isNodeType("mix:commentable")) {
            addedNode.addMixin("mix:commentable");
        }
        if (!addedNode.isNodeType("mix:votable")) {
            addedNode.addMixin("mix:votable");
        }
        if (!addedNode.isNodeType("mix:i18n")) {
            addedNode.addMixin("mix:i18n");
        }
        if (!addedNode.hasProperty("exo:title")) {
            addedNode.setProperty("exo:title", filename);
        }
        Node jcrContent = addedNode.addNode("jcr:content", "nt:resource");
        BasicFileAttributes attr = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
        GregorianCalendar lastModifiedDate = new GregorianCalendar();
        lastModifiedDate.setTimeInMillis(attr.lastModifiedTime().toMillis());
        jcrContent.setProperty("jcr:lastModified", (Calendar)lastModifiedDate);
        jcrContent.setProperty("jcr:data", Files.newInputStream(path, new OpenOption[0]));
        DMSMimeTypeResolver mimeTypeResolver = DMSMimeTypeResolver.getInstance();
        String mimetype = mimeTypeResolver.getMimeType(path.getFileName().toString());
        jcrContent.setProperty("jcr:mimeType", mimetype);
        targetNode.getSession().save();
        ++result.currentFiles;
        LOG.debug("File {}/{} not exists. Create it in {} ms.", new Object[]{targetNode.getPath(), cleanedFileName, System.currentTimeMillis() - startTime});
        return addedNode;
    }

    private Node getOrCreateDirectoryChildNode(Node targetNode, Path path, Result result) throws Exception {
        String filename = path.getFileName().toString();
        String cleanedFileName = Text.escapeIllegalJcrChars((String)Utils.cleanString((String)filename));
        if (targetNode.hasNode(cleanedFileName)) {
            LOG.debug("Folder {}/{} exists.", new Object[]{targetNode.getPath(), cleanedFileName});
            ++result.currentDirectory;
            return targetNode.getNode(cleanedFileName);
        }
        long startTime = System.currentTimeMillis();
        Node addedNode = targetNode.addNode(cleanedFileName, "nt:folder");
        if (!addedNode.hasProperty("exo:title")) {
            addedNode.addMixin("exo:rss-enable");
        }
        addedNode.setProperty("exo:title", filename);
        this.updatePermissions(addedNode, path, result);
        targetNode.save();
        ++result.currentDirectory;
        LOG.debug("Folder {}/{} not exists. Create it in ms.", new Object[]{targetNode.getPath(), cleanedFileName, System.currentTimeMillis() - startTime});
        return addedNode;
    }

    private void updatePermissions(Node addedNode, Path path, Result result) {
        block7: {
            String pathInIndex = path.toString().replace(this.sourceFolder, "");
            ExtendedNode extendedNode = (ExtendedNode)addedNode;
            if (this.permissionsIndex.containsKey(pathInIndex)) {
                long startTime = System.currentTimeMillis();
                List<Permission> permissions = this.permissionsIndex.get(pathInIndex);
                try {
                    if (extendedNode.canAddMixin("exo:privilegeable")) {
                        extendedNode.addMixin("exo:privilegeable");
                    }
                    permissions.stream().forEach(permission -> {
                        try {
                            ListAccess groups = this.organizationService.getGroupHandler().findGroupsByKeyword(permission.groupName);
                            if (groups.getSize() == 0) {
                                LOG.error("Group with name {} do not exists. Ignore permission.", new Object[]{permission.groupName});
                                this.addInPermisionWithError(result.permissionsWithError, (Permission)permission, pathInIndex);
                            } else if (groups.getSize() > 1) {
                                LOG.error("Group with name {} return more than one group. Ignore permission.", new Object[]{permission.groupName});
                                this.addInPermisionWithError(result.permissionsWithError, (Permission)permission, pathInIndex);
                            } else {
                                Group group = ((Group[])groups.load(0, 1))[0];
                                if (permission.right == AccessRight.READ) {
                                    String[] permsArray = new String[]{"read"};
                                    extendedNode.setPermission(group.getId(), permsArray);
                                } else {
                                    extendedNode.setPermission(group.getId(), PermissionType.ALL);
                                }
                            }
                        }
                        catch (Exception e) {
                            LOG.error("Error when getting group {}", new Object[]{permission.groupName, e});
                            this.addInPermisionWithError(result.permissionsWithError, (Permission)permission, pathInIndex);
                        }
                    });
                    LOG.debug("Permissions {} added on folder {} in {} ms", new Object[]{permissions, pathInIndex, System.currentTimeMillis() - startTime});
                }
                catch (RepositoryException e) {
                    try {
                        LOG.error("Unable to add permission mixin on node {}", new Object[]{addedNode.getPath(), e});
                    }
                    catch (RepositoryException ex) {
                        LOG.error("Unable read exo node {}", new Object[]{pathInIndex, ex});
                    }
                    if (this.permissionsIndex.containsKey(pathInIndex)) {
                        result.permissionsWithError.put(pathInIndex, this.permissionsIndex.get(pathInIndex));
                    }
                    break block7;
                }
            }
            LOG.debug("No permission exists for path {}", new Object[]{this.indexPath});
        }
    }

    private void addInPermisionWithError(Map<String, List<Permission>> permissionsWithError, Permission permission, String path) {
        if (permissionsWithError.containsKey(path)) {
            permissionsWithError.get(path).add(permission);
        } else {
            ArrayList<Permission> permissionList = new ArrayList<Permission>();
            permissionList.add(permission);
            permissionsWithError.put(path, permissionList);
        }
    }

    private Node getOrCreateTargetNode(Session session, String targetFolder) throws RuntimeException {
        try {
            String targetFolderCleaned = "/" + Text.escapeIllegalJcrChars((String)Utils.cleanString((String)targetFolder.replace("/", "---"))).replace("---", "/");
            Node targetNode = (Node)session.getItem(targetFolderCleaned);
            LOG.debug("Target Node {} is present in eXo, get it.", new Object[]{targetNode.getPath()});
            return targetNode;
        }
        catch (PathNotFoundException pne) {
            LOG.debug("Target Node {} is not present in eXo, create it.", new Object[]{targetFolder});
        }
        catch (RepositoryException e) {
            LOG.error("Unable to get targetNode {}", new Object[]{targetFolder, e});
            throw new RuntimeException("Unable to get targetNode " + targetFolder, e);
        }
        try {
            String[] paths;
            Node rootNode = session.getRootNode();
            for (String path : paths = targetFolder.split("/")) {
                if (path.equals("")) continue;
                try {
                    String name = Text.escapeIllegalJcrChars((String)Utils.cleanString((String)path));
                    if (!rootNode.hasNode(name)) {
                        Node addedNode = rootNode.addNode(name, "nt:folder");
                        if (!addedNode.hasProperty("exo:title")) {
                            addedNode.addMixin("exo:rss-enable");
                        }
                        addedNode.setProperty("exo:title", path);
                        rootNode.save();
                        rootNode = addedNode;
                        LOG.debug("Node {} created.", new Object[]{rootNode.getPath()});
                        continue;
                    }
                    rootNode = rootNode.getNode(name);
                    LOG.debug("Node {} already exists.", new Object[]{rootNode.getPath()});
                }
                catch (RepositoryException r) {
                    LOG.error("Unable to create folder {} in path {} in eXo", new Object[]{path, targetFolder, r});
                    throw new RuntimeException("Unable to create folder " + path + " in path " + targetFolder + " in eXo", r);
                }
            }
            return rootNode;
        }
        catch (RepositoryException r) {
            LOG.error((Object)"Unable read rootNode", (Throwable)r);
            throw new RuntimeException("Unable read rootNode", r);
        }
    }

    public static enum AccessRight {
        READ,
        WRITE;

    }

    private class Permission {
        String groupName;
        AccessRight right;

        public Permission(String group, AccessRight permission) {
            this.groupName = group;
            this.right = permission;
        }

        public String toString() {
            return "[" + this.groupName + "," + this.right.toString() + "]";
        }
    }

    public class Result {
        public AtomicInteger nbDirectories = new AtomicInteger(-1);
        public AtomicInteger nbFiles = new AtomicInteger(0);
        public int currentDirectory = 0;
        public int currentFiles = 0;
        public List<String> filesInError = new ArrayList<String>();
        public List<String> directoriesInError = new ArrayList<String>();
        public Map<String, List<Permission>> permissionsWithError = new HashMap<String, List<Permission>>();
    }
}

