/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.listener;

import java.util.List;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.social.core.space.SpaceListenerPlugin;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleEvent;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.mow.api.Permission;
import org.exoplatform.wiki.mow.api.PermissionEntry;
import org.exoplatform.wiki.mow.api.PermissionType;
import org.exoplatform.wiki.mow.api.Wiki;
import org.exoplatform.wiki.mow.api.WikiType;
import org.exoplatform.wiki.service.IDType;
import org.exoplatform.wiki.service.PageUpdateType;
import org.exoplatform.wiki.service.WikiService;

public class CSWikiInitializeListener
extends SpaceListenerPlugin {
    private final InitParams params;
    private final WikiService wikiService;

    public CSWikiInitializeListener(InitParams params, WikiService wikiService) {
        this.wikiService = wikiService;
        this.params = params;
    }

    public InitParams getParams() {
        return this.params;
    }

    public void applicationActivated(SpaceLifeCycleEvent event) {
    }

    public void applicationAdded(SpaceLifeCycleEvent event) {
    }

    public void applicationDeactivated(SpaceLifeCycleEvent event) {
    }

    public void applicationRemoved(SpaceLifeCycleEvent event) {
    }

    public void grantedLead(SpaceLifeCycleEvent event) {
    }

    public void joined(SpaceLifeCycleEvent event) {
    }

    public void left(SpaceLifeCycleEvent event) {
    }

    public void revokedLead(SpaceLifeCycleEvent event) {
    }

    public void spaceCreated(SpaceLifeCycleEvent event) {
        try {
            Wiki spaceWiki = this.wikiService.getWikiByTypeAndOwner(WikiType.GROUP.name(), event.getSpace().getGroupId());
            if (spaceWiki == null) {
                spaceWiki = this.wikiService.createWiki(WikiType.GROUP.name(), event.getSpace().getGroupId());
            }
            Page wikiHome = this.wikiService.getPageOfWikiByName(WikiType.GROUP.name(), event.getSpace().getGroupId(), "WikiHome");
            wikiHome.setContent("=Welcome to the customer space " + event.getSpace().getDisplayName() + "=");
            Permission[] readOnlyPermission = new Permission[]{new Permission(PermissionType.VIEWPAGE, true)};
            Permission[] allPermissions = new Permission[]{new Permission(PermissionType.VIEWPAGE, true), new Permission(PermissionType.EDITPAGE, true), new Permission(PermissionType.ADMINPAGE, true), new Permission(PermissionType.ADMINSPACE, true)};
            PermissionEntry spaceMembersPermissionEntry = new PermissionEntry("member:" + event.getSpace().getGroupId(), "", IDType.MEMBERSHIP, readOnlyPermission);
            PermissionEntry spaceManagersPermissionEntry = new PermissionEntry("manager:" + event.getSpace().getGroupId(), "", IDType.MEMBERSHIP, allPermissions);
            List permissions = wikiHome.getPermissions();
            permissions.add(spaceMembersPermissionEntry);
            permissions.add(spaceManagersPermissionEntry);
            wikiHome.setPermissions(permissions);
            this.wikiService.updatePage(wikiHome, PageUpdateType.EDIT_PAGE_CONTENT);
        }
        catch (WikiException e) {
            e.printStackTrace();
        }
    }

    public void spaceRemoved(SpaceLifeCycleEvent event) {
    }

    public void spaceRenamed(SpaceLifeCycleEvent event) {
    }

    public void spaceDescriptionEdited(SpaceLifeCycleEvent event) {
    }

    public void spaceAvatarEdited(SpaceLifeCycleEvent event) {
    }

    public void spaceAccessEdited(SpaceLifeCycleEvent event) {
    }

    public void addInvitedUser(SpaceLifeCycleEvent event) {
    }

    public void addPendingUser(SpaceLifeCycleEvent event) {
    }
}

