package org.exoplatform.cs.listener;

import java.util.List;


import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.SpaceListenerPlugin;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleEvent;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.mow.api.Permission;
import org.exoplatform.wiki.mow.api.PermissionEntry;
import org.exoplatform.wiki.mow.api.PermissionType;
import org.exoplatform.wiki.mow.api.Template;
import org.exoplatform.wiki.mow.api.Wiki;
import org.exoplatform.wiki.mow.api.WikiType;
import org.exoplatform.wiki.service.IDType;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.utils.WikiConstants;

/**
 * Created by IntelliJ IDEA.
 * User: ali
 * Date: 04/11/16
 * Time: 17:38
 */
public class CSWikiInitializeListener extends SpaceListenerPlugin {

  private static final Log LOG = ExoLogger.getLogger(CSWikiInitializeListener.class);

  private final InitParams params;
  private final WikiService wikiService;
  private final String templatePage = "support_guide_template";

  public CSWikiInitializeListener(InitParams params, WikiService wikiService) {
    this.wikiService = wikiService;
    this.params = params;
  }

  public InitParams getParams() {
    return params;
  }

  @Override
  public void applicationActivated(SpaceLifeCycleEvent event) {
  }

  @Override
  public void applicationAdded(SpaceLifeCycleEvent event) {
  }

  @Override
  public void applicationDeactivated(SpaceLifeCycleEvent event) {
  }

  @Override
  public void applicationRemoved(SpaceLifeCycleEvent event) {
  }

  @Override
  public void grantedLead(SpaceLifeCycleEvent event) {
  }

  @Override
  public void joined(SpaceLifeCycleEvent event) {
  }

  @Override
  public void left(SpaceLifeCycleEvent event) {
  }

  @Override
  public void revokedLead(SpaceLifeCycleEvent event) {
  }

  @Override
  public void spaceCreated(SpaceLifeCycleEvent event) {
    try {
      Wiki spaceWiki = wikiService.getWikiByTypeAndOwner(WikiType.GROUP.name(), event.getSpace().getGroupId());
      if(spaceWiki == null){
        spaceWiki = wikiService.createWiki(WikiType.GROUP.name(), event.getSpace().getGroupId());
      }
      Page wikiHome = wikiService.getPageByRootPermission(WikiType.GROUP.name(), event.getSpace().getGroupId(), WikiConstants.WIKI_HOME_NAME);
      Permission[] readOnlyPermission = new Permission[] {
          new Permission(PermissionType.VIEWPAGE, true)
      };
      Permission[] allPermissions = new Permission[] {
          new Permission(PermissionType.VIEWPAGE, true),
          new Permission(PermissionType.EDITPAGE, true),
          new Permission(PermissionType.ADMINPAGE, true),
          new Permission(PermissionType.ADMINSPACE, true)
      };
      PermissionEntry spaceMembersPermissionEntry =new PermissionEntry("member:" + event.getSpace().getGroupId(), "", IDType.MEMBERSHIP, readOnlyPermission);
      PermissionEntry spaceManagersPermissionEntry =new PermissionEntry("manager:" + event.getSpace().getGroupId(), "", IDType.MEMBERSHIP, allPermissions);
      List<PermissionEntry> permissions = wikiHome.getPermissions();
      permissions.add(spaceMembersPermissionEntry);
      permissions.add(spaceManagersPermissionEntry);
      wikiHome.setPermissions(permissions);
      WikiPageParams params = new WikiPageParams(WikiType.GROUP.name(), event.getSpace().getGroupId(),null);
      Template template = wikiService.getTemplatePage(params,templatePage);
      wikiHome.setContent(template.getContent());

      wikiService.updatePage(wikiHome, null);
    } catch (WikiException e) {
      LOG.error("Could not create a wiki page for this space",e);
    }
  }

  @Override
  public void spaceRemoved(SpaceLifeCycleEvent event) {
  }

  @Override
  public void spaceRenamed(SpaceLifeCycleEvent event) {}

  @Override
  public void spaceDescriptionEdited(SpaceLifeCycleEvent event) {}

  @Override
  public void spaceAvatarEdited(SpaceLifeCycleEvent event) {}

  @Override
  public void spaceAccessEdited(SpaceLifeCycleEvent event) {

  }

  @Override
  public void addInvitedUser(SpaceLifeCycleEvent event) {
  }

  @Override
  public void addPendingUser(SpaceLifeCycleEvent event) {
  }

}
