/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.cs.dto.InfoType;
import org.exoplatform.cs.dto.IssueSeverity;
import org.exoplatform.cs.dto.IssueType;

@JsonIgnoreProperties(value={"simpleDateFormat"})
public class TicketDTO {
    @JsonIgnore
    public SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
    private String id;
    private String title;
    private String status;
    private String description;
    private String link;
    private String assignee;
    private String tagName;
    private IssueType type;
    private IssueSeverity severity;
    private InfoType infoType;
    private String spaceGroupId;
    private String environmentName;
    private Long environmentId;
    private String startDate;
    private String endDate;
    private transient String dateFormat;
    private List<FileItem> files;

    public boolean verifySaveConditions() {
        return !StringUtils.isEmpty((String)this.title) && !StringUtils.isEmpty((String)this.description) && this.type != null && this.spaceGroupId != null && (!IssueType.INCIDENT.equals((Object)this.type) || this.environmentId != null && this.severity != null) && (!IssueType.INFORMATION.equals((Object)this.type) || this.infoType != null);
    }

    public Date retrieveFormattedStartDate() throws ParseException {
        return this.retrieveFormattedDate(this.startDate);
    }

    public Date retrieveFormattedEndDate() throws ParseException {
        return this.retrieveFormattedDate(this.endDate);
    }

    private Date retrieveFormattedDate(String dateValue) throws ParseException {
        if (StringUtils.isEmpty((String)dateValue) || StringUtils.isEmpty((String)this.dateFormat)) {
            return null;
        }
        this.simpleDateFormat.applyPattern(this.dateFormat);
        return this.simpleDateFormat.parse(dateValue);
    }

    public SimpleDateFormat getSimpleDateFormat() {
        return this.simpleDateFormat;
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getStatus() {
        return this.status;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLink() {
        return this.link;
    }

    public String getAssignee() {
        return this.assignee;
    }

    public String getTagName() {
        return this.tagName;
    }

    public IssueType getType() {
        return this.type;
    }

    public IssueSeverity getSeverity() {
        return this.severity;
    }

    public InfoType getInfoType() {
        return this.infoType;
    }

    public String getSpaceGroupId() {
        return this.spaceGroupId;
    }

    public String getEnvironmentName() {
        return this.environmentName;
    }

    public Long getEnvironmentId() {
        return this.environmentId;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public String getEndDate() {
        return this.endDate;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public List<FileItem> getFiles() {
        return this.files;
    }

    public void setSimpleDateFormat(SimpleDateFormat simpleDateFormat) {
        this.simpleDateFormat = simpleDateFormat;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public void setAssignee(String assignee) {
        this.assignee = assignee;
    }

    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    public void setType(IssueType type) {
        this.type = type;
    }

    public void setSeverity(IssueSeverity severity) {
        this.severity = severity;
    }

    public void setInfoType(InfoType infoType) {
        this.infoType = infoType;
    }

    public void setSpaceGroupId(String spaceGroupId) {
        this.spaceGroupId = spaceGroupId;
    }

    public void setEnvironmentName(String environmentName) {
        this.environmentName = environmentName;
    }

    public void setEnvironmentId(Long environmentId) {
        this.environmentId = environmentId;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void setFiles(List<FileItem> files) {
        this.files = files;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TicketDTO)) {
            return false;
        }
        TicketDTO other = (TicketDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SimpleDateFormat this$simpleDateFormat = this.getSimpleDateFormat();
        SimpleDateFormat other$simpleDateFormat = other.getSimpleDateFormat();
        if (this$simpleDateFormat == null ? other$simpleDateFormat != null : !((Object)this$simpleDateFormat).equals(other$simpleDateFormat)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$link = this.getLink();
        String other$link = other.getLink();
        if (this$link == null ? other$link != null : !this$link.equals(other$link)) {
            return false;
        }
        String this$assignee = this.getAssignee();
        String other$assignee = other.getAssignee();
        if (this$assignee == null ? other$assignee != null : !this$assignee.equals(other$assignee)) {
            return false;
        }
        String this$tagName = this.getTagName();
        String other$tagName = other.getTagName();
        if (this$tagName == null ? other$tagName != null : !this$tagName.equals(other$tagName)) {
            return false;
        }
        IssueType this$type = this.getType();
        IssueType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        IssueSeverity this$severity = this.getSeverity();
        IssueSeverity other$severity = other.getSeverity();
        if (this$severity == null ? other$severity != null : !((Object)((Object)this$severity)).equals((Object)other$severity)) {
            return false;
        }
        InfoType this$infoType = this.getInfoType();
        InfoType other$infoType = other.getInfoType();
        if (this$infoType == null ? other$infoType != null : !((Object)((Object)this$infoType)).equals((Object)other$infoType)) {
            return false;
        }
        String this$spaceGroupId = this.getSpaceGroupId();
        String other$spaceGroupId = other.getSpaceGroupId();
        if (this$spaceGroupId == null ? other$spaceGroupId != null : !this$spaceGroupId.equals(other$spaceGroupId)) {
            return false;
        }
        String this$environmentName = this.getEnvironmentName();
        String other$environmentName = other.getEnvironmentName();
        if (this$environmentName == null ? other$environmentName != null : !this$environmentName.equals(other$environmentName)) {
            return false;
        }
        Long this$environmentId = this.getEnvironmentId();
        Long other$environmentId = other.getEnvironmentId();
        if (this$environmentId == null ? other$environmentId != null : !((Object)this$environmentId).equals(other$environmentId)) {
            return false;
        }
        String this$startDate = this.getStartDate();
        String other$startDate = other.getStartDate();
        if (this$startDate == null ? other$startDate != null : !this$startDate.equals(other$startDate)) {
            return false;
        }
        String this$endDate = this.getEndDate();
        String other$endDate = other.getEndDate();
        if (this$endDate == null ? other$endDate != null : !this$endDate.equals(other$endDate)) {
            return false;
        }
        List<FileItem> this$files = this.getFiles();
        List<FileItem> other$files = other.getFiles();
        return !(this$files == null ? other$files != null : !((Object)this$files).equals(other$files));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TicketDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SimpleDateFormat $simpleDateFormat = this.getSimpleDateFormat();
        result = result * 59 + ($simpleDateFormat == null ? 43 : ((Object)$simpleDateFormat).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $link = this.getLink();
        result = result * 59 + ($link == null ? 43 : $link.hashCode());
        String $assignee = this.getAssignee();
        result = result * 59 + ($assignee == null ? 43 : $assignee.hashCode());
        String $tagName = this.getTagName();
        result = result * 59 + ($tagName == null ? 43 : $tagName.hashCode());
        IssueType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        IssueSeverity $severity = this.getSeverity();
        result = result * 59 + ($severity == null ? 43 : ((Object)((Object)$severity)).hashCode());
        InfoType $infoType = this.getInfoType();
        result = result * 59 + ($infoType == null ? 43 : ((Object)((Object)$infoType)).hashCode());
        String $spaceGroupId = this.getSpaceGroupId();
        result = result * 59 + ($spaceGroupId == null ? 43 : $spaceGroupId.hashCode());
        String $environmentName = this.getEnvironmentName();
        result = result * 59 + ($environmentName == null ? 43 : $environmentName.hashCode());
        Long $environmentId = this.getEnvironmentId();
        result = result * 59 + ($environmentId == null ? 43 : ((Object)$environmentId).hashCode());
        String $startDate = this.getStartDate();
        result = result * 59 + ($startDate == null ? 43 : $startDate.hashCode());
        String $endDate = this.getEndDate();
        result = result * 59 + ($endDate == null ? 43 : $endDate.hashCode());
        List<FileItem> $files = this.getFiles();
        result = result * 59 + ($files == null ? 43 : ((Object)$files).hashCode());
        return result;
    }

    public String toString() {
        return "TicketDTO(simpleDateFormat=" + this.getSimpleDateFormat() + ", id=" + this.getId() + ", title=" + this.getTitle() + ", status=" + this.getStatus() + ", description=" + this.getDescription() + ", link=" + this.getLink() + ", assignee=" + this.getAssignee() + ", tagName=" + this.getTagName() + ", type=" + (Object)((Object)this.getType()) + ", severity=" + (Object)((Object)this.getSeverity()) + ", infoType=" + (Object)((Object)this.getInfoType()) + ", spaceGroupId=" + this.getSpaceGroupId() + ", environmentName=" + this.getEnvironmentName() + ", environmentId=" + this.getEnvironmentId() + ", startDate=" + this.getStartDate() + ", endDate=" + this.getEndDate() + ", dateFormat=" + this.getDateFormat() + ", files=" + this.getFiles() + ")";
    }
}

