/*
 * Copyright (C) 2003-2016 eXo Platform SAS.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package org.exoplatform.cs.service.listener;

import org.apache.commons.lang3.StringUtils;
import org.gatein.api.Portal;
import org.gatein.api.PortalRequest;
import org.gatein.api.security.Group;
import org.gatein.api.security.User;
import org.gatein.api.site.Site;
import org.gatein.api.site.SiteId;
import org.gatein.api.site.SiteType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.application.RequestNavigationData;
import org.exoplatform.portal.resource.SkinService;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.web.application.Application;
import org.exoplatform.web.application.ApplicationLifecycle;
import org.exoplatform.web.application.RequestFailure;
import org.exoplatform.webui.application.WebuiRequestContext;

public class SkinNameApplicationLifecycle implements ApplicationLifecycle<WebuiRequestContext> {
  private static final Logger LOG = LoggerFactory.getLogger(SkinNameApplicationLifecycle.class);

  @Override
  public void onInit(Application app) throws Exception {

  }

  @Override
  public void onStartRequest(Application app, WebuiRequestContext context) throws Exception {
    PortalRequestContext pcontext = (PortalRequestContext) context;
    UIPortalApplication uiApp = (UIPortalApplication) pcontext.getUIApplication();
    try {
      if (pcontext.isResponseComplete())
        return;

      String siteName = pcontext.getControllerContext().getParameter(RequestNavigationData.REQUEST_SITE_NAME);
      String siteType = pcontext.getControllerContext().getParameter(RequestNavigationData.REQUEST_SITE_TYPE);
      Site site = null;
      Portal portal = PortalRequest.getInstance().getPortal();

      if (siteType.equalsIgnoreCase(org.exoplatform.portal.mop.SiteType.GROUP.name())) {
        site = portal.getSite(new SiteId(new Group(siteName)));
      } else if (siteType.equalsIgnoreCase(org.exoplatform.portal.mop.SiteType.USER.name())) {
        site = portal.getSite(new SiteId(new User(siteName)));
      } else {
        site = portal.getSite(new SiteId(SiteType.SITE, siteName));
      }

      if (site != null) {
        if (StringUtils.isBlank(site.getSkin())) {
          uiApp.setSkin(SkinService.DEFAULT_SKIN);
        } else {
          uiApp.setSkin(site.getSkin());
        }
      } else {
        uiApp.setSkin(SkinService.DEFAULT_SKIN);
      }
    } catch (Exception e) {
      LOG.warn("Error while setting skin name, set default one", e);
      uiApp.setSkin(SkinService.DEFAULT_SKIN);
    }
  }

  @Override
  public void onFailRequest(Application app, WebuiRequestContext context, RequestFailure failureType) {
  }

  @Override
  public void onEndRequest(Application app, WebuiRequestContext context) throws Exception {
  }

  @Override
  public void onDestroy(Application app) throws Exception {
  }

}
