package org.exoplatform.cs.listener;

import java.util.Calendar;
import java.util.List;

import org.exoplatform.cs.dao.TopicDAO;
import org.exoplatform.cs.dto.IssueType;
import org.exoplatform.cs.entity.TopicEntity;
import org.exoplatform.cs.service.CSConstants;
import org.exoplatform.cs.service.util.CSUtils;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.DataStorage;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumEventListener;
import org.exoplatform.forum.service.MessageBuilder;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.User;

/**
 * Created by IntelliJ IDEA.
 * User: ali
 * Date: 16/01/17
 * Time: 16:26
 */
public class ForumListener extends ForumEventListener {
  private static final Log LOG = ExoLogger.getLogger(ForumListener.class);
  private TopicDAO topicDAO;
  private DataStorage dataStorage;


  public ForumListener(TopicDAO topicDAO, DataStorage dataStorage) {
    this.topicDAO = topicDAO;
    this.dataStorage = dataStorage;
  }

  @Override
  public void addTopic(Topic topic) {

  }

  @Override
  public void updateTopic(Topic topic) {
    if(topic.getIsClosed()){
      TopicEntity ticket = topicDAO.find(topic.getId());
      if(ticket != null){
        ticket.setStatus(CSConstants.STATUS_CLOSED);
        topicDAO.update(ticket);
      }
    }
  }

  @Override
  public void updateTopics(List<Topic> topics, boolean isLock) {

  }

  @Override
  public void moveTopic(Topic topic, String toCategoryName, String toForumName) {

  }

  @Override
  public void movePost(List<Post> posts, List<String> srcPostActivityIds, String desTopicPath) {

  }

  @Override
  public void mergeTopic(Topic newTopic, String removeActivityId1, String removeActivityId2) {

  }

  @Override
  public void splitTopic(Topic newTopic, Topic splitedTopic, String removeActivityId) {

  }

  @Override
  public void addPost(Post post) {
    String topicID = post.getTopicId();
    TopicEntity topicEntity = topicDAO.find(topicID);
    if (topicEntity != null && !IssueType.PRODUCT.equals(topicEntity.getType())) {
      topicEntity.setUpdateDate(Calendar.getInstance());
      topicDAO.update(topicEntity);
    }
  }
   /*TODO wait until https://jira.exoplatform.org/browse/FORUM-1320 is solved
  @Override
  public void addPrivatePost(Post post) {
    try {
      TopicEntity topic = topicDAO.find(post.getTopicId());
      if (topic != null && !IssueType.PRODUCT.equals(topic.getType())) {
        List<User> supportMembers = CSUtils.getSupportMembers();
        String[] userPrivate = supportMembers.stream().map(User::getUserName).toArray(String[]::new);
        post.setUserPrivate(userPrivate);
        post.setMessage("<div class=\"alert alert-warning\" id=\"\">" + post.getMessage() + "</div>");
        dataStorage.savePost(post.getCategoryId(), post.getForumId(), post.getTopicId(), post, false, new MessageBuilder());
        topic.setUpdateDate(Calendar.getInstance());
        topicDAO.update(topic);
      }
    } catch (Exception e) {
      e.printStackTrace();
    }

  }

  @Override
  public void updatePrivatePost(Post post) {

  }     */

  @Override
  public void updatePost(Post post) {

  }

  @Override
  public void updatePost(Post post, int type) {

  }

  @Override
  public void removeActivity(String activityId) {

  }

  @Override
  public void removeComment(String activityId, String commentId) {

  }

  @Override
  public void saveCategory(Category category) {

  }

  @Override
  public void saveForum(Forum forum) {

  }
}
