/*
 * Copyright (C) 2003-2016 eXo Platform SAS.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package org.exoplatform.cs.entity;

import java.util.HashSet;
import java.util.Set;

import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

import lombok.Data;

import org.exoplatform.commons.api.persistence.ExoEntity;

/**
 * Created by The eXo Platform SAS
 * 
 * @author boubaker.khanfir@exoplatform.com
 * @since Apr 27, 2016
 */
@Entity(name = "CSEnvironmentEntity")
@ExoEntity
@Table(name = "CS_ADDON_ENVIRONMENTS")
@Data
@NamedQueries({
    @NamedQuery(name = "envEntity.getEnvironmentsBySpace", query = "SELECT a FROM CSEnvironmentEntity a where a.space.id = :spaceGroupID")})
public class EnvironmentEntity {

  @Id
  @Column(name = "ENVIRONMENT_ID")
  @SequenceGenerator(name = "SEQ_CS_ENVIRONMENT_ID")
  @GeneratedValue(strategy = GenerationType.AUTO, generator = "SEQ_CS_ENVIRONMENT_ID")
  private Long          id;

  @Column(name = "NAME")
  private String        name;

  @Column(name = "DEFAULT_ENVIRONMENT")
  private boolean       defaultEnvironment;

  @ManyToOne
  @JoinColumn(name = "ENV_ID", nullable = false)
  private EnvTypeEntity env;

  @Column(name = "PRODUCT_VERSION")
  private String        productVersion;

  @ManyToOne
  @JoinColumn(name = "OS_ID")
  private OSTypeEntity  os;

  @Column(name = "OS_VERSION")
  private String        osVersion;

  @ManyToOne
  @JoinColumn(name = "JVM_ID")
  private JVMTypeEntity jvmVendor;

  @Column(name = "JVM_VERSION")
  private String        jvmVersion;

  @ManyToOne
  @JoinColumn(name = "AS_ID")
  private ASTypeEntity  appServer;

  @Column(name = "AS_VERSION")
  private String        asVersion;

  @ManyToOne
  @JoinColumn(name = "DB_ID")
  private DBTypeEntity  rdbms;

  @Column(name = "DB_VERSION")
  private String        dbVersion;

  @Column(name = "DB_ENCODING")
  private String        dbEncoding;

  @ManyToOne
  @JoinColumn(name = "SSO_ID")
  private SSOTypeEntity sso;

  @Column(name = "SSO_VERSION")
  private String        ssoVersion;

  @Column(name = "MORE_INFORMATION")
  private String        moreInformation;

  @ElementCollection
  @CollectionTable(name = "CS_ADDON_BROWSERS", joinColumns = @JoinColumn(name = "ENVIRONMENT_ID"))
  @Column(name = "BROWSER")
  private Set<String>   browsers = new HashSet<String>();

  @ManyToOne
  @JoinColumn(name = "SPACE_ID", nullable = false)
  private SpaceEntity   space;
}