/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.service;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.jcr.NodeIterator;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.forum.common.cache.ServiceContext;
import org.exoplatform.forum.common.cache.model.CacheType;
import org.exoplatform.forum.common.cache.model.CachedData;
import org.exoplatform.forum.common.cache.model.data.SimpleCacheData;
import org.exoplatform.forum.common.cache.model.key.SimpleCacheKey;
import org.exoplatform.forum.common.cache.model.selector.ScopeCacheSelector;
import org.exoplatform.forum.common.conf.RoleRulesPlugin;
import org.exoplatform.forum.common.jcr.KSDataLocation;
import org.exoplatform.forum.common.lifecycle.LifeCycleCompletionService;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.DataStorage;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumAdministration;
import org.exoplatform.forum.service.ForumAttachment;
import org.exoplatform.forum.service.ForumEventQuery;
import org.exoplatform.forum.service.ForumLinkData;
import org.exoplatform.forum.service.ForumPrivateMessage;
import org.exoplatform.forum.service.ForumSearchResult;
import org.exoplatform.forum.service.ForumStatistic;
import org.exoplatform.forum.service.ForumSubscription;
import org.exoplatform.forum.service.InitializeForumPlugin;
import org.exoplatform.forum.service.JCRPageList;
import org.exoplatform.forum.service.LazyPageList;
import org.exoplatform.forum.service.MessageBuilder;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.PruneSetting;
import org.exoplatform.forum.service.SendMessageInfo;
import org.exoplatform.forum.service.SortSettings;
import org.exoplatform.forum.service.Tag;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.forum.service.Watch;
import org.exoplatform.forum.service.cache.model.data.CategoryData;
import org.exoplatform.forum.service.cache.model.data.ForumData;
import org.exoplatform.forum.service.cache.model.data.LinkData;
import org.exoplatform.forum.service.cache.model.data.ListCategoryData;
import org.exoplatform.forum.service.cache.model.data.ListForumData;
import org.exoplatform.forum.service.cache.model.data.ListLinkData;
import org.exoplatform.forum.service.cache.model.data.ListPostData;
import org.exoplatform.forum.service.cache.model.data.ListTopicData;
import org.exoplatform.forum.service.cache.model.data.ListUserProfileData;
import org.exoplatform.forum.service.cache.model.data.ListWatchData;
import org.exoplatform.forum.service.cache.model.data.LoginUserProfileData;
import org.exoplatform.forum.service.cache.model.data.PostData;
import org.exoplatform.forum.service.cache.model.data.TagData;
import org.exoplatform.forum.service.cache.model.data.TopicData;
import org.exoplatform.forum.service.cache.model.data.UserProfileData;
import org.exoplatform.forum.service.cache.model.data.WatchData;
import org.exoplatform.forum.service.cache.model.key.CategoryKey;
import org.exoplatform.forum.service.cache.model.key.CategoryListKey;
import org.exoplatform.forum.service.cache.model.key.ForumKey;
import org.exoplatform.forum.service.cache.model.key.ForumListKey;
import org.exoplatform.forum.service.cache.model.key.LinkListKey;
import org.exoplatform.forum.service.cache.model.key.ObjectNameKey;
import org.exoplatform.forum.service.cache.model.key.PostKey;
import org.exoplatform.forum.service.cache.model.key.PostListCountKey;
import org.exoplatform.forum.service.cache.model.key.PostListKey;
import org.exoplatform.forum.service.cache.model.key.TopicKey;
import org.exoplatform.forum.service.cache.model.key.TopicListCountKey;
import org.exoplatform.forum.service.cache.model.key.TopicListKey;
import org.exoplatform.forum.service.cache.model.key.UserProfileKey;
import org.exoplatform.forum.service.cache.model.key.UserProfileListCountKey;
import org.exoplatform.forum.service.cache.model.key.UserProfileListKey;
import org.exoplatform.forum.service.cache.model.selector.CategoryIdSelector;
import org.exoplatform.forum.service.cache.model.selector.ForumPathSelector;
import org.exoplatform.forum.service.cache.model.selector.MiscDataSelector;
import org.exoplatform.forum.service.cache.model.selector.PostListCountSelector;
import org.exoplatform.forum.service.cache.model.selector.TopicListCountSelector;
import org.exoplatform.forum.service.cache.model.selector.TopicListSelector;
import org.exoplatform.forum.service.filter.model.CategoryFilter;
import org.exoplatform.forum.service.filter.model.ForumFilter;
import org.exoplatform.forum.service.impl.JCRDataStorage;
import org.exoplatform.forum.service.impl.model.PostFilter;
import org.exoplatform.forum.service.impl.model.TopicFilter;
import org.exoplatform.forum.service.impl.model.UserProfileFilter;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.CachedObjectSelector;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.future.FutureExoCache;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.User;
import org.picocontainer.Startable;

public class CachedDataStorage
implements DataStorage,
Startable {
    private static final Log LOG = ExoLogger.getLogger(org.exoplatform.forum.service.cache.CachedDataStorage.class);
    private static final String PRIVATE_MESSAGE_COUNT_KEY = "messageCount";
    private static final String SCREEN_NAME_KEY = "screenName";
    private static final String FORUM_CAN_VIEW_KEY = "userCanView";
    private static final String USER_AVATAR_KEY = "userAvatarKey";
    private static final String PROFILE_KEY = "profile";
    private static final String WATCH_TYPE = "watchType";
    private DataStorage storage;
    private CacheService service;
    private LifeCycleCompletionService completionService;
    private ExoCache<CategoryKey, CategoryData> categoryData;
    private ExoCache<CategoryListKey, ListCategoryData> categoryList;
    private ExoCache<ForumKey, ForumData> forumData;
    private ExoCache<ForumListKey, ListForumData> forumList;
    private ExoCache<PostKey, PostData> postData;
    private ExoCache<PostListKey, ListPostData> postList;
    private ExoCache<PostListCountKey, SimpleCacheData<Integer>> postListCount;
    private ExoCache<TopicKey, TopicData> topicData;
    private ExoCache<TopicListKey, ListTopicData> topicList;
    private ExoCache<TopicListCountKey, SimpleCacheData<Integer>> topicListCount;
    private ExoCache<UserProfileKey, UserProfileData> userProfileData;
    private ExoCache<UserProfileListKey, ListUserProfileData> userProfileList;
    private ExoCache<UserProfileListCountKey, SimpleCacheData<Integer>> userProfileListCount;
    private ExoCache<UserProfileKey, LoginUserProfileData> loginUserProfile;
    private ExoCache<SimpleCacheKey, ListWatchData> watchListData;
    private ExoCache<LinkListKey, ListLinkData> linkListData;
    private ExoCache<ObjectNameKey, CachedData> objectNameData;
    private ExoCache<SimpleCacheKey, SimpleCacheData> miscData;
    private FutureExoCache<CategoryKey, CategoryData, ServiceContext<CategoryData>> categoryDataFuture;
    private FutureExoCache<CategoryListKey, ListCategoryData, ServiceContext<ListCategoryData>> categoryListFuture;
    private FutureExoCache<ForumKey, ForumData, ServiceContext<ForumData>> forumDataFuture;
    private FutureExoCache<ForumListKey, ListForumData, ServiceContext<ListForumData>> forumListFuture;
    private FutureExoCache<PostKey, PostData, ServiceContext<PostData>> postDataFuture;
    private FutureExoCache<PostListKey, ListPostData, ServiceContext<ListPostData>> postListFuture;
    private FutureExoCache<PostListCountKey, SimpleCacheData<Integer>, ServiceContext<SimpleCacheData<Integer>>> postListCountFuture;
    private FutureExoCache<TopicKey, TopicData, ServiceContext<TopicData>> topicDataFuture;
    private FutureExoCache<TopicListKey, ListTopicData, ServiceContext<ListTopicData>> topicListFuture;
    private FutureExoCache<TopicListCountKey, SimpleCacheData<Integer>, ServiceContext<SimpleCacheData<Integer>>> topicListCountFuture;
    private FutureExoCache<UserProfileKey, UserProfileData, ServiceContext<UserProfileData>> userProfileDataFuture;
    private FutureExoCache<UserProfileListKey, ListUserProfileData, ServiceContext<ListUserProfileData>> userProfileListFuture;
    private FutureExoCache<UserProfileListCountKey, SimpleCacheData<Integer>, ServiceContext<SimpleCacheData<Integer>>> userProfileListCountFuture;
    private FutureExoCache<UserProfileKey, LoginUserProfileData, ServiceContext<LoginUserProfileData>> loginUserProfileFuture;
    private FutureExoCache<SimpleCacheKey, ListWatchData, ServiceContext<ListWatchData>> watchListDataFuture;
    private FutureExoCache<LinkListKey, ListLinkData, ServiceContext<ListLinkData>> linkListDataFuture;
    private FutureExoCache<SimpleCacheKey, SimpleCacheData, ServiceContext<SimpleCacheData>> miscDataFuture;
    private ForumStatistic statistic;

    public CachedDataStorage(CacheService service, JCRDataStorage storage) {
        this.storage = storage;
        this.service = service;
        this.completionService = (LifeCycleCompletionService)CommonsUtils.getService(LifeCycleCompletionService.class);
    }

    private void clearCategoryCache(String id) throws Exception {
        this.categoryData.remove((Serializable)new CategoryKey(id));
    }

    private void clearCategoryCache(Category category) throws Exception {
        if (category != null) {
            this.clearCategoryCache(category.getId());
            this.clearObjectCache(category, false);
        }
    }

    private void clearForumCache(Forum forum, boolean isPutNewKey) throws Exception {
        if (isPutNewKey) {
            this.forumData.put((Serializable)new ForumKey(forum), (Object)new ForumData(forum));
        } else {
            this.forumData.remove((Serializable)new ForumKey(forum));
        }
        this.statistic = null;
    }

    private void clearForumCache(String categoryId, String forumId, boolean isPutNewKey) throws Exception {
        Forum forum = this.getForum(categoryId, forumId);
        if (forum != null) {
            this.clearForumCache(forum, isPutNewKey);
        }
    }

    private void clearForumListCache() throws Exception {
        this.forumList.select((CachedObjectSelector)new ScopeCacheSelector());
    }

    private void clearPostListCache() throws Exception {
        this.postList.select((CachedObjectSelector)new ScopeCacheSelector());
    }

    private void clearPostListCountCache(String topicId) throws Exception {
        this.postListCount.select((CachedObjectSelector)new PostListCountSelector(topicId));
    }

    private void clearTopicListCache() throws Exception {
        this.topicList.select((CachedObjectSelector)new ScopeCacheSelector());
    }

    private void clearTopicListCache(String forumId) throws Exception {
        this.topicList.select((CachedObjectSelector)new TopicListSelector(forumId));
    }

    private void clearTopicListCountCache(String forumId) throws Exception {
        this.topicListCount.select((CachedObjectSelector)new TopicListCountSelector(forumId));
    }

    private void clearLinkListCache() throws Exception {
        this.linkListData.select((CachedObjectSelector)new ScopeCacheSelector());
    }

    private void clearMiscDataCache(String type) throws Exception {
        this.miscData.select((CachedObjectSelector)new MiscDataSelector(type));
    }

    private void clearTopicsCache(List<Topic> topics) throws Exception {
        for (Topic t : topics) {
            this.clearTopicCache(t);
        }
    }

    private void clearUserProfileListCache() throws Exception {
        if (this.userProfileList != null) {
            this.userProfileList.select((CachedObjectSelector)new ScopeCacheSelector());
        }
    }

    private void clearUserProfileListCountCache() throws Exception {
        if (this.userProfileListCount != null) {
            this.userProfileListCount.select((CachedObjectSelector)new ScopeCacheSelector());
        }
    }

    private void clearTopicCache(String topicPath) {
        try {
            Topic topic = this.getTopicByPath(topicPath, false);
            this.clearTopicCache(topic);
        }
        catch (Exception e) {
            LOG.warn((Object)("Can not clear topic cache for: " + topicPath));
        }
    }

    private void clearTopicCache(String categoryId, String forumId, String topicId) throws Exception {
        String topicPath = new StringBuffer(categoryId).append("/").append(forumId).append("/").append(topicId).toString();
        this.clearTopicCache(topicPath);
    }

    public void clearTopicCache(Topic topic) throws Exception {
        if (topic != null) {
            String topicPath = Utils.getSubPath((String)topic.getPath());
            this.topicData.remove((Serializable)new TopicKey(topicPath, true));
            this.topicData.remove((Serializable)new TopicKey(topicPath, false));
            this.topicData.remove((Serializable)new TopicKey(topicPath.toUpperCase(), false));
            this.objectNameData.remove((Serializable)new ObjectNameKey(topic.getId(), Utils.TOPIC));
        }
    }

    private void clearPostCache(String categoryId, String forumId, String topicId, String postId) throws Exception {
        this.postData.remove((Serializable)new PostKey(categoryId, forumId, topicId, postId));
    }

    private void clearObjectCache(Forum forum, boolean isPutNewKey) throws Exception {
        if (forum != null) {
            ForumData forumData = new ForumData(forum);
            String forumId = forum.getId();
            if (isPutNewKey) {
                this.objectNameData.put((Serializable)new ObjectNameKey(forumId, Utils.FORUM), (Object)forumData);
            } else {
                this.objectNameData.remove((Serializable)new ObjectNameKey(forumId, Utils.FORUM));
            }
        }
    }

    private void clearObjectCache(Category category, boolean isNew) throws Exception {
        if (isNew) {
            CategoryData categoryData = new CategoryData(category);
            this.objectNameData.put((Serializable)new ObjectNameKey(category.getId(), Utils.CATEGORY), (Object)categoryData);
        } else {
            this.objectNameData.remove((Serializable)new ObjectNameKey(category.getId(), Utils.CATEGORY));
        }
    }

    private void clearObjectCache(String categoryId, String forumId, boolean isPutNewKey) throws Exception {
        this.clearObjectCache(this.getForum(categoryId, forumId), isPutNewKey);
    }

    private void clearUserProfile(String userName) {
        if (!Utils.isEmpty((String)userName)) {
            UserProfileKey key = new UserProfileKey(userName);
            this.userProfileData.remove((Serializable)key);
            this.loginUserProfile.remove((Serializable)key);
        } else {
            this.userProfileData.clearCache();
            this.loginUserProfile.clearCache();
        }
    }

    public void refreshUserProfile(UserProfile profile) throws Exception {
        UserProfileKey key = new UserProfileKey(profile.getUserId());
        this.userProfileData.put((Serializable)key, (Object)new UserProfileData(profile));
    }

    private void clearWatchingItemCache(String watchingItemPath) throws Exception {
        String categoryId = Utils.getCategoryId((String)watchingItemPath);
        String forumId = Utils.getForumId((String)watchingItemPath);
        String topicPath = Utils.getTopicPath((String)watchingItemPath);
        if (!Utils.isEmpty((String)topicPath)) {
            this.clearTopicCache(topicPath);
        } else if (!Utils.isEmpty((String)forumId)) {
            this.clearForumCache(categoryId, forumId, false);
        } else if (!Utils.isEmpty((String)categoryId)) {
            this.clearCategoryCache(categoryId);
        }
    }

    public void start() {
        this.categoryData = CacheType.CATEGORY_DATA.getFromService(this.service);
        this.categoryList = CacheType.CATEGORY_LIST.getFromService(this.service);
        this.forumData = CacheType.FORUM_DATA.getFromService(this.service);
        this.forumList = CacheType.FORUM_LIST.getFromService(this.service);
        this.postData = CacheType.POST_DATA.getFromService(this.service);
        this.postList = CacheType.POST_LIST.getFromService(this.service);
        this.postListCount = CacheType.POST_LIST_COUNT.getFromService(this.service);
        this.topicData = CacheType.TOPIC_DATA.getFromService(this.service);
        this.topicList = CacheType.TOPIC_LIST.getFromService(this.service);
        this.topicListCount = CacheType.TOPIC_LIST_COUNT.getFromService(this.service);
        this.userProfileData = CacheType.USER_PROFILE_DATA.getFromService(this.service);
        this.userProfileList = CacheType.USER_PROFILE_LIST.getFromService(this.service);
        this.userProfileListCount = CacheType.USER_PROFILE_LIST_COUNT.getFromService(this.service);
        this.loginUserProfile = CacheType.LOGIN_USER_PROFILE.getFromService(this.service);
        this.objectNameData = CacheType.OBJECT_NAME_DATA.getFromService(this.service);
        this.miscData = CacheType.MISC_DATA.getFromService(this.service);
        this.watchListData = CacheType.WATCH_LIST_DATA.getFromService(this.service);
        this.linkListData = CacheType.LINK_LIST_DATA.getFromService(this.service);
        this.categoryDataFuture = CacheType.CATEGORY_DATA.createFutureCache(this.categoryData);
        this.categoryListFuture = CacheType.CATEGORY_LIST.createFutureCache(this.categoryList);
        this.forumDataFuture = CacheType.FORUM_DATA.createFutureCache(this.forumData);
        this.forumListFuture = CacheType.FORUM_LIST.createFutureCache(this.forumList);
        this.postDataFuture = CacheType.POST_DATA.createFutureCache(this.postData);
        this.postListFuture = CacheType.POST_LIST.createFutureCache(this.postList);
        this.postListCountFuture = CacheType.POST_LIST_COUNT.createFutureCache(this.postListCount);
        this.topicDataFuture = CacheType.TOPIC_DATA.createFutureCache(this.topicData);
        this.topicListFuture = CacheType.TOPIC_LIST.createFutureCache(this.topicList);
        this.topicListCountFuture = CacheType.TOPIC_LIST_COUNT.createFutureCache(this.topicListCount);
        this.userProfileDataFuture = CacheType.USER_PROFILE_DATA.createFutureCache(this.userProfileData);
        this.userProfileListFuture = CacheType.USER_PROFILE_LIST.createFutureCache(this.userProfileList);
        this.userProfileListCountFuture = CacheType.USER_PROFILE_LIST_COUNT.createFutureCache(this.userProfileListCount);
        this.loginUserProfileFuture = CacheType.LOGIN_USER_PROFILE.createFutureCache(this.loginUserProfile);
        this.watchListDataFuture = CacheType.WATCH_LIST_DATA.createFutureCache(this.watchListData);
        this.linkListDataFuture = CacheType.LINK_LIST_DATA.createFutureCache(this.linkListData);
        this.miscDataFuture = CacheType.MISC_DATA.createFutureCache(this.miscData);
    }

    public void stop() {
    }

    private ListLinkData buildLinkInput(List<ForumLinkData> links) {
        ArrayList<LinkData> data = new ArrayList<LinkData>();
        for (ForumLinkData l : links) {
            data.add(new LinkData(l));
        }
        return new ListLinkData(data);
    }

    private List<ForumLinkData> buildLinkOutput(ListLinkData data) {
        if (data == null) {
            return null;
        }
        ArrayList<ForumLinkData> out = new ArrayList<ForumLinkData>();
        for (LinkData d : data.getIds()) {
            out.add(d.build());
        }
        return out;
    }

    private ListWatchData buildWatchInput(List<Watch> watches) {
        ArrayList<WatchData> data = new ArrayList<WatchData>();
        for (Watch w : watches) {
            data.add(new WatchData(w));
        }
        return new ListWatchData(data);
    }

    private List<Watch> buildWatchOutput(ListWatchData data) {
        if (data == null) {
            return null;
        }
        ArrayList<Watch> out = new ArrayList<Watch>();
        for (WatchData d : data.getIds()) {
            out.add(d.build());
        }
        return out;
    }

    private ListPostData buildPostInput(List<Post> posts) {
        ArrayList<PostKey> data = new ArrayList<PostKey>();
        for (Post p : posts) {
            PostKey key = new PostKey(p);
            data.add(key);
        }
        return new ListPostData(data);
    }

    private List<Post> buildPostOutput(ListPostData data) {
        if (data == null) {
            return null;
        }
        ArrayList<Post> out = new ArrayList<Post>();
        for (PostKey k : data.getIds()) {
            try {
                out.add(this.getPost(k.getCategory(), k.getForum(), k.getTopic(), k.getPost()));
            }
            catch (Exception e) {
                LOG.error((Object)e);
            }
        }
        return out;
    }

    private ListForumData buildForumInput(List<Forum> forums) {
        ArrayList<ForumKey> keys = new ArrayList<ForumKey>();
        for (Forum f : forums) {
            keys.add(new ForumKey(f));
        }
        return new ListForumData(keys);
    }

    private List<Forum> buildForumOutput(ListForumData data) {
        if (data == null) {
            return null;
        }
        ArrayList<Forum> out = new ArrayList<Forum>();
        for (ForumKey k : data.getIds()) {
            out.add(this.getForum(k.getCategoryId(), k.getForumId()));
        }
        return out;
    }

    private ListCategoryData buildCategoryInput(List<Category> categories) {
        ArrayList<CategoryKey> keys = new ArrayList<CategoryKey>();
        for (Category c : categories) {
            keys.add(new CategoryKey(c));
        }
        return new ListCategoryData(keys);
    }

    private List<Category> buildCategoryOutput(ListCategoryData data) {
        if (data == null) {
            return null;
        }
        ArrayList<Category> out = new ArrayList<Category>();
        for (CategoryKey k : data.getIds()) {
            try {
                out.add(this.getCategory(k.getId()));
            }
            catch (Exception e) {
                LOG.error((Object)e);
            }
        }
        return out;
    }

    @ManagedDescription(value="repository for forum storage")
    @Managed
    public String getRepository() throws Exception {
        return this.storage.getRepository();
    }

    @ManagedDescription(value="workspace for the forum storage")
    @Managed
    public String getWorkspace() throws Exception {
        return this.storage.getWorkspace();
    }

    @ManagedDescription(value="data path for forum storage")
    @Managed
    public String getPath() throws Exception {
        return this.storage.getPath();
    }

    public void addPlugin(ComponentPlugin plugin) throws Exception {
        this.storage.addPlugin(plugin);
    }

    public void addRolePlugin(ComponentPlugin plugin) throws Exception {
        this.storage.addRolePlugin(plugin);
    }

    public void addInitialDataPlugin(ComponentPlugin plugin) throws Exception {
        this.storage.addInitialDataPlugin(plugin);
    }

    public void addInitialDefaultDataPlugin(ComponentPlugin plugin) throws Exception {
        this.storage.addInitialDefaultDataPlugin(plugin);
    }

    public void addDeletedUserCalculateListener() throws Exception {
        this.storage.addDeletedUserCalculateListener();
    }

    public void initCategoryListener() {
        this.storage.initCategoryListener();
    }

    public boolean isAdminRole(String userName) throws Exception {
        return this.storage.isAdminRole(userName);
    }

    public boolean isAdminRoleConfig(String userName) throws Exception {
        return this.storage.isAdminRoleConfig(userName);
    }

    public void setDefaultAvatar(String userName) {
        this.storage.setDefaultAvatar(userName);
        this.miscData.remove((Serializable)new SimpleCacheKey(USER_AVATAR_KEY, userName));
    }

    public ForumAttachment getUserAvatar(final String userName) throws Exception {
        SimpleCacheKey key = new SimpleCacheKey(USER_AVATAR_KEY, userName);
        return (ForumAttachment)((SimpleCacheData)this.miscDataFuture.get((Object)new ServiceContext<SimpleCacheData>(){

            public SimpleCacheData<ForumAttachment> execute() {
                try {
                    ForumAttachment got = CachedDataStorage.this.storage.getUserAvatar(userName);
                    return new SimpleCacheData((Object)got);
                }
                catch (Exception e) {
                    return new SimpleCacheData(null);
                }
            }
        }, (Object)key)).build();
    }

    public void saveUserAvatar(String userId, ForumAttachment fileAttachment) throws Exception {
        this.storage.saveUserAvatar(userId, fileAttachment);
        this.miscData.remove((Serializable)new SimpleCacheKey(USER_AVATAR_KEY, userId));
    }

    public void saveForumAdministration(ForumAdministration forumAdministration) throws Exception {
        this.storage.saveForumAdministration(forumAdministration);
    }

    public ForumAdministration getForumAdministration() throws Exception {
        return this.storage.getForumAdministration();
    }

    public SortSettings getForumSortSettings() {
        return this.storage.getForumSortSettings();
    }

    public SortSettings getTopicSortSettings() throws Exception {
        return this.storage.getTopicSortSettings();
    }

    public List<Category> getCategories() {
        return this.buildCategoryOutput((ListCategoryData)this.categoryListFuture.get((Object)new ServiceContext<ListCategoryData>(){

            public ListCategoryData execute() {
                return CachedDataStorage.this.buildCategoryInput(CachedDataStorage.this.storage.getCategories());
            }
        }, (Object)new CategoryListKey(null)));
    }

    public Category getCategory(final String categoryId) {
        return ((CategoryData)this.categoryDataFuture.get((Object)new ServiceContext<CategoryData>(){

            public CategoryData execute() {
                try {
                    Category got = CachedDataStorage.this.storage.getCategory(categoryId);
                    if (got != null) {
                        return new CategoryData(got);
                    }
                    return CategoryData.NULL;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }, (Object)new CategoryKey(categoryId))).build();
    }

    public Category getCategoryIncludedSpace() {
        return this.storage.getCategoryIncludedSpace();
    }

    public String[] getPermissionTopicByCategory(String categoryId, String type) throws Exception {
        return this.storage.getPermissionTopicByCategory(categoryId, type);
    }

    public void saveCategory(Category category, boolean isNew) throws Exception {
        this.storage.saveCategory(category, isNew);
        this.categoryList.select((CachedObjectSelector)new ScopeCacheSelector());
        this.clearLinkListCache();
        this.clearObjectCache(category, isNew);
        this.clearUserProfile(null);
        this.clearCategoryCache(category);
    }

    public void saveModOfCategory(List<String> moderatorCate, String userId, boolean isAdd) {
        this.storage.saveModOfCategory(moderatorCate, userId, isAdd);
        try {
            this.categoryData.select((CachedObjectSelector)new CategoryIdSelector(moderatorCate, this.categoryData));
        }
        catch (Exception e) {
            LOG.debug((Object)"Can not clear list categories in cached.", (Throwable)e);
        }
        this.clearUserProfile(null);
    }

    public void calculateModerator(String nodePath, boolean isNew) throws Exception {
        this.storage.calculateModerator(nodePath, isNew);
        this.clearForumCache(Utils.getCategoryId((String)nodePath), Utils.getForumId((String)nodePath), false);
        this.clearForumListCache();
        this.clearUserProfile(null);
    }

    public Category removeCategory(String categoryId) throws Exception {
        this.objectNameData.clearCache();
        this.categoryData.remove((Serializable)new CategoryKey(categoryId));
        this.categoryList.select((CachedObjectSelector)new ScopeCacheSelector());
        this.clearLinkListCache();
        this.clearUserProfile(null);
        return this.storage.removeCategory(categoryId);
    }

    @Deprecated
    public List<Forum> getForums(String categoryId, String strQuery) throws Exception {
        return this.getForums(new ForumFilter(categoryId, false).strQuery(strQuery));
    }

    @Deprecated
    public List<Forum> getForumSummaries(String categoryId, String strQuery) throws Exception {
        return this.getForums(new ForumFilter(categoryId, true).strQuery(strQuery));
    }

    public List<Forum> getForums(final ForumFilter filter) {
        SortSettings sort = this.storage.getForumSortSettings();
        SortSettings.SortField orderBy = sort.getField();
        SortSettings.Direction orderType = sort.getDirection();
        return this.buildForumOutput((ListForumData)this.forumListFuture.get((Object)new ServiceContext<ListForumData>(){

            public ListForumData execute() {
                try {
                    return CachedDataStorage.this.buildForumInput(CachedDataStorage.this.storage.getForums(filter));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }, (Object)new ForumListKey(filter, orderBy, orderType)));
    }

    public List<CategoryFilter> filterForumByName(String filterKey, String userName, int maxSize) throws Exception {
        return this.storage.filterForumByName(filterKey, userName, maxSize);
    }

    public Forum getForum(final String categoryId, final String forumId) {
        ForumData data = (ForumData)this.forumDataFuture.get((Object)new ServiceContext<ForumData>(){

            public ForumData execute() {
                Forum got = CachedDataStorage.this.storage.getForum(categoryId, forumId);
                if (got != null) {
                    return new ForumData(got);
                }
                return null;
            }
        }, (Object)new ForumKey(categoryId, forumId));
        return data != null ? data.build() : null;
    }

    public void modifyForum(Forum forum, int type) throws Exception {
        this.storage.modifyForum(forum, type);
        this.clearForumCache(forum, true);
        this.clearForumListCache();
        this.clearObjectCache(forum, true);
        this.clearMiscDataCache(FORUM_CAN_VIEW_KEY);
    }

    public void saveForum(String categoryId, Forum forum, boolean isNew) throws Exception {
        this.storage.saveForum(categoryId, forum, isNew);
        this.clearForumCache(forum, true);
        this.clearForumListCache();
        this.clearLinkListCache();
        this.clearObjectCache(forum, true);
        this.clearCategoryCache(categoryId);
        this.clearTopicListCache(forum.getId());
        this.clearTopicListCountCache(forum.getId());
        this.clearMiscDataCache(FORUM_CAN_VIEW_KEY);
        this.clearUserProfile(null);
    }

    public void saveModerateOfForums(List<String> forumPaths, String userName, boolean isDelete) throws Exception {
        this.storage.saveModerateOfForums(forumPaths, userName, isDelete);
        this.forumData.select((CachedObjectSelector)new ForumPathSelector(forumPaths.toArray(new String[forumPaths.size()]), this.forumData));
        this.clearForumListCache();
        for (String forumPath : forumPaths) {
            this.clearObjectCache(Utils.getCategoryId((String)forumPath), Utils.getForumId((String)forumPath), true);
        }
        this.clearMiscDataCache(FORUM_CAN_VIEW_KEY);
        this.clearUserProfile(null);
    }

    public Forum removeForum(String categoryId, String forumId) throws Exception {
        this.clearForumCache(categoryId, forumId, false);
        this.clearForumListCache();
        this.clearLinkListCache();
        this.clearObjectCache(categoryId, forumId, false);
        this.clearMiscDataCache(FORUM_CAN_VIEW_KEY);
        return this.storage.removeForum(categoryId, forumId);
    }

    public void moveForum(List<Forum> forums, String destCategoryPath) throws Exception {
        for (Forum forum : forums) {
            this.clearForumCache(forum, false);
            this.clearObjectCache(forum, false);
        }
        this.clearForumListCache();
        this.clearLinkListCache();
        this.clearMiscDataCache(FORUM_CAN_VIEW_KEY);
        this.clearUserProfile(null);
        this.storage.moveForum(forums, destCategoryPath);
        this.topicData.clearCache();
        this.postData.clearCache();
        this.objectNameData.clearCache();
        this.watchListData.clearCache();
        this.forumData.clearCache();
        this.clearForumListCache();
    }

    public JCRPageList getPageTopic(String categoryId, String forumId, String strQuery, String strOrderBy) throws Exception {
        return this.storage.getPageTopic(categoryId, forumId, strQuery, strOrderBy);
    }

    public LazyPageList<Topic> getTopicList(String categoryId, String forumId, String xpathConditions, String strOrderBy, int pageSize) throws Exception {
        return this.storage.getTopicList(categoryId, forumId, xpathConditions, strOrderBy, pageSize);
    }

    public List<Topic> getTopics(final TopicFilter filter, final int offset, final int limit) throws Exception {
        TopicListKey key = new TopicListKey(filter, offset, limit);
        ListTopicData data = (ListTopicData)this.topicListFuture.get((Object)new ServiceContext<ListTopicData>(){

            public ListTopicData execute() {
                try {
                    return CachedDataStorage.this.buildTopicInput(CachedDataStorage.this.storage.getTopics(filter, offset, limit));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }, (Object)key);
        return this.buildTopicOutput(data);
    }

    private ListTopicData buildTopicInput(List<Topic> topics) {
        ArrayList<TopicKey> data = new ArrayList<TopicKey>();
        for (Topic p : topics) {
            TopicKey key = new TopicKey(p);
            data.add(key);
            this.topicData.put((Serializable)key, (Object)new TopicData(p));
        }
        return new ListTopicData(data);
    }

    private List<Topic> buildTopicOutput(ListTopicData data) {
        if (data == null) {
            return null;
        }
        ArrayList<Topic> out = new ArrayList<Topic>();
        for (TopicKey k : data.getIds()) {
            try {
                out.add(this.getTopicByPath(k.getTopicPath(), false));
            }
            catch (Exception e) {
                LOG.error((Object)e);
            }
        }
        return out;
    }

    public int getTopicsCount(final TopicFilter filter) throws Exception {
        TopicListCountKey key = new TopicListCountKey(filter.toString(), filter.forumId());
        SimpleCacheData data = (SimpleCacheData)this.topicListCountFuture.get((Object)new ServiceContext<SimpleCacheData<Integer>>(){

            public SimpleCacheData<Integer> execute() {
                try {
                    return new SimpleCacheData((Object)CachedDataStorage.this.storage.getTopicsCount(filter));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }, (Object)key);
        return (Integer)data.build();
    }

    public List<Topic> getTopics(final String categoryId, final String forumId) throws Exception {
        TopicFilter filter = new TopicFilter(categoryId, forumId);
        filter.isAdmin(true);
        TopicListKey key = new TopicListKey(filter, 0, 0);
        ListTopicData data = (ListTopicData)this.topicListFuture.get((Object)new ServiceContext<ListTopicData>(){

            public ListTopicData execute() {
                try {
                    return CachedDataStorage.this.buildTopicInput(CachedDataStorage.this.storage.getTopics(categoryId, forumId));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }, (Object)key);
        return this.buildTopicOutput(data);
    }

    public Topic getTopic(String categoryId, String forumId, String topicId, String userRead) throws Exception {
        String topicPath = topicId;
        if (!Utils.isEmpty((String)categoryId)) {
            topicPath = categoryId + "/" + forumId + "/" + topicId;
        }
        return this.getTopicByPath(topicPath, false);
    }

    public Topic getTopicSummary(final String topicPath) {
        TopicData data = (TopicData)this.topicData.get((Serializable)new TopicKey(topicPath, false));
        if (data != null) {
            return this.getTopicPoll(data.build());
        }
        Topic got = ((TopicData)this.topicDataFuture.get((Object)new ServiceContext<TopicData>(){

            public TopicData execute() {
                try {
                    Topic got = CachedDataStorage.this.storage.getTopicSummary(topicPath);
                    if (got != null) {
                        return new TopicData(got);
                    }
                    return TopicData.NULL;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }, (Object)new TopicKey(Utils.getSubPath((String)topicPath.toUpperCase()), false))).build();
        return this.getTopicPoll(got);
    }

    public Topic getTopicSummary(String topicPath, boolean isLastPost) throws Exception {
        if (!isLastPost) {
            return this.getTopicSummary(topicPath);
        }
        return this.storage.getTopicSummary(topicPath, isLastPost);
    }

    public Topic getTopicByPath(final String topicPath, final boolean isLastPost) throws Exception {
        Topic got = ((TopicData)this.topicDataFuture.get((Object)new ServiceContext<TopicData>(){

            public TopicData execute() {
                try {
                    Topic got = CachedDataStorage.this.storage.getTopicByPath(topicPath, isLastPost);
                    if (got != null) {
                        return new TopicData(got);
                    }
                    return TopicData.NULL;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }, (Object)new TopicKey(topicPath, isLastPost))).build();
        return this.getTopicPoll(got);
    }

    public Topic getTopicUpdate(Topic topic, boolean isSummary) throws Exception {
        return this.storage.getTopicUpdate(topic, isSummary);
    }

    public List<Topic> getTopicsByDate(long date, String forumPath, int offset, int limit) throws Exception {
        return this.storage.getTopicsByDate(date, forumPath, offset, limit);
    }

    public JCRPageList getPageTopicOld(long date, String forumPatch) throws Exception {
        return this.storage.getPageTopicOld(date, forumPatch);
    }

    public List<Topic> getAllTopicsOld(long date, String forumPatch) throws Exception {
        return this.storage.getAllTopicsOld(date, forumPatch);
    }

    public long getTotalTopicOld(long date, String forumPatch) {
        return this.storage.getTotalTopicOld(date, forumPatch);
    }

    public JCRPageList getPageTopicByUser(String userName, boolean isMod, String strOrderBy) throws Exception {
        return this.storage.getPageTopicByUser(userName, isMod, strOrderBy);
    }

    public List<Topic> getTopicsByUser(final TopicFilter filter, final int offset, final int limit) throws Exception {
        TopicListKey key = new TopicListKey(filter, 0, 0);
        ListTopicData data = (ListTopicData)this.topicListFuture.get((Object)new ServiceContext<ListTopicData>(){

            public ListTopicData execute() {
                try {
                    return CachedDataStorage.this.buildTopicInput(CachedDataStorage.this.storage.getTopicsByUser(filter, offset, limit));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }, (Object)key);
        return this.buildTopicOutput(data);
    }

    public void modifyTopic(List<Topic> topics, int type) {
        this.storage.modifyTopic(topics, type);
        try {
            this.clearTopicsCache(topics);
            this.clearTopicListCache(topics.get(0).getForumId());
            this.clearTopicListCountCache(topics.get(0).getForumId());
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        if (type == 1 || type == 6 || type == 5 || type == 3) {
            for (Topic topic : topics) {
                try {
                    this.clearForumCache(topic.getCategoryId(), topic.getForumId(), false);
                }
                catch (Exception e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public void saveTopic(String categoryId, String forumId, Topic topic, boolean isNew, boolean isMove, MessageBuilder messageBuilder) throws Exception {
        this.storage.saveTopic(categoryId, forumId, topic, isNew, isMove, messageBuilder);
        this.clearForumCache(categoryId, forumId, false);
        this.clearForumListCache();
        this.clearTopicListCache(forumId);
        if (!isNew) {
            this.clearPostCache(categoryId, forumId, topic.getId(), topic.getId().replace(Utils.TOPIC, Utils.POST));
            this.clearTopicCache(topic);
        } else {
            this.clearTopicListCountCache(forumId);
            this.clearUserProfile(topic.getOwner());
        }
    }

    public Topic removeTopic(String categoryId, String forumId, String topicId) {
        try {
            this.clearForumCache(categoryId, forumId, false);
            this.clearForumListCache();
            this.clearTopicCache(categoryId, forumId, topicId);
            this.clearTopicListCountCache(forumId);
            this.clearTopicListCache(forumId);
            this.clearUserProfile(null);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return this.storage.removeTopic(categoryId, forumId, topicId);
    }

    public void moveTopic(List<Topic> topics, String destForumPath, String mailContent, String link) throws Exception {
        this.storage.moveTopic(topics, destForumPath, mailContent, link);
        if (topics != null && topics.size() > 0) {
            this.forumData.select((CachedObjectSelector)new ForumPathSelector(new String[]{Utils.getForumPath((String)topics.get(0).getPath()), destForumPath}, this.forumData));
            this.clearForumListCache();
            this.clearTopicListCache();
            this.clearTopicListCountCache(topics.get(0).getForumId());
            this.clearTopicListCountCache(Utils.getForumId((String)destForumPath));
            for (Topic topic : topics) {
                this.clearTopicCache(topic);
            }
            this.clearUserProfile(null);
        }
    }

    public long getLastReadIndex(String path, String isApproved, String isHidden, String userLogin) throws Exception {
        return this.storage.getLastReadIndex(path, isApproved, isHidden, userLogin);
    }

    public JCRPageList getPosts(String categoryId, String forumId, String topicId, String isApproved, String isHidden, String strQuery, String userLogin) throws Exception {
        return this.storage.getPosts(categoryId, forumId, topicId, isApproved, isHidden, strQuery, userLogin);
    }

    public long getAvailablePost(String categoryId, String forumId, String topicId, String isApproved, String isHidden, String userLogin) throws Exception {
        PostFilter filter = new PostFilter(categoryId, forumId, topicId, isApproved, isHidden, isHidden, userLogin);
        return this.storage.getPostsCount(filter);
    }

    public JCRPageList getPagePostByUser(String userName, String userId, boolean isMod, String strOrderBy) throws Exception {
        return this.storage.getPagePostByUser(userName, userId, isMod, strOrderBy);
    }

    public Post getPost(final String categoryId, final String forumId, final String topicId, final String postId) throws Exception {
        PostKey key = new PostKey(categoryId, forumId, topicId, postId);
        return ((PostData)this.postDataFuture.get((Object)new ServiceContext<PostData>(){

            public PostData execute() {
                try {
                    Post got = CachedDataStorage.this.storage.getPost(categoryId, forumId, topicId, postId);
                    if (got == null) {
                        return PostData.NULL;
                    }
                    return new PostData(got);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }, (Object)key)).build();
    }

    public void putPost(Post post) {
        PostKey key = new PostKey(post.getCategoryId(), post.getForumId(), post.getTopicId(), post.getId());
        this.postData.put((Serializable)key, (Object)new PostData(post));
    }

    public Post getPostFromCache(String categoryId, String forumId, String topicId, String postId) {
        PostKey key = new PostKey(categoryId, forumId, topicId, postId);
        PostData postCache = (PostData)this.postData.get((Serializable)key);
        if (postCache != null && postCache != PostData.NULL) {
            return postCache.build();
        }
        return null;
    }

    public JCRPageList getListPostsByIP(String ip, String strOrderBy) throws Exception {
        return this.storage.getListPostsByIP(ip, strOrderBy);
    }

    public void savePost(String categoryId, String forumId, String topicId, Post post, boolean isNew, MessageBuilder messageBuilder) throws Exception {
        this.storage.savePost(categoryId, forumId, topicId, post, isNew, messageBuilder);
        this.clearForumCache(categoryId, forumId, false);
        this.clearForumListCache();
        this.clearTopicCache(categoryId, forumId, topicId);
        this.clearTopicListCache(forumId);
        this.clearPostListCache();
        if (!isNew) {
            this.clearPostCache(categoryId, forumId, topicId, post.getId());
        } else {
            this.clearUserProfile(post.getOwner());
            this.clearPostListCountCache(topicId);
        }
        this.statistic = null;
    }

    public void modifyPost(List<Post> posts, int type) {
        this.storage.modifyPost(posts, type);
        try {
            this.clearPostListCache();
            Post p = posts.get(0);
            String categoryId = p.getCategoryId();
            String forumId = p.getForumId();
            String topicId = p.getTopicId();
            for (Post post : posts) {
                this.clearPostListCountCache(post.getTopicId());
                this.clearPostCache(categoryId, forumId, topicId, post.getId());
            }
            this.clearTopicCache(Utils.getTopicPath((String)p.getPath()));
            this.clearTopicListCache(forumId);
            this.clearTopicListCountCache(forumId);
            this.clearForumCache(categoryId, forumId, false);
            this.clearForumListCache();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public Post removePost(String categoryId, String forumId, String topicId, String postId) {
        try {
            Post post = this.getPost(categoryId, forumId, topicId, postId);
            this.clearUserProfile(post.getOwner());
            this.clearForumCache(categoryId, forumId, false);
            this.clearForumListCache();
            this.clearTopicCache(categoryId, forumId, topicId);
            this.clearPostCache(categoryId, forumId, topicId, postId);
            this.clearPostListCache();
            this.clearPostListCountCache(topicId);
            this.statistic = null;
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return this.storage.removePost(categoryId, forumId, topicId, postId);
    }

    public void addTag(List<Tag> tags, String userName, String topicPath) throws Exception {
        this.storage.addTag(tags, userName, topicPath);
        this.clearTopicCache(topicPath);
    }

    public void unTag(String tagId, String userName, String topicPath) {
        this.storage.unTag(tagId, userName, topicPath);
        this.clearTopicCache(topicPath);
    }

    public Tag getTag(String tagId) throws Exception {
        return this.storage.getTag(tagId);
    }

    public List<String> getTagNameInTopic(String userAndTopicId) throws Exception {
        return this.storage.getTagNameInTopic(userAndTopicId);
    }

    public List<String> getAllTagName(String keyValue, String userAndTopicId) throws Exception {
        return this.storage.getAllTagName(keyValue, userAndTopicId);
    }

    public List<Tag> getAllTags() throws Exception {
        return this.storage.getAllTags();
    }

    public List<Tag> getMyTagInTopic(String[] tagIds) throws Exception {
        return this.storage.getMyTagInTopic(tagIds);
    }

    public JCRPageList getTopicByMyTag(String userIdAndtagId, String strOrderBy) throws Exception {
        return this.storage.getTopicByMyTag(userIdAndtagId, strOrderBy);
    }

    public void saveTag(Tag newTag) throws Exception {
        this.storage.saveTag(newTag);
    }

    public JCRPageList getPageListUserProfile() throws Exception {
        return this.storage.getPageListUserProfile();
    }

    public JCRPageList searchUserProfile(String userSearch) throws Exception {
        return this.storage.searchUserProfile(userSearch);
    }

    public UserProfile getDefaultUserProfile(final String userName, final String ip) throws Exception {
        UserProfileKey key = new UserProfileKey(userName);
        return ((LoginUserProfileData)this.loginUserProfileFuture.get((Object)new ServiceContext<LoginUserProfileData>(){

            public LoginUserProfileData execute() {
                try {
                    UserProfile got = CachedDataStorage.this.storage.getDefaultUserProfile(userName, ip);
                    return new LoginUserProfileData(got);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }, (Object)key)).build();
    }

    public UserProfile updateUserProfileSetting(UserProfile userProfile) throws Exception {
        this.clearUserProfile(userProfile.getUserId());
        return this.storage.updateUserProfileSetting(userProfile);
    }

    public String getScreenName(final String userName) throws Exception {
        SimpleCacheKey key = new SimpleCacheKey(SCREEN_NAME_KEY, userName);
        return (String)((SimpleCacheData)this.miscDataFuture.get((Object)new ServiceContext<SimpleCacheData>(){

            public SimpleCacheData<Comparable> execute() {
                try {
                    String got = CachedDataStorage.this.storage.getScreenName(userName);
                    return new SimpleCacheData((Object)got);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }, (Object)key)).build();
    }

    public UserProfile getUserSettingProfile(String userName) throws Exception {
        return this.storage.getUserSettingProfile(userName);
    }

    public void saveUserSettingProfile(UserProfile userProfile) throws Exception {
        this.storage.saveUserSettingProfile(userProfile);
        this.miscData.remove((Serializable)new SimpleCacheKey(SCREEN_NAME_KEY, userProfile.getUserId()));
        this.clearUserProfile(userProfile.getUserId());
    }

    public UserProfile getLastPostIdRead(UserProfile userProfile, String isOfForum) throws Exception {
        return this.storage.getLastPostIdRead(userProfile, isOfForum);
    }

    public void saveLastPostIdRead(String userId, String[] lastReadPostOfForum, String[] lastReadPostOfTopic) throws Exception {
        this.completionService.addTask((Callable)new SaveLastPostIdRead(userId, lastReadPostOfForum, lastReadPostOfTopic));
    }

    public List<String> getUserModerator(String userName, boolean isModeCate) throws Exception {
        return this.storage.getUserModerator(userName, isModeCate);
    }

    public void saveUserModerator(String userName, List<String> ids, boolean isModeCate) throws Exception {
        this.storage.saveUserModerator(userName, ids, isModeCate);
    }

    public UserProfile getUserInfo(String userName) throws Exception {
        return this.storage.getUserInfo(userName);
    }

    public List<UserProfile> getQuickProfiles(List<String> userList) throws Exception {
        return this.storage.getQuickProfiles(userList);
    }

    public UserProfile getQuickProfile(final String userName) throws Exception {
        UserProfileKey key = new UserProfileKey(userName);
        return ((UserProfileData)this.userProfileDataFuture.get((Object)new ServiceContext<UserProfileData>(){

            public UserProfileData execute() {
                try {
                    UserProfile got = CachedDataStorage.this.storage.getQuickProfile(userName);
                    return new UserProfileData(got);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }, (Object)key)).build();
    }

    public UserProfile getUserInformations(UserProfile userProfile) throws Exception {
        return this.storage.getUserInformations(userProfile);
    }

    public void saveUserProfile(UserProfile newUserProfile, boolean isOption, boolean isBan) throws Exception {
        this.clearUserProfile(newUserProfile.getUserId());
        this.clearUserProfileListCache();
        this.clearUserProfileListCountCache();
        this.storage.saveUserProfile(newUserProfile, isOption, isBan);
    }

    public UserProfile getUserProfileManagement(String userName) throws Exception {
        return this.storage.getUserProfileManagement(userName);
    }

    public void saveUserBookmark(String userName, String bookMark, boolean isNew) throws Exception {
        this.storage.saveUserBookmark(userName, bookMark, isNew);
        this.clearUserProfile(userName);
    }

    public void saveCollapsedCategories(String userName, String categoryId, boolean isAdd) throws Exception {
        this.storage.saveCollapsedCategories(userName, categoryId, isAdd);
    }

    public void saveReadMessage(String messageId, String userName, String type) throws Exception {
        this.storage.saveReadMessage(messageId, userName, type);
        this.miscData.remove((Serializable)new SimpleCacheKey(PRIVATE_MESSAGE_COUNT_KEY, userName));
    }

    public JCRPageList getPrivateMessage(String userName, String type) throws Exception {
        return this.storage.getPrivateMessage(userName, type);
    }

    public long getNewPrivateMessage(final String userName) throws Exception {
        SimpleCacheKey key = new SimpleCacheKey(PRIVATE_MESSAGE_COUNT_KEY, userName);
        return (Long)((SimpleCacheData)this.miscDataFuture.get((Object)new ServiceContext<SimpleCacheData>(){

            public SimpleCacheData<Comparable> execute() {
                try {
                    Long got = CachedDataStorage.this.storage.getNewPrivateMessage(userName);
                    return new SimpleCacheData((Object)got);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }, (Object)key)).build();
    }

    public void savePrivateMessage(ForumPrivateMessage privateMessage) throws Exception {
        this.storage.savePrivateMessage(privateMessage);
        this.miscData.remove((Serializable)new SimpleCacheKey(PRIVATE_MESSAGE_COUNT_KEY, privateMessage.getSendTo()));
    }

    public void removePrivateMessage(String messageId, String userName, String type) throws Exception {
        this.storage.removePrivateMessage(messageId, userName, type);
        this.miscData.remove((Serializable)new SimpleCacheKey(PRIVATE_MESSAGE_COUNT_KEY, userName));
    }

    public ForumSubscription getForumSubscription(String userId) {
        return this.storage.getForumSubscription(userId);
    }

    public void saveForumSubscription(ForumSubscription forumSubscription, String userId) throws Exception {
        this.storage.saveForumSubscription(forumSubscription, userId);
    }

    public ForumStatistic getForumStatistic() throws Exception {
        if (this.statistic != null) {
            return this.statistic;
        }
        this.statistic = this.storage.getForumStatistic();
        return this.statistic;
    }

    public void saveForumStatistic(ForumStatistic forumStatistic) throws Exception {
        this.storage.saveForumStatistic(forumStatistic);
    }

    public Object getObjectNameByPath(String path) throws Exception {
        String type = Utils.getObjectType((String)path);
        String id = Utils.getIdByType((String)path, (String)type);
        ObjectNameKey key = new ObjectNameKey(id, type);
        CachedData data = (CachedData)this.objectNameData.get((Serializable)key);
        if (data == null) {
            Object got = this.storage.getObjectNameByPath(path);
            return this.getObjectNameByKey(got, key);
        }
        Object got = data.build();
        String sPath = this.getPath(got);
        if (path.indexOf(sPath) < 0) {
            return null;
        }
        if (got instanceof Topic) {
            return this.getTopicPoll((Topic)got);
        }
        return got;
    }

    private Object getObjectNameByKey(Object got, ObjectNameKey key) throws Exception {
        if (got instanceof Post) {
            this.objectNameData.put((Serializable)key, (Object)new PostData((Post)got));
        } else if (got instanceof Topic) {
            this.objectNameData.put((Serializable)key, (Object)new TopicData((Topic)got));
        } else if (got instanceof Forum) {
            this.objectNameData.put((Serializable)key, (Object)new ForumData((Forum)got));
        } else if (got instanceof Category) {
            this.objectNameData.put((Serializable)key, (Object)new CategoryData((Category)got));
        } else if (got instanceof Tag) {
            this.objectNameData.put((Serializable)key, (Object)new TagData((Tag)got));
        }
        return got;
    }

    private String getPath(Object got) {
        String path = null;
        if (got instanceof Post) {
            path = ((Post)got).getPath();
        } else if (got instanceof Topic) {
            path = ((Topic)got).getPath();
        } else if (got instanceof Forum) {
            path = ((Forum)got).getPath();
        } else if (got instanceof Category) {
            path = ((Category)got).getPath();
        } else if (got instanceof Tag) {
            path = ((Tag)got).getId();
        }
        return Utils.getSubPath((String)path);
    }

    public Object getObjectNameById(String id, String type) throws Exception {
        ObjectNameKey key = new ObjectNameKey(id, type);
        CachedData data = (CachedData)this.objectNameData.get((Serializable)key);
        if (data == null) {
            Object got = this.storage.getObjectNameById(id, type);
            return this.getObjectNameByKey(got, key);
        }
        Object object = data.build();
        if (object instanceof Topic) {
            return this.getTopicPoll((Topic)object);
        }
        return object;
    }

    private Topic getTopicPoll(Topic topic) {
        if (topic != null) {
            topic.setIsPoll(this.topicHasPoll(topic.getPath()));
        }
        return topic;
    }

    public List<ForumLinkData> getAllLink(final String strQueryCate, final String strQueryForum) throws Exception {
        LinkListKey key = new LinkListKey(strQueryCate, strQueryForum);
        return this.buildLinkOutput((ListLinkData)this.linkListDataFuture.get((Object)new ServiceContext<ListLinkData>(){

            public ListLinkData execute() {
                try {
                    List got = CachedDataStorage.this.storage.getAllLink(strQueryCate, strQueryForum);
                    return CachedDataStorage.this.buildLinkInput(got);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }, (Object)key));
    }

    public List<ForumSearchResult> getQuickSearch(String textQuery, String type_, String pathQuery, String userId, List<String> listCateIds, List<String> listForumIds, List<String> forumIdsOfModerator) throws Exception {
        return this.storage.getQuickSearch(textQuery, type_, pathQuery, userId, listCateIds, listForumIds, forumIdsOfModerator);
    }

    public List<ForumSearchResult> getAdvancedSearch(ForumEventQuery eventQuery, List<String> listCateIds, List<String> listForumIds) {
        return this.storage.getAdvancedSearch(eventQuery, listCateIds, listForumIds);
    }

    public void addWatch(int watchType, String path, List<String> values, String currentUser) throws Exception {
        this.storage.addWatch(watchType, path, values, currentUser);
        this.watchListData.remove((Serializable)new SimpleCacheKey(WATCH_TYPE, currentUser));
        this.clearWatchingItemCache(path);
    }

    public void removeWatch(int watchType, String path, String values) throws Exception {
        this.storage.removeWatch(watchType, path, values);
        this.watchListData.select((CachedObjectSelector)new ScopeCacheSelector());
        this.clearWatchingItemCache(path);
    }

    public void updateEmailWatch(List<String> listNodeId, String newEmailAdd, String userId) throws Exception {
        this.storage.updateEmailWatch(listNodeId, newEmailAdd, userId);
        this.watchListData.remove((Serializable)new SimpleCacheKey(WATCH_TYPE, userId));
        for (String id : listNodeId) {
            if (id.contains(Utils.CATEGORY)) {
                this.categoryData.remove((Serializable)new CategoryKey(id));
                continue;
            }
            if (id.contains(Utils.FORUM)) {
                this.forumData.remove((Serializable)new ForumKey((Forum)this.getObjectNameById(id, Utils.FORUM)));
                continue;
            }
            if (!id.contains(Utils.TOPIC)) continue;
            Topic topic = (Topic)this.getObjectNameById(id, Utils.TOPIC);
            this.clearTopicCache(topic);
        }
    }

    public List<Watch> getWatchByUser(final String userId) throws Exception {
        SimpleCacheKey key = new SimpleCacheKey(WATCH_TYPE, userId);
        return this.buildWatchOutput((ListWatchData)this.watchListDataFuture.get((Object)new ServiceContext<ListWatchData>(){

            public ListWatchData execute() {
                try {
                    List got = CachedDataStorage.this.storage.getWatchByUser(userId);
                    return CachedDataStorage.this.buildWatchInput(got);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }, (Object)key));
    }

    public void updateForum(String path) throws Exception {
        this.storage.updateForum(path);
    }

    public SendMessageInfo getMessageInfo(String name) throws Exception {
        return this.storage.getMessageInfo(name);
    }

    public Iterator<SendMessageInfo> getPendingMessages() throws Exception {
        return this.storage.getPendingMessages();
    }

    public List<ForumSearchResult> getJobWattingForModerator(String[] paths) {
        return this.storage.getJobWattingForModerator(paths);
    }

    public int getJobWattingForModeratorByUser(String userId) throws Exception {
        return this.storage.getJobWattingForModeratorByUser(userId);
    }

    public NodeIterator search(String queryString) throws Exception {
        return this.storage.search(queryString);
    }

    public void evaluateActiveUsers(String query) {
        this.storage.evaluateActiveUsers(query);
    }

    public Object exportXML(String categoryId, String forumId, List<String> objectIds, String nodePath, ByteArrayOutputStream bos, boolean isExportAll) throws Exception {
        return this.storage.exportXML(categoryId, forumId, objectIds, nodePath, bos, isExportAll);
    }

    public void importXML(String nodePath, ByteArrayInputStream bis, int typeImport) throws Exception {
        this.storage.importXML(nodePath, bis, typeImport);
        this.categoryList.select((CachedObjectSelector)new ScopeCacheSelector());
        this.forumList.select((CachedObjectSelector)new ScopeCacheSelector());
        this.forumData.select((CachedObjectSelector)new ScopeCacheSelector());
    }

    public void updateTopicAccess(String userId, String topicId) {
        this.storage.updateTopicAccess(userId, topicId);
        this.clearUserProfile(userId);
    }

    public void updateForumAccess(String userId, String forumId) {
        this.storage.updateForumAccess(userId, forumId);
        this.clearUserProfile(userId);
    }

    public void writeReads() {
        this.storage.writeReads();
    }

    public List<String> getBookmarks(String userName) throws Exception {
        return this.storage.getBookmarks(userName);
    }

    public List<String> getBanList() throws Exception {
        return this.storage.getBanList();
    }

    public boolean isBanIp(String ip) throws Exception {
        return this.storage.isBanIp(ip);
    }

    public boolean addBanIP(String ip) throws Exception {
        return this.storage.addBanIP(ip);
    }

    public void removeBan(String ip) throws Exception {
        this.storage.removeBan(ip);
    }

    public List<String> getForumBanList(String forumId) throws Exception {
        return this.storage.getForumBanList(forumId);
    }

    public boolean addBanIPForum(String ip, String forumId) throws Exception {
        Forum forum = this.getForum(forumId.split("/")[0], forumId.split("/")[1]);
        this.clearForumCache(forum, false);
        this.clearForumListCache();
        this.clearLinkListCache();
        this.clearObjectCache(forum, false);
        return this.storage.addBanIPForum(ip, forumId);
    }

    public void removeBanIPForum(String ip, String forumId) throws Exception {
        Forum forum = this.getForum(forumId.split("/")[0], forumId.split("/")[1]);
        this.clearForumCache(forum, false);
        this.clearForumListCache();
        this.clearLinkListCache();
        this.clearObjectCache(forum, false);
        this.storage.removeBanIPForum(ip, forumId);
    }

    public void updateStatisticCounts(long topicCount, long postCount) throws Exception {
        this.storage.updateStatisticCounts(topicCount, postCount);
    }

    public PruneSetting getPruneSetting(String forumPath) throws Exception {
        return this.storage.getPruneSetting(forumPath);
    }

    public List<PruneSetting> getAllPruneSetting() throws Exception {
        return this.storage.getAllPruneSetting();
    }

    public void savePruneSetting(PruneSetting pruneSetting) throws Exception {
        this.storage.savePruneSetting(pruneSetting);
    }

    public void runPrune(String forumPath) throws Exception {
        this.storage.runPrune(forumPath);
        this.clearRunPrune(forumPath);
    }

    private void clearRunPrune(String forumPath) throws Exception {
        String forumId = Utils.getForumId((String)forumPath);
        this.clearForumCache(Utils.getCategoryId((String)forumPath), forumId, false);
        this.clearTopicListCache(forumId);
        this.clearTopicListCountCache(forumId);
    }

    public void runPrune(PruneSetting pSetting) throws Exception {
        this.storage.runPrune(pSetting);
        String forumPath = pSetting.getForumPath();
        this.clearRunPrune(forumPath);
    }

    public long checkPrune(PruneSetting pSetting) throws Exception {
        return this.storage.checkPrune(pSetting);
    }

    public boolean populateUserProfile(User user, UserProfile profileTemplate, boolean isNew) throws Exception {
        boolean isAdded = this.storage.populateUserProfile(user, profileTemplate, isNew);
        if (isAdded) {
            this.clearUserProfileListCache();
            this.clearUserProfileListCountCache();
        }
        return isAdded;
    }

    public boolean deleteUserProfile(String userId) throws Exception {
        this.clearUserProfile(userId);
        this.clearUserProfileListCache();
        this.clearUserProfileListCountCache();
        this.clearAllForumCache();
        return this.storage.deleteUserProfile(userId);
    }

    private void clearAllForumCache() {
        this.postData.clearCache();
        this.postList.clearCache();
        this.topicData.clearCache();
        this.forumData.clearCache();
        this.forumList.clearCache();
        this.categoryData.clearCache();
        this.categoryList.clearCache();
        this.miscData.clearCache();
        this.watchListData.clearCache();
    }

    public void processEnabledUser(String userName, String email, boolean isEnabled) {
        this.storage.processEnabledUser(userName, email, isEnabled);
        this.clearAllForumCache();
        this.clearUserProfile(userName);
        try {
            this.clearUserProfileListCache();
            this.clearUserProfileListCountCache();
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to clear user cached.");
        }
    }

    public void calculateDeletedUser(String userName) throws Exception {
        this.storage.calculateDeletedUser(userName);
        this.clearAllForumCache();
    }

    public void calculateDeletedGroup(String groupId, String groupName) throws Exception {
        this.storage.calculateDeletedGroup(groupId, groupName);
        this.topicData.select((CachedObjectSelector)new ScopeCacheSelector());
        this.topicList.select((CachedObjectSelector)new ScopeCacheSelector());
        this.forumData.select((CachedObjectSelector)new ScopeCacheSelector());
        this.forumList.select((CachedObjectSelector)new ScopeCacheSelector());
        this.categoryData.select((CachedObjectSelector)new ScopeCacheSelector());
        this.categoryList.select((CachedObjectSelector)new ScopeCacheSelector());
    }

    public void initDataPlugin() throws Exception {
        this.storage.initDataPlugin();
    }

    public void initDefaultData() throws Exception {
        this.storage.initDefaultData();
    }

    public List<RoleRulesPlugin> getRulesPlugins() {
        return this.storage.getRulesPlugins();
    }

    public List<InitializeForumPlugin> getDefaultPlugins() {
        return this.storage.getDefaultPlugins();
    }

    public void initAutoPruneSchedules() throws Exception {
        this.storage.initAutoPruneSchedules();
    }

    public void updateLastLoginDate(String userId) throws Exception {
        this.storage.updateLastLoginDate(userId);
    }

    public String getLatestUser() throws Exception {
        return this.storage.getLatestUser();
    }

    public List<Post> getNewPosts(int number) throws Exception {
        return this.storage.getNewPosts(number);
    }

    public List<Post> getRecentPostsForUser(String userName, int number) throws Exception {
        return this.storage.getRecentPostsForUser(userName, number);
    }

    public Map<String, String> getServerConfig() {
        return this.storage.getServerConfig();
    }

    public KSDataLocation getDataLocation() {
        return this.storage.getDataLocation();
    }

    public void setViewCountTopic(String path, String userRead) {
        this.storage.setViewCountTopic(path, userRead);
    }

    public void writeViews() {
        this.storage.writeViews();
    }

    public JCRPageList getPostForSplitTopic(String topicPath) throws Exception {
        return this.storage.getPostForSplitTopic(topicPath);
    }

    public void movePost(String[] postPaths, String destTopicPath, boolean isCreatNewTopic, String mailContent, String link) throws Exception {
        this.storage.movePost(postPaths, destTopicPath, isCreatNewTopic, mailContent, link);
        String srcTopicPath = Utils.getTopicPath((String)postPaths[0]);
        this.forumData.select((CachedObjectSelector)new ForumPathSelector(new String[]{Utils.getForumPath((String)srcTopicPath), Utils.getForumPath((String)destTopicPath)}, this.forumData));
        this.clearForumListCache();
        this.clearTopicCache(srcTopicPath);
        this.clearTopicCache(destTopicPath);
        this.clearPostListCache();
        this.clearPostListCountCache(srcTopicPath);
        this.clearPostListCountCache(destTopicPath);
        this.clearUserProfile(null);
    }

    public void mergeTopic(String srcTopicPath, String destTopicPath, String mailContent, String link) throws Exception {
        this.clearTopicCache(Utils.getCategoryId((String)srcTopicPath), Utils.getForumId((String)srcTopicPath), Utils.getTopicId((String)srcTopicPath));
        this.storage.mergeTopic(srcTopicPath, destTopicPath, mailContent, link);
        this.clearPostListCache();
        this.clearPostListCountCache(Utils.getTopicId((String)destTopicPath));
        this.clearTopicCache(destTopicPath);
        this.clearForumCache(Utils.getCategoryId((String)destTopicPath), Utils.getForumId((String)destTopicPath), false);
        this.clearTopicListCache();
        this.clearTopicListCountCache(Utils.getForumId((String)destTopicPath));
        this.clearUserProfile(null);
    }

    public void splitTopic(Topic newTopic, Post fistPost, List<String> postPathMove, String mailContent, String link) throws Exception {
        this.storage.splitTopic(newTopic, fistPost, postPathMove, mailContent, link);
        String oldTopicPath = Utils.getTopicPath((String)postPathMove.get(0));
        this.clearPostListCache();
        this.clearPostListCountCache(Utils.getTopicId((String)oldTopicPath));
        this.clearTopicCache(oldTopicPath);
        this.clearForumCache(Utils.getCategoryId((String)oldTopicPath), Utils.getForumId((String)oldTopicPath), false);
        this.clearTopicListCache(Utils.getForumId((String)oldTopicPath));
        this.clearTopicListCountCache(Utils.getForumId((String)oldTopicPath));
    }

    public void updateUserProfileInfo(String name) throws Exception {
        this.clearUserProfile(name);
        this.storage.updateUserProfileInfo(name);
    }

    public InputStream createForumRss(String objectId, String link) throws Exception {
        return this.storage.createForumRss(objectId, link);
    }

    public InputStream createUserRss(String userId, String link) throws Exception {
        return this.storage.createUserRss(userId, link);
    }

    public List<Post> getPosts(final PostFilter filter, final int offset, final int limit) throws Exception {
        PostListKey key = new PostListKey(filter, offset, limit);
        return this.buildPostOutput((ListPostData)this.postListFuture.get((Object)new ServiceContext<ListPostData>(){

            public ListPostData execute() {
                try {
                    List got = CachedDataStorage.this.storage.getPosts(filter, offset, limit);
                    return CachedDataStorage.this.buildPostInput(got);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }, (Object)key));
    }

    public int getPostsCount(final PostFilter filter) throws Exception {
        PostListCountKey key = new PostListCountKey("postsCount", filter.toString(), filter.getTopicId());
        SimpleCacheData data = (SimpleCacheData)this.postListCountFuture.get((Object)new ServiceContext<SimpleCacheData<Integer>>(){

            public SimpleCacheData<Integer> execute() {
                try {
                    return new SimpleCacheData((Object)CachedDataStorage.this.storage.getPostsCount(filter));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }, (Object)key);
        return (Integer)data.build();
    }

    public void saveActivityIdForOwner(String ownerId, String type, String activityId) {
        this.storage.saveActivityIdForOwner(ownerId, type, activityId);
    }

    public void saveActivityIdForOwner(String ownerPath, String activityId) {
        this.storage.saveActivityIdForOwner(ownerPath, activityId);
    }

    public String getActivityIdForOwner(String ownerId, String type) {
        return this.storage.getActivityIdForOwner(ownerId, type);
    }

    public String getActivityIdForOwner(String ownerPath) {
        return this.storage.getActivityIdForOwner(ownerPath);
    }

    public boolean topicHasPoll(String topicPath) {
        return this.storage.topicHasPoll(topicPath);
    }

    public List<ForumSearchResult> getUnifiedSearch(String textQuery, String userId, Integer offset, Integer limit, String sort, String order) throws Exception {
        return this.storage.getUnifiedSearch(textQuery, userId, offset, limit, sort, order);
    }

    public List<String> getForumUserCanView(final List<String> listOfUser, final List<String> listForumIds) throws Exception {
        String key = "user_gest_uoom";
        if (listOfUser != null && !listOfUser.isEmpty()) {
            key = listOfUser.toString();
        }
        if (listForumIds != null && !listForumIds.isEmpty()) {
            key = key + listForumIds.toString();
        }
        SimpleCacheKey canViewKey = new SimpleCacheKey(FORUM_CAN_VIEW_KEY, key);
        return (List)((SimpleCacheData)this.miscDataFuture.get((Object)new ServiceContext<SimpleCacheData>(){

            public SimpleCacheData<List<String>> execute() {
                try {
                    List got = CachedDataStorage.this.storage.getForumUserCanView(listOfUser, listForumIds);
                    return new SimpleCacheData((Object)got);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }, (Object)canViewKey)).build();
    }

    public List<UserProfile> searchUserProfileByFilter(final UserProfileFilter userProfileFilter, final int offset, final int limit) throws Exception {
        UserProfileListKey key = new UserProfileListKey(userProfileFilter, offset, limit);
        ListUserProfileData data = (ListUserProfileData)this.userProfileListFuture.get((Object)new ServiceContext<ListUserProfileData>(){

            public ListUserProfileData execute() {
                try {
                    return CachedDataStorage.this.buildUserProfileInput(CachedDataStorage.this.storage.searchUserProfileByFilter(userProfileFilter, offset, limit));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }, (Object)key);
        return this.buildUserProfileOutput(data);
    }

    public int getUserProfileByFilterCount(final UserProfileFilter userProfileFilter) throws Exception {
        UserProfileListCountKey key = new UserProfileListCountKey(userProfileFilter);
        SimpleCacheData data = (SimpleCacheData)this.userProfileListCountFuture.get((Object)new ServiceContext<SimpleCacheData<Integer>>(){

            public SimpleCacheData<Integer> execute() {
                try {
                    return new SimpleCacheData((Object)CachedDataStorage.this.storage.getUserProfileByFilterCount(userProfileFilter));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }, (Object)key);
        return (Integer)data.build();
    }

    private ListUserProfileData buildUserProfileInput(List<UserProfile> userProfiles) {
        ArrayList<UserProfileKey> listKeys = new ArrayList<UserProfileKey>();
        for (UserProfile p : userProfiles) {
            UserProfileKey key = new UserProfileKey(p.getUserId());
            listKeys.add(key);
        }
        return new ListUserProfileData(listKeys);
    }

    private List<UserProfile> buildUserProfileOutput(ListUserProfileData data) {
        if (data == null) {
            return null;
        }
        ArrayList<UserProfile> out = new ArrayList<UserProfile>();
        for (UserProfileKey k : data.getIds()) {
            try {
                out.add(this.getQuickProfile(k.getUserId()));
            }
            catch (Exception e) {
                LOG.error((Object)e);
            }
        }
        return out;
    }

    public void removeCacheUserProfile(String userName) {
        this.clearUserProfile(userName);
    }

    public void saveUserPrivateOfCategory(String categoryId, String priInfo) {
        this.storage.saveUserPrivateOfCategory(categoryId, priInfo);
    }

    class SaveLastPostIdRead
    implements Callable<Boolean> {
        private String userId;
        private String[] lastReadPostOfForum;
        private String[] lastReadPostOfTopic;

        public SaveLastPostIdRead(String userId, String[] lastReadPostOfForum, String[] lastReadPostOfTopic) {
            this.userId = userId;
            this.lastReadPostOfTopic = lastReadPostOfTopic;
            this.lastReadPostOfForum = lastReadPostOfForum;
        }

        @Override
        public Boolean call() throws Exception {
            CachedDataStorage.this.storage.saveLastPostIdRead(this.userId, this.lastReadPostOfForum, this.lastReadPostOfTopic);
            return true;
        }
    }
}

