/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.service;

import java.lang.reflect.Method;
import java.util.Map;
import javax.servlet.ServletContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.cs.service.CSSpaceApplicationHandler;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.mop.page.PageService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.SpaceApplicationConfigPlugin;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.picocontainer.Startable;

public class CSHandlerStarter
implements Startable {
    private static final Log LOG = ExoLogger.getLogger(CSHandlerStarter.class);
    private PortalContainer container;
    private SpaceApplicationConfigPlugin spaceApplicationConfigPlugin;

    public CSHandlerStarter(PortalContainer container) {
        this.container = container;
    }

    public void start() {
        LOG.info((Object)"Add specific Space handler when container finishes starting");
        PortalContainer.addInitTask((ServletContext)this.container.getPortalContext(), (RootContainer.PortalContainerInitTask)new RootContainer.PortalContainerPostInitTask(){

            public void execute(ServletContext context, PortalContainer portalContainer) {
                CSHandlerStarter.this.addHandlerToSpaceService();
            }
        });
    }

    public void stop() {
    }

    public void addHandlerToSpaceService() {
        try {
            SpaceService spaceService = this.getService(SpaceService.class);
            Method spaceSpaceApplicationHandler = spaceService.getClass().getDeclaredMethod("getSpaceApplicationHandlers", new Class[0]);
            spaceSpaceApplicationHandler.setAccessible(true);
            if (this.spaceApplicationConfigPlugin == null) {
                throw new IllegalStateException("CS Space config is not loaded");
            }
            Map map = (Map)spaceSpaceApplicationHandler.invoke((Object)spaceService, new Object[0]);
            if (!map.containsKey("CSSpace")) {
                LOG.info((Object)"Add specific Space handler");
                CSSpaceApplicationHandler appHandler = new CSSpaceApplicationHandler(this.getService(SpaceService.class), this.getService(DataStorage.class), this.getService(PageService.class), this.getService(UserPortalConfigService.class));
                appHandler.setSpaceApplicationConfigPlugin(this.spaceApplicationConfigPlugin);
                map.put("CSSpace", appHandler);
            }
        }
        catch (Exception e) {
            LOG.error((Object)e);
            throw new IllegalStateException("Can't set specific handler", e);
        }
    }

    public void setSpaceApplicationConfigPlugin(SpaceApplicationConfigPlugin spaceApplicationConfigPlugin) {
        LOG.info((Object)"Load CS Space config");
        this.spaceApplicationConfigPlugin = spaceApplicationConfigPlugin;
    }

    public <T> T getService(Class<T> clazz) {
        return (T)this.container.getComponentInstanceOfType(clazz);
    }
}

