package org.exoplatform.cs.dao;

import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.cs.dto.LogType;
import org.exoplatform.cs.entity.LogEntity;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

import java.util.Calendar;
import java.util.List;

/**
 * Created by IntelliJ IDEA.
 * User: ali
 * Date: 06/01/17
 * Time: 12:15
 */
public class LogDAO extends GenericDAOJPAImpl<LogEntity, String> {
private static final Logger LOG = LoggerFactory.getLogger(LogDAO.class);

    public List<LogEntity> getupdates(Calendar from, Calendar to) {
        return getEntityManager().createNamedQuery("logEntity.getTicketsUpdatesBetweenDates", LogEntity.class).setParameter("from", from).setParameter("to", to).getResultList();

    }

    public List<LogEntity> getLogsByTicketAndStatus(String topicId, List<String> status) {
        return getEntityManager().createNamedQuery("logEntity.getLogsByTicketAndStatus", LogEntity.class)
                .setParameter("topicId", topicId)
                .setParameter("type", LogType.TICKET_STATUS_CHANGED)
                .setParameter("status", status).getResultList();

    }

    public List<LogEntity> getLogsByNewValue(String newValue) {
        return getEntityManager().createNamedQuery("logEntity.getLogsByNewValue", LogEntity.class)
                .setParameter("newValue", newValue).getResultList();

    }

    public Double getTimeToFirstResponseAvgBetweenDates(Calendar from, Calendar to) {

        try {
            return getEntityManager().createNamedQuery("logEntity.getTimeToFirstResponseAvgBetweenDates", Double.class)
                .setParameter("from", from)
                .setParameter("to", to)
                .setParameter("type", LogType.TIME_TO_FIRST_RESPONSE_ADDED)
                .getSingleResult();
/*    }  catch (NullPointerException e) {
        return 0;*/
    }   catch (Exception e) {
        LOG.warn("Exception while attempting to get request", e);
        throw e;
    }

    }

    public Double getTimeToResolutionAvgBetweenDates(Calendar from, Calendar to) {
        try {
        return getEntityManager().createNamedQuery("logEntity.getTimeToResolutionAvgBetweenDates", Double.class)
                .setParameter("from", from)
                .setParameter("to", to)
                .setParameter("type", LogType.TIME_TO_RESOLUTION_ADDED)
                .getSingleResult();
/*    }  catch (NullPointerException e) {
        return 0;*/
    }   catch (Exception e) {
        LOG.warn("Exception while attempting to get request", e);
        throw e;
    }

    }

    public Long countLogsNumberBetweenDates(Calendar from, Calendar to, LogType type, String newValue) {
        try {
        return getEntityManager().createNamedQuery("logEntity.countLogsByTypeAndNewValueBetweenDates", Long.class)
                .setParameter("from", from)
                .setParameter("to", to)
                .setParameter("type",type)
                .setParameter("newValue",newValue)
                .getSingleResult();
/*    }  catch (NullPointerException e) {
        return 0;*/
    }   catch (Exception e) {
        LOG.warn("Exception while attempting to get request", e);
        throw e;
    }

    }

    public Long countLogsNumberBetweenDates(Calendar from, Calendar to, LogType type) {
        try {
        return getEntityManager().createNamedQuery("logEntity.countLogsByTypeBetweenDates", Long.class)
                .setParameter("from", from)
                .setParameter("to", to)
                .setParameter("type",type)
                .getSingleResult();
/*    }  catch (NullPointerException e) {
        return 0;*/
    }   catch (Exception e) {
        LOG.warn("Exception while attempting to get request", e);
        throw e;
    }

    }
    public Long countLogsNumber( LogType type, String newValue) {
        try {
        return getEntityManager().createNamedQuery("logEntity.countLogsByTypeAndNewValue", Long.class)
                .setParameter("type",type)
                .setParameter("newValue",newValue)
                .getSingleResult();
/*    }  catch (NullPointerException e) {
        return 0;*/
    }   catch (Exception e) {
        LOG.warn("Exception while attempting to get request", e);
        throw e;
    }

    }

    public List<LogEntity> getFirstLogByType(LogType type) {
        try {

            return getEntityManager().createNamedQuery("logEntity.findByType", LogEntity.class)
                    .setParameter("type", type)
                    .setFirstResult(0)
                    .setMaxResults(1)
                    .getResultList();

        } catch (Exception e) {
            LOG.warn("Exception while attempting to get first log", e);
            throw e;
        }
    }

    public List<LogEntity> getByType(LogType type, int offset, int limit) {
        try {
            if (offset >= 0 && limit > 0) {
                return getEntityManager().createNamedQuery("logEntity.findByType", LogEntity.class)
                        .setParameter("type", type)
                        .setFirstResult(offset)
                        .setMaxResults(limit)
                        .getResultList();
            }
            return getEntityManager().createNamedQuery("logEntity.findByType", LogEntity.class)
                    .setParameter("type", type)
                    .getResultList();

        } catch (Exception e) {
            LOG.warn("Exception while attempting to get first log", e);
            throw e;
        }
    }

    public List<LogEntity> getTimeToFirstResponseFirstLog() {
        try {

            return getEntityManager().createNamedQuery("logEntity.findByType", LogEntity.class)
                    .setParameter("type", LogType.TIME_TO_FIRST_RESPONSE_ADDED)
                    .setFirstResult(0)
                    .setMaxResults(1)
                    .getResultList();

        } catch (Exception e) {
            LOG.warn("Exception while attempting to get first log", e);
            throw e;
        }
    }
    public List<LogEntity> getTimeToResolutionFirstLog() {
        try {

            return getEntityManager().createNamedQuery("logEntity.findByType", LogEntity.class)
                    .setParameter("type", LogType.TIME_TO_RESOLUTION_ADDED)
                    .setFirstResult(0)
                    .setMaxResults(1)
                    .getResultList();

        } catch (Exception e) {
            LOG.warn("Exception while attempting to get first log", e);
            throw e;
        }
    }
}
