/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.service.listener;

import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.cs.dao.LogDAO;
import org.exoplatform.cs.dto.LogType;
import org.exoplatform.cs.entity.LogEntity;
import org.exoplatform.cs.entity.TopicEntity;
import org.exoplatform.cs.integration.notification.CSStatusChangedNotificationPlugin;
import org.exoplatform.cs.integration.notification.CSTicketAssignedNotificationPlugin;
import org.exoplatform.cs.integration.notification.CSTicketAssignedToMeNotificationPlugin;
import org.exoplatform.cs.integration.notification.CSTicketClosedNotificationPlugin;
import org.exoplatform.cs.service.util.ForumUtils;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.MessageBuilder;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.ResourceBundleService;

public class TicketUpdatedLogListener
extends Listener<TopicEntity, Map<String, String>> {
    private static final Log LOG = ExoLogger.getLogger(TicketUpdatedLogListener.class);
    private static final String STATUS_RB = "cs.ticket.status.";
    private static final String TICKET_STATUS_UPDATED_MESSAGE = "cs.ticket.status.updated";
    private static final String TICKET_TYPE_UPDATED_MESSAGE = "cs.ticket.type.updated";
    private static final String TICKET_SEVERITY_UPDATED_MESSAGE = "cs.ticket.severity.updated";
    private static final String TYPE_RB = "cs.ticket.type.";
    private static final String SEVERITY_RB = "cs.ticket.severity.";
    private LogDAO logDAO;
    private ForumService forumService;
    private ResourceBundleService resourceBundleService;

    public TicketUpdatedLogListener(LogDAO logDAO, ForumService forumService, ResourceBundleService resourceBundleService) {
        this.logDAO = logDAO;
        this.forumService = forumService;
        this.resourceBundleService = resourceBundleService;
    }

    public void onEvent(Event<TopicEntity, Map<String, String>> event) throws Exception {
        String userSatisfaction;
        String timeToResolution;
        String timeToFirstResponse;
        ResourceBundle resourceBundle = this.resourceBundleService.getResourceBundle("locale.customer-space", Locale.getDefault());
        TopicEntity ticket = (TopicEntity)event.getSource();
        Map data = (Map)event.getData();
        String userID = (String)data.get("user.id");
        Calendar now = Calendar.getInstance();
        String oldAssignee = (String)data.get("ticket.assignee.old");
        String newAssignee = (String)data.get("ticket.assignee.new");
        if (newAssignee != null) {
            LOG.info("Assignee changed from {} to {}", new Object[]{oldAssignee, newAssignee});
            LogEntity logEntity = new LogEntity(LogType.TICKET_ASSIGNEE_CHANGED, userID, now, oldAssignee, newAssignee, ticket, null, null);
            this.logDAO.create(logEntity);
            NotificationContext ctx = NotificationContextImpl.cloneInstance().append(CSTicketAssignedNotificationPlugin.TICKET, (Object)ticket).append(CSTicketAssignedToMeNotificationPlugin.LOG_ENTITY, (Object)logEntity);
            ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)"CSTicketAssignedNotificationPlugin"))).execute(ctx);
        }
        String oldType = (String)data.get("ticket.type.old");
        String newType = (String)data.get("ticket.type.new");
        if (oldType != null && newType != null) {
            LOG.info("Type changed from {} to {}", new Object[]{oldType, newType});
            LogEntity logEntity = new LogEntity(LogType.TICKET_TYPE_CHANGED, userID, now, oldType, newType, ticket, null, null);
            this.logDAO.create(logEntity);
        }
        String oldSeverity = (String)data.get("ticket.severity.old");
        String newSeverity = (String)data.get("ticket.severity.new");
        if (oldSeverity != null && newSeverity != null) {
            LOG.info("Severity changed from {} to {}", new Object[]{oldSeverity, newSeverity});
            LogEntity logEntity = new LogEntity(LogType.TICKET_SEVERITY_CHANGED, userID, now, oldSeverity, newSeverity, ticket, null, null);
            this.logDAO.create(logEntity);
        }
        String oldStatus = (String)data.get("ticket.status.old");
        String newStatus = (String)data.get("ticket.status.new");
        if (oldStatus != null && newStatus != null) {
            Topic topic;
            LOG.info("Status changed from {} to {}", new Object[]{oldStatus, newStatus});
            LogEntity logEntity = new LogEntity(LogType.TICKET_STATUS_CHANGED, userID, now, oldStatus, newStatus, ticket, null, null);
            this.logDAO.create(logEntity);
            if ("closed".equalsIgnoreCase(newStatus)) {
                topic = ForumUtils.getTopicByTicket(this.forumService, ticket);
                topic.setTopicName("[Resolved]" + topic.getTopicName());
                topic.setModifiedBy((String)data.get("user.id"));
                this.forumService.saveTopic(topic.getCategoryId(), topic.getForumId(), topic, false, false, new MessageBuilder());
                NotificationContext ctx = NotificationContextImpl.cloneInstance().append(CSTicketClosedNotificationPlugin.TICKET, (Object)ticket).append(CSTicketAssignedToMeNotificationPlugin.LOG_ENTITY, (Object)logEntity);
                ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)"CSTicketClosedNotificationPlugin"))).execute(ctx);
            }
            if ("closed".equalsIgnoreCase(oldStatus)) {
                topic = ForumUtils.getTopicByTicket(this.forumService, ticket);
                topic.setTopicName(topic.getTopicName().replace("[Resolved]", ""));
                topic.setModifiedBy((String)data.get("user.id"));
                this.forumService.saveTopic(topic.getCategoryId(), topic.getForumId(), topic, false, false, new MessageBuilder());
            }
            NotificationContext ctx = NotificationContextImpl.cloneInstance().append(CSStatusChangedNotificationPlugin.TICKET, (Object)ticket).append(CSTicketAssignedToMeNotificationPlugin.LOG_ENTITY, (Object)logEntity);
            ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)"CSStatusChangedNotificationPlugin"))).execute(ctx);
        }
        if ((timeToFirstResponse = (String)data.get("ticket.time.to.first.response")) != null) {
            LogEntity logEntity = new LogEntity(LogType.TIME_TO_FIRST_RESPONSE_ADDED, userID, now, "", "", ticket, Long.getLong(timeToFirstResponse), null);
            this.logDAO.create(logEntity);
        }
        if ((timeToResolution = (String)data.get("ticket.time.to.resolution")) != null) {
            LogEntity logEntity = new LogEntity(LogType.TIME_TO_RESOLUTION_ADDED, userID, now, "", "", ticket, null, Long.getLong(timeToResolution));
            this.logDAO.create(logEntity);
        }
        if ((userSatisfaction = (String)data.get("ticket.customer.satisfaction.new")) != null) {
            LogEntity logEntity = new LogEntity(LogType.CUSTOMER_SATISFACTION_ADDED, userID, now, "", userSatisfaction, ticket, null, null);
            this.logDAO.create(logEntity);
        }
    }

    private String replaceVarsInBundle(String bundle, String ... strings) {
        for (int i = 0; i < strings.length; ++i) {
            bundle = bundle.replace("{" + i + "}", strings[i]);
        }
        return bundle;
    }
}

